/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import com.lemckes.cellarboss.CellarBoss;
import com.lemckes.cellarboss.IdName;
import com.lemckes.cellarboss.IdNameList;
import javax.swing.table.AbstractTableModel;

public class WineriesIdNameTableModel
extends AbstractTableModel
implements IdNameList.UpdateListener {
    IdNameList idNameList;

    public WineriesIdNameTableModel(IdNameList idNameList) {
        this.idNameList = idNameList;
        idNameList.addUpdateListener(this);
    }

    @Override
    public void idNameDataUpdated() {
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        return Columns.values()[column].displayName;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Columns.values()[columnIndex].klass;
    }

    @Override
    public int getRowCount() {
        int count = 0;
        if (this.idNameList != null) {
            count = this.idNameList.size();
        }
        return count;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value = null;
        Columns col = Columns.values()[column];
        IdName idName = (IdName)this.idNameList.get(row);
        switch (col) {
            case ID: {
                value = idName.getId();
                break;
            }
            case NAME: {
                value = idName.getName();
                break;
            }
            case REGION: {
                Integer defaultRegion = CellarBoss.getWineList().getDefaultRegion(idName.getId());
                if (defaultRegion == null) break;
                value = CellarBoss.getWineList().getRegions().findIdNameForId(defaultRegion).getName();
            }
        }
        return value;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public static enum Columns {
        ID("Id", Integer.class),
        NAME("Name", String.class),
        REGION("Default Region", String.class);

        String displayName;
        Class klass;

        private Columns(String name, Class clasz) {
            this.displayName = name;
            this.klass = clasz;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Class getColumnClass() {
            return this.klass;
        }
    }
}

