/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import com.lemckes.cellarboss.CellarBoss;
import com.lemckes.cellarboss.IdName;
import com.lemckes.cellarboss.IdNameList;
import com.lemckes.cellarboss.IdNameWithDefaultManagerView;
import com.lemckes.cellarboss.WineriesIdNameTableModel;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

public class WineriesManagerView
extends IdNameWithDefaultManagerView {
    private static final String DEFAULT_LABEL = "Region";

    public WineriesManagerView(IdNameList idNameList, IdNameList idNameSelectorList) {
        super(idNameList, idNameSelectorList, DEFAULT_LABEL);
        this.idNameSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WineriesManagerView.this.checkInput();
                    }
                });
            }
        });
    }

    @Override
    protected void setTableModel() {
        this.getDataTable().setModel(new WineriesIdNameTableModel(this.idNameList));
    }

    @Override
    public void setSelectorModels() {
        IdName sel = this.idNameSelector.getSelected();
        this.idNameSelector.setIdNames(CellarBoss.getWineList().getRegions());
        this.idNameSelector.setSelected(sel);
    }

    @Override
    protected void checkInput() {
        boolean regionChanged;
        boolean enabled = false;
        boolean hasText = this.getNameFieldText().length() > 0;
        boolean textChanged = !this.editIdName.getName().equals(this.getNameFieldText());
        boolean textUnique = !this.idNameList.containsName(this.getNameFieldText());
        Integer winery = this.editIdName.getId();
        Integer region = null;
        if (this.idNameSelector.getSelected() != null) {
            region = this.idNameSelector.getSelected().getId();
        }
        Integer defaultRegion = CellarBoss.getWineList().getDefaultRegion(winery);
        boolean bl = regionChanged = region != CellarBoss.getWineList().getDefaultRegion(winery);
        if (hasText) {
            enabled = textChanged && textUnique || !textChanged && regionChanged;
        }
        this.enableSaveButton(enabled);
    }

    @Override
    protected boolean saveDefaultRecord() throws SQLException {
        boolean saved = true;
        Integer winery = this.editIdName.getId();
        winery = CellarBoss.getWineList().getWineries().findIdNameForName(this.editIdName.getName()).getId();
        Integer region = this.idNameSelector.getSelected().getId();
        CellarBoss.getWineList().setWineryRegion(winery, region);
        return saved;
    }

    @Override
    protected void newRecord() {
        super.newRecord();
        this.idNameSelector.setSelected((IdName)null);
    }

    @Override
    protected void editRecord() {
        super.editRecord();
        Integer winery = this.editIdName.getId();
        Integer region = CellarBoss.getWineList().getDefaultRegion(winery);
        this.idNameSelector.setSelected(region);
    }

    @Override
    protected void deleteRecord() {
        super.deleteRecord();
        Integer winery = this.editIdName.getId();
        CellarBoss.getWineList().deleteDefaultRegion(winery);
    }
}

