/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.DefaultHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXhtmlExporter
extends JRAbstractExporter {
    private static final Log log = LogFactory.getLog(JRXhtmlExporter.class);
    private static final String XHTML_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xhtml.";
    public static final String XHTML_EXPORTER_KEY = "net.sf.jasperreports.xhtml";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String CSS_TEXT_ALIGN_RIGHT = "right";
    protected static final String CSS_TEXT_ALIGN_CENTER = "center";
    protected static final String CSS_TEXT_ALIGN_JUSTIFY = "justify";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String HTML_VERTICAL_ALIGN_MIDDLE = "middle";
    protected static final String HTML_VERTICAL_ALIGN_BOTTOM = "bottom";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected Writer writer = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageMaps;
    protected List imagesToProcess = null;
    protected int reportIndex = 0;
    protected int pageIndex = 0;
    protected List frameIndexStack = null;
    protected int elementIndex = 0;
    protected File imagesDir = null;
    protected String imagesURI = null;
    protected boolean isOutputImagesToDir = false;
    protected boolean isWhitePageBackground;
    protected String encoding;
    protected String sizeUnit = null;
    protected boolean isWrapBreakWord;
    protected boolean isIgnorePageMargins;
    protected String htmlHeader = null;
    protected String betweenPagesHtml = null;
    protected String htmlFooter = null;
    protected Map fontMap = null;
    protected JRHyperlinkTargetProducerFactory targetProducerFactory = new DefaultHyperlinkTargetProducerFactory();
    protected boolean hyperlinkStarted = false;
    protected JRHtmlExporterContext exporterContext = new ExporterContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block57: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                String uri;
                String dir;
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(XHTML_EXPORTER_PROPERTIES_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.htmlHeader = (String)this.parameters.get(JRHtmlExporterParameter.HTML_HEADER);
                this.betweenPagesHtml = (String)this.parameters.get(JRHtmlExporterParameter.BETWEEN_PAGES_HTML);
                this.htmlFooter = (String)this.parameters.get(JRHtmlExporterParameter.HTML_FOOTER);
                this.imagesDir = (File)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR);
                if (this.imagesDir == null && (dir = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR_NAME)) != null) {
                    this.imagesDir = new File(dir);
                }
                this.isWhitePageBackground = this.getBooleanParameter(JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, "net.sf.jasperreports.export.xls.white.page.background", true);
                Boolean isOutputImagesToDirParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR);
                if (isOutputImagesToDirParameter != null) {
                    this.isOutputImagesToDir = isOutputImagesToDirParameter;
                }
                if ((uri = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_URI)) != null) {
                    this.imagesURI = uri;
                }
                this.encoding = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
                this.rendererToImagePathMap = new HashMap();
                this.imageMaps = new HashMap();
                this.imagesToProcess = new ArrayList();
                this.isWrapBreakWord = this.getBooleanParameter(JRHtmlExporterParameter.IS_WRAP_BREAK_WORD, "net.sf.jasperreports.export.html.wrap.break.word", false);
                this.sizeUnit = this.getStringParameterOrDefault(JRHtmlExporterParameter.SIZE_UNIT, "net.sf.jasperreports.export.html.size.unit");
                this.isIgnorePageMargins = this.getBooleanParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, "net.sf.jasperreports.export.ignore.page.margins", false);
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (sb != null) {
                    try {
                        this.writer = new StringWriter();
                        this.exportReportToWriter();
                        sb.append(this.writer.toString());
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
                    }
                    finally {
                        if (this.writer != null) {
                            try {
                                this.writer.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (this.writer != null) {
                    try {
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.writer = new OutputStreamWriter(os, this.encoding);
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.writer = new OutputStreamWriter(os, this.encoding);
                }
                catch (IOException e) {
                    throw new JRException("Error creating to file writer : " + this.jasperPrint.getName(), e);
                }
                if (this.imagesDir == null) {
                    this.imagesDir = new File(destFile.getParent(), destFile.getName() + "_files");
                }
                if (isOutputImagesToDirParameter == null) {
                    this.isOutputImagesToDir = true;
                }
                if (this.imagesURI == null) {
                    this.imagesURI = this.imagesDir.getName() + "/";
                }
                try {
                    this.exportReportToWriter();
                }
                catch (IOException e) {
                    throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
                }
                finally {
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (!this.isOutputImagesToDir) break block57;
                if (this.imagesDir == null) {
                    throw new JRException("The images directory was not specified for the exporter.");
                }
                if (this.imagesToProcess == null || this.imagesToProcess.size() <= 0) break block57;
                if (!this.imagesDir.exists()) {
                    this.imagesDir.mkdir();
                }
                Iterator it = this.imagesToProcess.iterator();
                while (it.hasNext()) {
                    JRPrintElementIndex imageIndex = (JRPrintElementIndex)it.next();
                    JRPrintImage image = JRXhtmlExporter.getImage(this.jasperPrintList, imageIndex);
                    JRRenderable renderer = image.getRenderer();
                    if (renderer.getType() == 1) {
                        renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), 1 == image.getMode() ? image.getBackcolor() : null);
                    }
                    byte[] imageData = renderer.getImageData();
                    File imageFile = new File(this.imagesDir, JRXhtmlExporter.getImageName(imageIndex));
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(imageFile);
                        fos.write(imageData, 0, imageData.length);
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to image file : " + imageFile, e);
                    }
                    finally {
                        if (fos == null) continue;
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public static JRPrintImage getImage(List jasperPrintList, String imageName) {
        return JRXhtmlExporter.getImage(jasperPrintList, JRXhtmlExporter.getPrintElementIndex(imageName));
    }

    public static JRPrintImage getImage(List jasperPrintList, JRPrintElementIndex imageIndex) {
        JasperPrint report = (JasperPrint)jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = (JRPrintPage)report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        Object element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        return (JRPrintImage)element;
    }

    protected void exportReportToWriter() throws JRException, IOException {
        if (this.htmlHeader == null) {
            this.writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <title></title>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\"/>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(this.htmlHeader);
        }
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = (JRPrintPage)pages.get(this.pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1) + "\"></a>\n");
                    this.exportPage(page);
                    if (this.reportIndex < this.jasperPrintList.size() - 1 || this.pageIndex < this.endPageIndex) {
                        if (this.betweenPagesHtml == null) {
                            this.writer.write("<br/>\n<br/>\n");
                        } else {
                            this.writer.write(this.betweenPagesHtml);
                        }
                    }
                    this.writer.write("\n");
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (this.htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(this.htmlFooter);
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.writer.write("<div style=\"position:relative;width:" + this.jasperPrint.getPageWidth() + this.sizeUnit + ";height:" + this.jasperPrint.getPageHeight() + this.sizeUnit + ";\">\n");
        this.frameIndexStack = new ArrayList();
        this.exportElements(page.getElements());
        this.writer.write("</div>");
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(List elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                this.elementIndex = i;
                JRPrintElement element = (JRPrintElement)elements.get(i);
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportRectangle((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                    continue;
                }
                if (!(element instanceof JRGenericPrintElement)) continue;
                this.exportGenericElement((JRGenericPrintElement)element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        this.writer.write("<span");
        this.appendId(line);
        StringBuffer styleBuffer = new StringBuffer();
        this.appendPositionStyle(line, styleBuffer);
        this.appendSizeStyle((JRPrintElement)line, line.getLinePen(), styleBuffer);
        this.appendBackcolorStyle(line, styleBuffer);
        String side = null;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirection() == 1 ? HTML_VERTICAL_ALIGN_TOP : HTML_VERTICAL_ALIGN_BOTTOM) : (line.getDirection() == 1 ? CSS_TEXT_ALIGN_LEFT : CSS_TEXT_ALIGN_RIGHT);
        this.appendPen(styleBuffer, line.getLinePen(), side);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write("></span>\n");
    }

    protected void exportRectangle(JRPrintGraphicElement element) throws IOException {
        this.writer.write("<span");
        this.appendId(element);
        StringBuffer styleBuffer = new StringBuffer();
        this.appendPositionStyle(element, styleBuffer);
        this.appendSizeStyle((JRPrintElement)element, element.getLinePen(), styleBuffer);
        this.appendBackcolorStyle(element, styleBuffer);
        this.appendPen(styleBuffer, element.getLinePen(), null);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write("></span>\n");
    }

    protected void exportStyledText(JRStyledText styledText, Locale locale) throws IOException {
        this.exportStyledText(styledText, null, locale);
    }

    protected void exportStyledText(JRStyledText styledText, String tooltip, Locale locale) throws IOException {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        boolean first = true;
        boolean startedSpan = false;
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            if (first && runLimit < styledText.length() && tooltip != null) {
                startedSpan = true;
                this.writer.write("<span title=\"");
                this.writer.write(JRStringUtil.xmlEncode(tooltip));
                this.writer.write("\">");
                tooltip = null;
            }
            first = false;
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), tooltip, locale);
            iterator.setIndex(runLimit);
        }
        if (startedSpan) {
            this.writer.write("</span>");
        }
    }

    protected void exportStyledTextRun(Map attributes, String text, Locale locale) throws IOException {
        this.exportStyledTextRun(attributes, text, null, locale);
    }

    protected void exportStyledTextRun(Map attributes, String text, String tooltip, Locale locale) throws IOException {
        Color runBackcolor;
        String fontFamilyAttr;
        String fontFamily = fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
        if (this.fontMap != null && this.fontMap.containsKey(fontFamilyAttr)) {
            fontFamily = (String)this.fontMap.get(fontFamilyAttr);
        } else {
            FontFamily family;
            String exportFont;
            FontInfo fontInfo = JRFontUtil.getFontInfo(fontFamilyAttr, locale);
            if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.getExporterKey())) != null) {
                fontFamily = exportFont;
            }
        }
        this.writer.write("<span style=\"font-family: ");
        this.writer.write(fontFamily);
        this.writer.write("; ");
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!this.hyperlinkStarted || !Color.black.equals(forecolor)) {
            this.writer.write("color: #");
            this.writer.write(JRColorUtil.getColorHexa(forecolor));
            this.writer.write("; ");
        }
        if ((runBackcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null) {
            this.writer.write("background-color: #");
            this.writer.write(JRColorUtil.getColorHexa(runBackcolor));
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(String.valueOf(attributes.get(TextAttribute.SIZE)));
        this.writer.write(this.sizeUnit);
        this.writer.write(";");
        if (TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT))) {
            this.writer.write(" font-weight: bold;");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE))) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: super;");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: sub;");
        }
        this.writer.write("\"");
        if (tooltip != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(tooltip));
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(JRStringUtil.htmlEncode(text));
        this.writer.write("</span>");
    }

    protected void exportText(JRPrintText text) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\"></a>");
        }
        this.writer.write("<span");
        this.appendId(text);
        if (text.getRunDirection() == 1) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.appendPositionStyle(text, styleBuffer);
        this.appendSizeStyle((JRPrintElement)text, text, styleBuffer);
        this.appendBackcolorStyle(text, styleBuffer);
        this.appendBorderStyle(text.getLineBox(), styleBuffer);
        String horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
        if (textLength > 0) {
            switch (text.getHorizontalAlignment()) {
                case 3: {
                    horizontalAlignment = CSS_TEXT_ALIGN_RIGHT;
                    break;
                }
                case 2: {
                    horizontalAlignment = CSS_TEXT_ALIGN_CENTER;
                    break;
                }
                case 4: {
                    horizontalAlignment = CSS_TEXT_ALIGN_JUSTIFY;
                    break;
                }
                default: {
                    horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
                }
            }
            styleBuffer.append("text-align: ");
            styleBuffer.append(horizontalAlignment);
            styleBuffer.append(";");
            String verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
            switch (text.getVerticalAlignment()) {
                case 3: {
                    verticalAlignment = HTML_VERTICAL_ALIGN_BOTTOM;
                    break;
                }
                case 2: {
                    verticalAlignment = HTML_VERTICAL_ALIGN_MIDDLE;
                    break;
                }
                default: {
                    verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
                }
            }
            if (!verticalAlignment.equals(HTML_VERTICAL_ALIGN_TOP)) {
                styleBuffer.append(" vertical-align: ");
                styleBuffer.append(verticalAlignment);
                styleBuffer.append(";");
            }
        }
        if (this.isWrapBreakWord) {
            styleBuffer.append("width: " + text.getWidth() + this.sizeUnit + "; ");
            styleBuffer.append("word-wrap: break-word; ");
        }
        if (text.getLineSpacing() != 0) {
            styleBuffer.append("line-height: " + text.getLineSpacingFactor() + "; ");
        }
        if (text.getLineBreakOffsets() != null) {
            styleBuffer.append("white-space: nowrap; ");
        }
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.startHyperlink(text);
        if (textLength > 0) {
            String textTooltip = this.hyperlinkStarted ? null : text.getHyperlinkTooltip();
            this.exportStyledText(styledText, textTooltip, this.getTextLocale(text));
        }
        this.endHyperlink();
        this.writer.write("</span>\n");
    }

    protected boolean startHyperlink(JRPrintHyperlink link) throws IOException {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
            if (link.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(link.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        this.hyperlinkStarted = href != null;
        return this.hyperlinkStarted;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target;
        block10: {
            JRHyperlinkTargetProducer producer;
            block9: {
                target = null;
                producer = this.targetProducerFactory.getHyperlinkTargetProducer(link.getLinkTarget());
                if (producer != null) break block9;
                switch (link.getHyperlinkTarget()) {
                    case 2: {
                        target = "_blank";
                        break;
                    }
                    case 3: {
                        target = "_parent";
                        break;
                    }
                    case 4: {
                        target = "_top";
                        break;
                    }
                    case 5: {
                        List parameters;
                        boolean paramFound = false;
                        List list = parameters = link.getHyperlinkParameters() == null ? null : link.getHyperlinkParameters().getParameters();
                        if (parameters != null) {
                            Iterator it = parameters.iterator();
                            while (it.hasNext()) {
                                JRPrintHyperlinkParameter parameter = (JRPrintHyperlinkParameter)it.next();
                                if (!link.getLinkTarget().equals(parameter.getName())) continue;
                                target = parameter.getValue() == null ? null : parameter.getValue().toString();
                                paramFound = true;
                                break;
                            }
                        }
                        if (!paramFound) {
                            target = link.getLinkTarget();
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block10;
            }
            target = producer.getHyperlinkTarget(link);
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block12: {
                href = null;
                customHandler = this.getCustomHandler(link);
                if (customHandler != null) break block12;
                switch (link.getHyperlinkType()) {
                    case 2: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case 3: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case 4: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case 5: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case 6: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void endHyperlink() throws IOException {
        if (this.hyperlinkStarted) {
            this.writer.write("</a>");
        }
        this.hyperlinkStarted = false;
    }

    protected boolean appendBorderStyle(JRLineBox box, StringBuffer styleBuffer) {
        boolean addedToStyle = false;
        if (box != null) {
            addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), HTML_VERTICAL_ALIGN_TOP);
            addedToStyle |= this.appendPadding(styleBuffer, box.getTopPadding(), HTML_VERTICAL_ALIGN_TOP);
            addedToStyle |= this.appendPen(styleBuffer, box.getLeftPen(), CSS_TEXT_ALIGN_LEFT);
            addedToStyle |= this.appendPadding(styleBuffer, box.getLeftPadding(), CSS_TEXT_ALIGN_LEFT);
            addedToStyle |= this.appendPen(styleBuffer, box.getBottomPen(), HTML_VERTICAL_ALIGN_BOTTOM);
            addedToStyle |= this.appendPadding(styleBuffer, box.getBottomPadding(), HTML_VERTICAL_ALIGN_BOTTOM);
            addedToStyle |= this.appendPen(styleBuffer, box.getRightPen(), CSS_TEXT_ALIGN_RIGHT);
            addedToStyle |= this.appendPadding(styleBuffer, box.getRightPadding(), CSS_TEXT_ALIGN_RIGHT);
        }
        return addedToStyle;
    }

    protected int getInsideBorderOffset(float borderWidth) {
        int intBorderWidth = (int)borderWidth;
        if (0.0f < borderWidth && borderWidth < 1.0f) {
            intBorderWidth = 1;
        }
        return intBorderWidth / 2 + intBorderWidth % 2;
    }

    protected void appendSizeStyle(JRPrintElement element, JRBoxContainer boxContainer, StringBuffer styleBuffer) {
        JRLineBox box;
        int widthDiff = 0;
        int heightDiff = 0;
        JRLineBox jRLineBox = box = boxContainer == null ? null : boxContainer.getLineBox();
        if (box != null) {
            widthDiff = box.getLeftPadding() + box.getRightPadding() + this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue()) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue());
            heightDiff = box.getTopPadding() + box.getBottomPadding() + this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue()) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue());
        }
        styleBuffer.append("width:");
        styleBuffer.append(element.getWidth() - widthDiff);
        styleBuffer.append(this.sizeUnit);
        styleBuffer.append(";");
        styleBuffer.append("height:");
        styleBuffer.append(element.getHeight() - heightDiff);
        styleBuffer.append(this.sizeUnit);
        styleBuffer.append(";");
    }

    protected void appendSizeStyle(JRPrintElement element, JRPen pen, StringBuffer styleBuffer) {
        int diff = 0;
        if (pen != null) {
            diff = 2 * this.getInsideBorderOffset(pen.getLineWidth().floatValue());
        }
        styleBuffer.append("width:");
        styleBuffer.append(element.getWidth() - diff);
        styleBuffer.append(this.sizeUnit);
        styleBuffer.append(";");
        styleBuffer.append("height:");
        styleBuffer.append(element.getHeight() - diff);
        styleBuffer.append(this.sizeUnit);
        styleBuffer.append(";");
    }

    protected void appendPositionStyle(JRPrintElement element, StringBuffer styleBuffer) {
        styleBuffer.append("position:absolute;");
        styleBuffer.append("left:");
        styleBuffer.append(element.getX());
        styleBuffer.append(this.sizeUnit);
        styleBuffer.append(";");
        styleBuffer.append("top:");
        styleBuffer.append(element.getY());
        styleBuffer.append(this.sizeUnit);
        styleBuffer.append(";");
    }

    protected void appendBackcolorStyle(JRPrintElement element, StringBuffer styleBuffer) {
        if (element.getMode() == 1) {
            styleBuffer.append("background-color: #");
            styleBuffer.append(JRColorUtil.getColorHexa(element.getBackcolor()));
            styleBuffer.append("; ");
        }
    }

    protected void exportImage(JRPrintImage image) throws JRException, IOException {
        JRRenderable renderer;
        this.writer.write("<span");
        this.appendId(image);
        float xAlignFactor = 0.0f;
        switch (image.getHorizontalAlignment()) {
            case 3: {
                xAlignFactor = 1.0f;
                break;
            }
            case 2: {
                xAlignFactor = 0.5f;
                break;
            }
            default: {
                xAlignFactor = 0.0f;
            }
        }
        float yAlignFactor = 0.0f;
        switch (image.getVerticalAlignment()) {
            case 3: {
                yAlignFactor = 1.0f;
                break;
            }
            case 2: {
                yAlignFactor = 0.5f;
                break;
            }
            default: {
                yAlignFactor = 0.0f;
            }
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.appendPositionStyle(image, styleBuffer);
        this.appendSizeStyle((JRPrintElement)image, image, styleBuffer);
        this.appendBackcolorStyle(image, styleBuffer);
        boolean addedToStyle = this.appendBorderStyle(image.getLineBox(), styleBuffer);
        if (!addedToStyle) {
            this.appendPen(styleBuffer, image.getLinePen(), null);
        }
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\"></a>");
        }
        JRRenderable originalRenderer = renderer = image.getRenderer();
        boolean imageMapRenderer = renderer != null && renderer instanceof JRImageMapRenderer && ((JRImageMapRenderer)renderer).hasImageAreaHyperlinks();
        boolean hasHyperlinks = false;
        if (renderer != null) {
            int availableImageHeight;
            if (imageMapRenderer) {
                hasHyperlinks = true;
                this.hyperlinkStarted = false;
            } else {
                hasHyperlinks = this.startHyperlink(image);
            }
            this.writer.write("<img");
            String imagePath = null;
            String imageMapName = null;
            List imageMapAreas = null;
            byte scaleImage = image.getScaleImage();
            if (renderer != null) {
                if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                    imagePath = (String)this.rendererToImagePathMap.get(renderer.getId());
                } else {
                    if (image.isLazy()) {
                        imagePath = ((JRImageRenderer)renderer).getImageLocation();
                    } else {
                        JRPrintElementIndex imageIndex = this.getElementIndex();
                        this.imagesToProcess.add(imageIndex);
                        String imageName = JRXhtmlExporter.getImageName(imageIndex);
                        imagePath = this.imagesURI + imageName;
                    }
                    this.rendererToImagePathMap.put(renderer.getId(), imagePath);
                }
                if (imageMapRenderer) {
                    Rectangle renderingArea = new Rectangle(image.getWidth(), image.getHeight());
                    if (renderer.getType() == 0) {
                        imageMapName = (String)this.imageMaps.get(new Pair(renderer.getId(), renderingArea));
                    }
                    if (imageMapName == null) {
                        imageMapName = "map_" + this.getElementIndex().toString();
                        imageMapAreas = ((JRImageMapRenderer)originalRenderer).getImageAreaHyperlinks(renderingArea);
                        if (renderer.getType() == 0) {
                            this.imageMaps.put(new Pair(renderer.getId(), renderingArea), imageMapName);
                        }
                    }
                }
            }
            this.writer.write(" src=\"");
            if (imagePath != null) {
                this.writer.write(imagePath);
            }
            this.writer.write("\"");
            int availableImageWidth = image.getWidth() - image.getLineBox().getLeftPadding() - image.getLineBox().getRightPadding();
            if (availableImageWidth < 0) {
                availableImageWidth = 0;
            }
            if ((availableImageHeight = image.getHeight() - image.getLineBox().getTopPadding() - image.getLineBox().getBottomPadding()) < 0) {
                availableImageHeight = 0;
            }
            switch (scaleImage) {
                case 2: {
                    int leftDiff = 0;
                    int topDiff = 0;
                    int widthDiff = 0;
                    int heightDiff = 0;
                    JRLineBox box = image.getLineBox();
                    if (box != null) {
                        leftDiff = box.getLeftPadding();
                        topDiff = box.getTopPadding();
                        widthDiff = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue()) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue());
                        heightDiff = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue()) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue());
                    }
                    this.writer.write(" style=\"position:absolute;left:");
                    this.writer.write(String.valueOf(leftDiff));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(";top:");
                    this.writer.write(String.valueOf(topDiff));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(";width:");
                    this.writer.write(String.valueOf(availableImageWidth - widthDiff));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(";height:");
                    this.writer.write(String.valueOf(availableImageHeight - heightDiff));
                    this.writer.write(this.sizeUnit);
                    this.writer.write("\"");
                    break;
                }
                case 1: {
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        JRRenderable tmpRenderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, image.getOnErrorType());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension();
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    int leftDiff = 0;
                    int topDiff = 0;
                    int widthDiff = 0;
                    int heightDiff = 0;
                    JRLineBox box = image.getLineBox();
                    if (box != null) {
                        leftDiff = box.getLeftPadding();
                        topDiff = box.getTopPadding();
                        widthDiff = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue()) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue());
                        heightDiff = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue()) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue());
                    }
                    this.writer.write(" style=\"position:absolute;left:");
                    this.writer.write(String.valueOf((double)leftDiff + (double)xAlignFactor * ((double)(availableImageWidth - widthDiff) - normalWidth)));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(";top:");
                    this.writer.write(String.valueOf((double)topDiff + (double)yAlignFactor * ((double)(availableImageHeight - heightDiff) - normalHeight)));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(";width:");
                    this.writer.write(String.valueOf(normalWidth));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(";height:");
                    this.writer.write(String.valueOf(normalHeight));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(";clip:rect(");
                    this.writer.write(String.valueOf((double)yAlignFactor * (normalHeight - (double)availableImageHeight + (double)heightDiff)));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(",");
                    this.writer.write(String.valueOf((double)xAlignFactor * normalWidth + (double)((1.0f - xAlignFactor) * (float)(availableImageWidth - widthDiff))));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(",");
                    this.writer.write(String.valueOf((double)yAlignFactor * normalHeight + (double)((1.0f - yAlignFactor) * (float)(availableImageHeight - heightDiff))));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(",");
                    this.writer.write(String.valueOf((double)xAlignFactor * (normalWidth - (double)availableImageWidth + (double)widthDiff)));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(")\"");
                    break;
                }
                default: {
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        JRRenderable tmpRenderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, image.getOnErrorType());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension();
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    int leftDiff = 0;
                    int topDiff = 0;
                    int widthDiff = 0;
                    int heightDiff = 0;
                    JRLineBox box = image.getLineBox();
                    if (box != null) {
                        leftDiff = box.getLeftPadding();
                        topDiff = box.getTopPadding();
                        widthDiff = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue()) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue());
                        heightDiff = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue()) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue());
                    }
                    if (availableImageHeight <= 0) break;
                    double ratio = normalWidth / normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        this.writer.write(" style=\"position:absolute;left:");
                        this.writer.write(String.valueOf(leftDiff));
                        this.writer.write(this.sizeUnit);
                        this.writer.write(";top:");
                        this.writer.write(String.valueOf((double)topDiff + (double)yAlignFactor * ((double)(availableImageHeight - heightDiff) - (double)(availableImageWidth - widthDiff) / ratio)));
                        this.writer.write(this.sizeUnit);
                        this.writer.write(";width:");
                        this.writer.write(String.valueOf(availableImageWidth - widthDiff));
                        this.writer.write(this.sizeUnit);
                        this.writer.write("\"");
                        break;
                    }
                    this.writer.write(" style=\"position:absolute;left:");
                    this.writer.write(String.valueOf((double)leftDiff + (double)xAlignFactor * ((double)(availableImageWidth - widthDiff) - ratio * (double)(availableImageHeight - heightDiff))));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(";top:");
                    this.writer.write(String.valueOf(topDiff));
                    this.writer.write(this.sizeUnit);
                    this.writer.write(";height:");
                    this.writer.write(String.valueOf(availableImageHeight - heightDiff));
                    this.writer.write(this.sizeUnit);
                    this.writer.write("\"");
                }
            }
            if (imageMapName != null) {
                this.writer.write(" usemap=\"#" + imageMapName + "\"");
            }
            this.writer.write(" alt=\"\"");
            if (hasHyperlinks) {
                this.writer.write(" border=\"0\"");
            }
            if (image.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(image.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write("/>");
            this.endHyperlink();
            if (imageMapAreas != null) {
                this.writer.write("\n");
                this.writeImageMap(imageMapName, image, imageMapAreas);
            }
        }
        this.writer.write("</span>\n");
    }

    protected JRPrintElementIndex getElementIndex() {
        StringBuffer sbuffer = new StringBuffer();
        for (int i = 0; i < this.frameIndexStack.size(); ++i) {
            Integer frameIndex = (Integer)this.frameIndexStack.get(i);
            sbuffer.append(frameIndex + "_");
        }
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, sbuffer.append(this.elementIndex).toString());
        return imageIndex;
    }

    protected void writeImageMap(String imageMapName, JRPrintImage image, List imageMapAreas) throws IOException {
        this.writer.write("<map name=\"" + imageMapName + "\">\n");
        ListIterator it = imageMapAreas.listIterator(imageMapAreas.size());
        while (it.hasPrevious()) {
            JRPrintImageAreaHyperlink areaHyperlink = (JRPrintImageAreaHyperlink)it.previous();
            JRPrintImageArea area = areaHyperlink.getArea();
            this.writer.write("  <area shape=\"" + JRPrintImageArea.getHtmlShape(area.getShape()) + "\"");
            this.writeImageAreaCoordinates(area.getCoordinates());
            this.writeImageAreaHyperlink(areaHyperlink.getHyperlink());
            this.writer.write("/>\n");
        }
        if (image.getHyperlinkType() != 1) {
            this.writer.write("  <area shape=\"default\"");
            this.writeImageAreaCoordinates(new int[]{0, 0, image.getWidth(), image.getHeight()});
            this.writeImageAreaHyperlink(image);
            this.writer.write("/>\n");
        }
        this.writer.write("</map>\n");
    }

    protected void writeImageAreaCoordinates(int[] coords) throws IOException {
        if (coords != null && coords.length > 0) {
            StringBuffer coordsEnum = new StringBuffer(coords.length * 4);
            coordsEnum.append(coords[0]);
            for (int i = 1; i < coords.length; ++i) {
                coordsEnum.append(',');
                coordsEnum.append(coords[i]);
            }
            this.writer.write(" coords=\"" + coordsEnum + "\"");
        }
    }

    protected void writeImageAreaHyperlink(JRPrintHyperlink hyperlink) throws IOException {
        String href = this.getHyperlinkURL(hyperlink);
        if (href == null) {
            this.writer.write(" nohref=\"nohref\"");
        } else {
            this.writer.write(" href=\"" + href + "\"");
            String target = this.getHyperlinkTarget(hyperlink);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
        }
        if (hyperlink.getHyperlinkTooltip() != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(hyperlink.getHyperlinkTooltip()));
            this.writer.write("\"");
        }
    }

    private boolean appendPadding(StringBuffer sb, Integer padding, String side) {
        boolean addedToStyle = false;
        if (padding > 0) {
            sb.append("padding");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(padding);
            sb.append(this.sizeUnit);
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    private boolean appendPen(StringBuffer sb, JRPen pen, String side) {
        boolean addedToStyle = false;
        float borderWidth = pen.getLineWidth().floatValue();
        if (0.0f < borderWidth && borderWidth < 1.0f) {
            borderWidth = 1.0f;
        }
        String borderStyle = null;
        switch (pen.getLineStyle()) {
            case 3: {
                borderStyle = "double";
                break;
            }
            case 2: {
                borderStyle = "dotted";
                break;
            }
            case 1: {
                borderStyle = "dashed";
                break;
            }
            default: {
                borderStyle = "solid";
            }
        }
        if (borderWidth > 0.0f) {
            sb.append("border");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append("-style: ");
            sb.append(borderStyle);
            sb.append("; ");
            sb.append("border");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append("-width: ");
            sb.append((int)borderWidth);
            sb.append(this.sizeUnit);
            sb.append("; ");
            sb.append("border");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append("-color: #");
            sb.append(JRColorUtil.getColorHexa(pen.getLineColor()));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    private void appendId(JRPrintElement element) throws IOException {
        String id = JRProperties.getProperty(element, "net.sf.jasperreports.export.html.id");
        if (id != null) {
            this.writer.write(" id=\"" + id + "\"");
        }
    }

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    protected void exportFrame(JRPrintFrame frame) throws IOException, JRException {
        this.writer.write("<div");
        this.appendId(frame);
        StringBuffer styleBuffer = new StringBuffer();
        this.appendPositionStyle(frame, styleBuffer);
        this.appendSizeStyle((JRPrintElement)frame, frame, styleBuffer);
        this.appendBackcolorStyle(frame, styleBuffer);
        this.appendBorderStyle(frame.getLineBox(), styleBuffer);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        this.frameIndexStack.add(new Integer(this.elementIndex));
        this.exportElements(frame.getElements());
        this.frameIndexStack.remove(this.frameIndexStack.size() - 1);
        this.writer.write("</div>\n");
    }

    protected void exportGenericElement(JRGenericPrintElement element) throws IOException {
        GenericElementHtmlHandler handler = (GenericElementHtmlHandler)GenericElementHandlerEnviroment.getHandler(element.getGenericType(), XHTML_EXPORTER_KEY);
        if (handler == null) {
            if (log.isDebugEnabled()) {
                log.debug("No XHTML generic element handler for " + element.getGenericType());
            }
        } else {
            this.writer.write("<div");
            StringBuffer styleBuffer = new StringBuffer();
            this.appendPositionStyle(element, styleBuffer);
            this.appendSizeStyle((JRPrintElement)element, (JRBoxContainer)null, styleBuffer);
            this.appendBackcolorStyle(element, styleBuffer);
            if (styleBuffer.length() > 0) {
                this.writer.write(" style=\"");
                this.writer.write(styleBuffer.toString());
                this.writer.write("\"");
            }
            this.writer.write(">");
            String htmlFragment = handler.getHtmlFragment(this.exporterContext, element);
            if (htmlFragment != null) {
                this.writer.write(htmlFragment);
            }
            this.writer.write("</div>\n");
        }
    }

    public Map getExportParameters() {
        return this.parameters;
    }

    public String getExportPropertiesPrefix() {
        return XHTML_EXPORTER_PROPERTIES_PREFIX;
    }

    public JasperPrint getExportedReport() {
        return this.jasperPrint;
    }

    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        short[] lineBreakOffsets;
        JRStyledText styledText = super.getStyledText(textElement, setBackcolor);
        if (styledText != null && (lineBreakOffsets = textElement.getLineBreakOffsets()) != null && lineBreakOffsets.length > 0) {
            styledText = styledText.cloneText();
            styledText.insert("\n", lineBreakOffsets);
        }
        return styledText;
    }

    protected String getExporterKey() {
        return XHTML_EXPORTER_KEY;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRHtmlExporterContext {
        protected ExporterContext() {
        }

        public String getExportPropertiesPrefix() {
            return JRXhtmlExporter.XHTML_EXPORTER_PROPERTIES_PREFIX;
        }

        public String getHyperlinkURL(JRPrintHyperlink link) {
            return JRXhtmlExporter.this.getHyperlinkURL(link);
        }
    }
}

