/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZip;

public class DocxZip
extends FileBufferedZip {
    private ExportZipEntry documentEntry = null;
    private ExportZipEntry stylesEntry = null;
    private ExportZipEntry relsEntry = null;

    public DocxZip() throws IOException {
        this(1);
    }

    public DocxZip(byte openDocumentNature) throws IOException {
        this.exportZipEntries = new ArrayList();
        this.documentEntry = this.createEntry("word/document.xml");
        this.exportZipEntries.add(this.documentEntry);
        this.stylesEntry = this.createEntry("word/styles.xml");
        this.exportZipEntries.add(this.stylesEntry);
        this.relsEntry = this.createEntry("word/_rels/document.xml.rels");
        this.exportZipEntries.add(this.relsEntry);
        this.createRelsEntry();
        this.createContentTypesEntry();
    }

    public ExportZipEntry getDocumentEntry() {
        return this.documentEntry;
    }

    public ExportZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    public ExportZipEntry getRelsEntry() {
        return this.relsEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRelsEntry() throws IOException {
        ExportZipEntry relsEntry = this.createEntry("_rels/.rels");
        Writer relsWriter = null;
        try {
            relsWriter = relsEntry.getWriter();
            relsWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            relsWriter.write("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n");
            relsWriter.write(" <Relationship Id=\"rId1\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\" Target=\"word/document.xml\"/>\n");
            relsWriter.write("</Relationships>\n");
            relsWriter.flush();
            this.exportZipEntries.add(relsEntry);
        }
        finally {
            if (relsWriter != null) {
                try {
                    relsWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContentTypesEntry() throws IOException {
        ExportZipEntry contentTypesEntry = this.createEntry("[Content_Types].xml");
        Writer ctWriter = null;
        try {
            ctWriter = contentTypesEntry.getWriter();
            ctWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            ctWriter.write("<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">\n");
            ctWriter.write("  <Default Extension=\"gif\" ContentType=\"image/gif\"/>\n");
            ctWriter.write("  <Default Extension=\"jpeg\" ContentType=\"image/jpeg\"/>\n");
            ctWriter.write("  <Default Extension=\"png\" ContentType=\"image/png\"/>\n");
            ctWriter.write("  <Default Extension=\"tiff\" ContentType=\"image/tiff\"/>\n");
            ctWriter.write("  <Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\"/>\n");
            ctWriter.write("  <Default Extension=\"xml\" ContentType=\"application/xml\"/>\n");
            ctWriter.write("  <Override PartName=\"/word/document.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml\"/>\n");
            ctWriter.write("  <Override PartName=\"/word/styles.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml\"/>\n");
            ctWriter.write("</Types>\n");
            ctWriter.flush();
            this.exportZipEntries.add(contentTypesEntry);
        }
        finally {
            if (ctWriter != null) {
                try {
                    ctWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

