/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.query.QueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSingletonCache;

public class DefaultQueryExecuterFactoryBundle
implements QueryExecuterFactoryBundle {
    private static final JRSingletonCache cache = new JRSingletonCache(JRQueryExecuterFactory.class);
    private static final DefaultQueryExecuterFactoryBundle INSTANCE = new DefaultQueryExecuterFactoryBundle();

    private DefaultQueryExecuterFactoryBundle() {
    }

    public static DefaultQueryExecuterFactoryBundle getInstance() {
        return INSTANCE;
    }

    public String[] getLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        List properties = JRProperties.getProperties("net.sf.jasperreports.query.executer.factory.");
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            JRProperties.PropertySuffix property = (JRProperties.PropertySuffix)it.next();
            languages.add(property.getSuffix());
        }
        return languages.toArray(new String[languages.size()]);
    }

    public JRQueryExecuterFactory getQueryExecuterFactory(String language) throws JRException {
        String factoryClassName = JRProperties.getProperty("net.sf.jasperreports.query.executer.factory." + language);
        if (factoryClassName == null) {
            throw new JRException("No query executer factory class registered for " + language + " queries.");
        }
        return (JRQueryExecuterFactory)cache.getCachedInstance(factoryClassName);
    }
}

