/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public class CoalesceFunctionNode
extends ValueNode {
    String functionName;
    ValueNodeList argumentsList;
    private int firstNonParameterNodeIdx = -1;

    public void init(Object object, Object object2) {
        this.functionName = (String)object;
        this.argumentsList = (ValueNodeList)object2;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        int n;
        this.argumentsList.bindExpression(fromList, subqueryList, vector);
        if (this.argumentsList.size() < 2) {
            throw StandardException.newException("42605", this.functionName);
        }
        if (this.argumentsList.containsAllParameterNodes()) {
            throw StandardException.newException("42610");
        }
        int n2 = this.argumentsList.size();
        for (n = 0; n < n2; ++n) {
            if (((ValueNode)this.argumentsList.elementAt(n)).requiresTypeFromContext()) continue;
            this.firstNonParameterNodeIdx = n;
            break;
        }
        for (n = 0; n < n2; ++n) {
            if (((ValueNode)this.argumentsList.elementAt(n)).requiresTypeFromContext()) continue;
            this.argumentsList.compatible((ValueNode)this.argumentsList.elementAt(n));
        }
        this.setType(this.argumentsList.getDominantTypeServices());
        for (n = 0; n < n2; ++n) {
            if (!((ValueNode)this.argumentsList.elementAt(n)).requiresTypeFromContext()) continue;
            ((ValueNode)this.argumentsList.elementAt(n)).setType(this.getTypeServices());
            break;
        }
        return this;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.argumentsList.size();
        String string = "org.apache.derby.iapi.types.DataValueDescriptor";
        String string2 = "org.apache.derby.iapi.types.DataValueDescriptor[]";
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string2);
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        methodBuilder2.pushNewArray("org.apache.derby.iapi.types.DataValueDescriptor", n);
        methodBuilder2.setField(localField);
        int n2 = 0;
        MethodBuilder methodBuilder3 = null;
        MethodBuilder methodBuilder4 = methodBuilder2;
        for (int i = 0; i < n; ++i) {
            MethodBuilder methodBuilder5;
            if (this.argumentsList.elementAt(i) instanceof ConstantNode) {
                ++n2;
                if (methodBuilder4.statementNumHitLimit(1)) {
                    MethodBuilder methodBuilder6 = expressionClassBuilder.newGeneratedFun("void", 2);
                    methodBuilder4.pushThis();
                    methodBuilder4.callMethod((short)182, null, methodBuilder6.getName(), "void", 0);
                    if (methodBuilder4 != methodBuilder2) {
                        methodBuilder4.methodReturn();
                        methodBuilder4.complete();
                    }
                    methodBuilder4 = methodBuilder6;
                }
                methodBuilder5 = methodBuilder4;
            } else {
                if (methodBuilder3 == null) {
                    methodBuilder3 = expressionClassBuilder.newGeneratedFun("void", 4);
                }
                methodBuilder5 = methodBuilder3;
            }
            methodBuilder5.getField(localField);
            ((ValueNode)this.argumentsList.elementAt(i)).generateExpression(expressionClassBuilder, methodBuilder5);
            methodBuilder5.upCast(string);
            methodBuilder5.setArrayElement(i);
        }
        if (methodBuilder4 != methodBuilder2) {
            methodBuilder4.methodReturn();
            methodBuilder4.complete();
        }
        if (methodBuilder3 != null) {
            methodBuilder3.methodReturn();
            methodBuilder3.complete();
            methodBuilder.pushThis();
            methodBuilder.callMethod((short)182, null, methodBuilder3.getName(), "void", 0);
        }
        ((ValueNode)this.argumentsList.elementAt(this.firstNonParameterNodeIdx)).generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.getField(localField);
        LocalField localField2 = expressionClassBuilder.newFieldDeclaration(2, string);
        expressionClassBuilder.generateNull(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.putField(localField2);
        methodBuilder.callMethod((short)185, string, "coalesce", string, 2);
        if (this.getTypeId().variableLength()) {
            boolean bl = this.getTypeId().isNumericTypeId();
            methodBuilder.dup();
            methodBuilder.push(bl ? this.getTypeServices().getPrecision() : this.getTypeServices().getMaximumWidth());
            methodBuilder.push(this.getTypeServices().getScale());
            methodBuilder.push(true);
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
        }
    }

    public String toString() {
        return "";
    }

    protected boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (!this.isSameNodeType(valueNode)) {
            return false;
        }
        CoalesceFunctionNode coalesceFunctionNode = (CoalesceFunctionNode)valueNode;
        if (coalesceFunctionNode.argumentsList.size() != this.argumentsList.size()) {
            return false;
        }
        int n = this.argumentsList.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode2;
            ValueNode valueNode3 = (ValueNode)this.argumentsList.elementAt(i);
            if (valueNode3.isEquivalent(valueNode2 = (ValueNode)coalesceFunctionNode.argumentsList.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this) || visitor.stopTraversal()) {
            return visitable;
        }
        int n = this.argumentsList.size();
        for (int i = 0; i < n; ++i) {
            this.argumentsList.setElementAt((QueryTreeNode)this.argumentsList.elementAt(i).accept(visitor), i);
        }
        return visitable;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        int n2 = this.argumentsList.size();
        for (int i = 0; i < n2; ++i) {
            ((ValueNode)this.argumentsList.elementAt(i)).preprocess(n, fromList, subqueryList, predicateList);
        }
        return this;
    }

    public void printSubNodes(int n) {
    }
}

