/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Schedule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.JComponent;
import resources.Classroom;
import resources.Constants;
import resources.Professor;

public class ViewGraphSched
extends JComponent
implements Constants,
Printable,
Pageable {
    private Schedule schedule = Schedule.getSchedule();
    private Professor viewProf;
    private Classroom viewRoom;

    public ViewGraphSched(Object obj) {
        if (obj instanceof Professor) {
            this.viewProf = (Professor)obj;
        } else if (obj instanceof Classroom) {
            this.viewRoom = (Classroom)obj;
        }
        Font mono = new Font("Monospaced", 0, 10);
        this.setFont(mono);
        this.setBackground(Color.white);
    }

    public void setViewProf(Professor viewProf) {
        this.viewProf = viewProf;
        this.viewRoom = null;
        this.repaint();
    }

    public void setViewRoom(Classroom viewRoom) {
        this.viewRoom = viewRoom;
        this.viewProf = null;
        this.repaint();
    }

    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        Rectangle r = new Rectangle(510, 900);
        this.draw(g2D, r);
    }

    private void placeTicks(Graphics g, int left, int top, int bottom) {
        String[] hours = new String[]{"7AM", "8AM", "9AM", "10AM", "11AM", "12PM", "1PM", "2PM", "3PM", "4PM", "5PM", "6PM", "7PM", "8PM", "9PM", "10PM"};
        double gap = (double)(bottom - top) / 15.0;
        double tickPos = top;
        for (int i = 0; i <= 15; ++i) {
            g.drawString(hours[i], left - 25, (int)tickPos + 3);
            g.drawLine(left - 3, (int)tickPos, left, (int)tickPos);
            tickPos += gap;
        }
    }

    public void draw(Graphics g, Rectangle r) {
        Rectangle withOffset;
        r = withOffset = new Rectangle((int)r.getX() + 30, (int)r.getY(), (int)r.getWidth() - 30, (int)r.getHeight());
        this.setPreferredSize(new Dimension(r.width, r.height + 75));
        this.setBackground(Color.white);
        Font titleFont = new Font("Times New Roman", 1, 10);
        Font regFont = new Font("Times New Roman", 0, 8);
        FontMetrics fm = g.getFontMetrics(titleFont);
        int colWidth = r.width / 6;
        float heightRatio = 1.0f;
        int topMargin = (int)r.getY() + fm.getHeight();
        int leftMargin = (int)r.getX();
        g.setFont(titleFont);
        g.drawRect(leftMargin, topMargin, r.width, r.height - fm.getHeight());
        g.drawLine(leftMargin, topMargin + fm.getHeight(), leftMargin + colWidth * 6, topMargin + fm.getHeight());
        g.drawString("Monday", leftMargin + 2, -3 + topMargin + fm.getHeight());
        g.drawString("Tuesday", leftMargin + 2 + colWidth, -3 + topMargin + fm.getHeight());
        g.drawString("Wednesday", leftMargin + 2 + colWidth * 2, -3 + topMargin + fm.getHeight());
        g.drawString("Thursday", leftMargin + 2 + colWidth * 3, -3 + topMargin + fm.getHeight());
        g.drawString("Friday", leftMargin + 2 + colWidth * 4, -3 + topMargin + fm.getHeight());
        g.drawString("Saturday", leftMargin + 2 + colWidth * 5, -3 + topMargin + fm.getHeight());
        g.setFont(regFont);
        this.placeTicks(g, leftMargin, topMargin + fm.getHeight(), (int)(r.getHeight() + (double)topMargin - (double)fm.getHeight()));
        for (int j = 1; j <= 5; ++j) {
            g.drawLine(leftMargin + colWidth * j, topMargin, leftMargin + colWidth * j, topMargin + r.height);
        }
        Rectangle minutes = new Rectangle(leftMargin, topMargin + fm.getHeight(), r.width, r.height - fm.getHeight() * 2);
        fm = g.getFontMetrics(regFont);
        if (this.viewProf != null) {
            g.setFont(titleFont);
            g.drawString(this.schedule.getScheduleName() + "  Schedule for Professor: " + this.viewProf.toString(), leftMargin, topMargin - fm.getHeight() / 2);
            g.setFont(regFont);
            g.drawString(this.schedule.updated(), leftMargin + r.width - fm.stringWidth(this.schedule.updated()), topMargin - fm.getHeight() / 2);
            this.viewProf.draw(g, minutes);
        }
        if (this.viewRoom != null) {
            g.setFont(titleFont);
            g.drawString(this.schedule.getScheduleName() + " Schedule for Room: " + this.viewRoom.toString(), leftMargin, topMargin - fm.getHeight() / 2);
            g.setFont(regFont);
            g.drawString(this.schedule.updated(), leftMargin + r.width - fm.stringWidth(this.schedule.updated()), topMargin - fm.getHeight() / 2);
            g.setFont(regFont);
            this.viewRoom.draw(g, minutes);
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        pageFormat = this.getPageFormat(0);
        this.draw(g, new Rectangle((int)pageFormat.getPaper().getImageableX(), (int)pageFormat.getPaper().getImageableY(), (int)pageFormat.getPaper().getImageableWidth(), (int)pageFormat.getPaper().getImageableHeight()));
        return 0;
    }

    public int getNumberOfPages() {
        return 1;
    }

    public Printable getPrintable(int pageIndex) {
        return this;
    }

    public PageFormat getPageFormat(int pageIndex) {
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        Paper paper = pageFormat.getPaper();
        paper.setImageableArea(36.0, 36.0, 540.0, 720.0);
        pageFormat.setPaper(paper);
        return pageFormat;
    }
}

