/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.io.Serializable;
import java.text.DecimalFormat;
import resources.CRTimeException;

public class CRTime
implements Serializable,
Comparable {
    static final long serialVersionUID = 911L;
    private int crMinutes;
    private int hours;
    private int minutes;
    private boolean am;

    public CRTime(int crMinutes) throws CRTimeException {
        if (crMinutes < 0 || crMinutes > 900) {
            throw new CRTimeException("Not in range 7 AM - 10 PM");
        }
        this.crMinutes = crMinutes;
        this.am = this.crMinutes < 300;
        this.minutes = this.crMinutes % 60;
        this.hours = ((this.crMinutes - this.minutes) / 60 + 7) % 12;
        if (this.hours == 0) {
            this.hours = 12;
        }
    }

    public CRTime(int hours, int minutes, boolean am) throws CRTimeException {
        this.am = am;
        if (hours < 1 || hours > 12) {
            throw new CRTimeException("Hours out of range");
        }
        if (minutes < 0 || minutes > 60) {
            throw new CRTimeException("Minutes out of range");
        }
        if (hours < 7 && am) {
            throw new CRTimeException("Nothing can be scheduled before 7:00 AM");
        }
        if (hours > 10 && hours != 12 && !am) {
            throw new CRTimeException("Nothing can be scheduled after 10:00 PM");
        }
        this.hours = hours;
        this.minutes = minutes;
        this.crMinutes = am ? (this.hours - 7) * 60 + this.minutes : 300 + this.hours % 12 * 60 + this.minutes;
    }

    public int getcrMinutes() {
        return this.crMinutes;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public boolean getam() {
        return this.am;
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("00");
        return this.hours + ":" + df.format(this.minutes) + (this.am ? "A" : "P");
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof CRTime)) {
            return 0;
        }
        CRTime time2 = (CRTime)obj;
        return this.crMinutes - time2.crMinutes;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CRTime)) {
            return false;
        }
        CRTime time2 = (CRTime)obj;
        return this.crMinutes == time2.crMinutes && this.am == time2.am;
    }
}

