/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import application.*;
import resources.*;

/**
 *
 * @author  Colin
 */
public class CoursesPanel extends javax.swing.JPanel implements Observer {
    
    /** Creates new form TestGridbag */
    public CoursesPanel() {
        initComponents();
        ptm = new CoursesTableModel();
        sorter = new TableSorter(ptm);
        sorter.addMouseListenerToHeaderInTable(jTable1);
        jTable1.setModel(sorter);
        addListeners();
        setColumnSizes();
    }
    private void setColumnSizes(){
        // adjust the width of the columns
        TableColumn column = null;
        
        column = jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(30);
        //column.setMaxWidth(20);
        column = jTable1.getColumnModel().getColumn(1);
        column.setPreferredWidth(30);
        //column.setMaxWidth(20);
        column = jTable1.getColumnModel().getColumn(2);
        column.setPreferredWidth(30);
        //column.setMaxWidth(20);
        column = jTable1.getColumnModel().getColumn(3);
        column.setPreferredWidth(70);
        column = jTable1.getColumnModel().getColumn(4);
        column.setPreferredWidth(30);
        //column.setMaxWidth(20);
        
        prefixColumn = jTable1.getColumnModel().getColumn(0);
        prefixColumn.setCellEditor(new DefaultCellEditor(editPrefix));
        numberColumn = jTable1.getColumnModel().getColumn(1);
        numberColumn.setCellEditor(new DefaultCellEditor(editNumber));
        sectionColumn = jTable1.getColumnModel().getColumn(2);
        sectionColumn.setCellEditor(new DefaultCellEditor(editSection));
        nameColumn = jTable1.getColumnModel().getColumn(3);
        nameColumn.setCellEditor(new DefaultCellEditor(editName));
        creditsColumn = jTable1.getColumnModel().getColumn(4);
        creditsColumn.setCellEditor(new DefaultCellEditor(editCredits));
    }
    
    private void addListeners() {
        coursesPanelListener = new CoursesPanelListener();
        jButton1.addActionListener(coursesPanelListener);
        jButton2.addActionListener(coursesPanelListener);
        
        CourseColListener ccl = new CourseColListener();        
        editPrefix.addActionListener(ccl);
        editNumber.addActionListener(ccl);
        editSection.addActionListener(ccl);
        editName.addActionListener(ccl);
        editCredits.addActionListener(ccl);
                        
        
   /*
        editBuilding.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                int row = jTable1.getSelectedRow();
                int theRealIndex = sorter.map(row);
                if (theRealIndex >= 0) {
                    String buildingStr = editBuilding.getText();
                    Classroom roomModified = (Classroom)schedule.getClassrooms().elementAt(theRealIndex);
                    roomModified.setBuilding(buildingStr);
                    ptm.fireTableDataChanged();
                    schedule.setChanged(true);
                }
            }
        });
*/
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        tfPrefix = new javax.swing.JTextField();
        tfNumber = new javax.swing.JTextField();
        tfName = new javax.swing.JTextField();
        tfCredits = new javax.swing.JTextField();
        tfSectionPrefix = new javax.swing.JTextField();
        tfHowMany = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        jButton2 = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setToolTipText("Double Click in cell to change section info, or on header to sort");
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jTable1.setToolTipText("Double click to change info in cell");
        jScrollPane1.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        jPanel1.add(jScrollPane1, gridBagConstraints);

        jButton1.setText("Delete Selected Course(s)");
        jButton1.setToolTipText("Delete selected sections from list");
        jButton1.setMaximumSize(new java.awt.Dimension(250, 26));
        jButton1.setMinimumSize(new java.awt.Dimension(200, 26));
        jButton1.setPreferredSize(new java.awt.Dimension(215, 26));
        jPanel3.add(jButton1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 17, 0);
        jPanel1.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = -53;
        gridBagConstraints.ipady = -25;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(17, 17, 0, 0);
        add(jPanel1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.EtchedBorder(), new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED)));
        jLabel1.setText("Course Prefix:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(17, 6, 0, 0);
        jPanel2.add(jLabel1, gridBagConstraints);

        jLabel2.setText("Number:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel2, gridBagConstraints);

        jLabel3.setText("Name:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel3, gridBagConstraints);

        jLabel4.setText("Credits:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel4, gridBagConstraints);

        jLabel5.setText("Section Prefix:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel5, gridBagConstraints);

        jLabel6.setText("How Many Sections:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel6, gridBagConstraints);

        tfPrefix.setToolTipText("e.g. COP for Computer Programming");
        tfPrefix.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tfPrefixActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(17, 6, 0, 18);
        jPanel2.add(tfPrefix, gridBagConstraints);

        tfNumber.setToolTipText("e.g. 2800");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(tfNumber, gridBagConstraints);

        tfName.setToolTipText("e.g. Intro to Java");
        tfName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tfNameActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(tfName, gridBagConstraints);

        tfCredits.setToolTipText("e.g. 3.0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(tfCredits, gridBagConstraints);

        tfSectionPrefix.setToolTipText("usually a single character.  may be left blank.");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(tfSectionPrefix, gridBagConstraints);

        tfHowMany.setToolTipText("add this many sections to the list at one time.");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(tfHowMany, gridBagConstraints);

        jButton2.setText("Add Course Sections");
        jButton2.setToolTipText("Add these sections to the list");
        jPanel4.add(jButton2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 17, 0);
        jPanel2.add(jPanel4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(17, 17, 0, 17);
        add(jPanel2, gridBagConstraints);

    }//GEN-END:initComponents
    
    private void tfNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tfNameActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_tfNameActionPerformed
    
    private void tfPrefixActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tfPrefixActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_tfPrefixActionPerformed

    public void update(java.util.Observable observable, Object obj) {
        ptm.fireTableDataChanged();
    }    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField tfCredits;
    private javax.swing.JTextField tfHowMany;
    private javax.swing.JTextField tfName;
    private javax.swing.JTextField tfNumber;
    private javax.swing.JTextField tfPrefix;
    private javax.swing.JTextField tfSectionPrefix;
    // End of variables declaration//GEN-END:variables
    
    private CoursesPanelListener coursesPanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private CoursesTableModel ptm;
    private TableSorter sorter;
    
    private TableColumn prefixColumn;
    private TableColumn numberColumn;
    private TableColumn sectionColumn;
    private TableColumn nameColumn;
    private TableColumn creditsColumn;
  
    private JTextField editPrefix = new JTextField();
    private JTextField editNumber = new JTextField();
    private JTextField editSection = new JTextField();
    private JTextField editName = new JTextField();
    private JTextField editCredits = new JTextField();
 
    
    class CoursesPanelListener implements ActionListener {        
        public void actionPerformed(ActionEvent e) {
            System.out.println("I hear " + "|"+e.getActionCommand()+"|");
            
            if (e.getActionCommand().equals("Add Course Sections")){
                // Check for valid info
                String prefix = tfPrefix.getText().trim().toUpperCase();
                String courseNumber = tfNumber.getText().trim();
                String courseName = tfName.getText().trim();
                String creditHoursString = tfCredits.getText().trim();
                int creditHours = 0;
                try {
                    creditHours = Integer.parseInt(creditHoursString);
                } catch (Exception ex) {
                    // if it didn't parse try a double
                    try {
                        creditHours = (int) Double.parseDouble(creditHoursString);
                    } catch (Exception ex2){
                        // if it didn't parse just ignore the field.
                    }
                }
                
                if (prefix.length() != 0
                && courseNumber.length() != 0
                && courseName.length() != 0) {
                    
                    int sections = getSectionCount();
                    String sectionPrefix;
                    if (tfSectionPrefix.getText().trim().length() == 0)
                        sectionPrefix = "Sect";
                    else
                        sectionPrefix = tfSectionPrefix.getText().trim();
                    
                    // Create the course sections and add each one to the vector and the list
                    for (int i = 1; i <= sections; i++) {
                        Course hold = new Course(prefix, courseNumber, courseName,
                        sectionPrefix, i, creditHours);
                        schedule.addCourse(hold);
                    }
                    
                    // reset the widgets to blank
                    tfPrefix.setText("");
                    tfNumber.setText("");
                    tfName.setText("");
                    tfSectionPrefix.setText("");
                    tfHowMany.setText("");
                }
            } else if (e.getActionCommand().equals("Delete Selected Course(s)")){
                System.out.println("I'm deleting a course over here");
                // Determine which items to be deleted
                int[] selected = jTable1.getSelectedRows();
                
                for (int i = selected.length - 1 ; i >= 0 ; i--) { // Why backwards??? Becuase its a vector and shifts down
//                for (int i = 0; i < selected.length; i++) {
                    int realIndex = sorter.map(selected[i]); // Whats this for???
                    // Removes the items from the list
                    schedule.removeCourse((Course)
                    schedule.getCourses().get(realIndex));
                }
            }
        }
        
        private int getSectionCount() {
            int sections;
            try {
                sections = Integer.parseInt(tfHowMany.getText());
            }
            catch (Exception e) {
                sections = 1;
            }
            System.out.println("Making sections: " + sections);
            
            return sections;
        }
    } // end inner class
    
    /** this one is to hear the modifications inthe table columns.
     */
    class CourseColListener implements ActionListener{
        public void actionPerformed(ActionEvent e) {
        
            int row = jTable1.getSelectedRow();
            int theRealIndex = sorter.map(row);
            Course courseModified = (Course)schedule.getCourses().get(theRealIndex);
            
            if (e.getSource() == editPrefix){
                System.out.println("I hear edit the prefix");
                String prefixString = editPrefix.getText().trim().toUpperCase();
                courseModified.setField(prefixString);
            } else if (e.getSource() == editNumber){
                String prefixString = editNumber.getText().trim();
                courseModified.setCourseNumber(prefixString);                
            } else if (e.getSource() == editSection) {

                String sectionPrefix, sectionNumber;
                String whole = editSection.getText().trim();
                
                if (! (whole.indexOf('-') > 0)){
                    
                } else {
                    StringTokenizer stTok = new StringTokenizer(whole, "-");
                    if(stTok.hasMoreTokens())
                        courseModified.setSectionPrefix(stTok.nextToken());
                    if(stTok.hasMoreTokens()){
                        String number = stTok.nextToken().trim();
                        try{
                            int num = Integer.parseInt(number);
                            courseModified.setSectionNumber(num);
                        } catch (NumberFormatException nfe){
                            // do nothing, bail out
                            return;
                        }
                    }
                }
                
            } else if( e.getSource() == editName){
                String nameString = editName.getText().trim();
                courseModified.setCourseName(nameString);                
            } else if(e.getSource() == editCredits){
                int creditHours;
                String creditsString = editPrefix.getText().trim();
                try {
                    creditHours = (int) Double.parseDouble(creditsString);
                } catch (NumberFormatException nfe){
                    return; // bail out of the listener, doing nothing
                }
                courseModified.setCreditHours(creditHours);               
            }
            
            //ptm.fireTableDataChanged();
            schedule.setChanged(true);
        }        
    } //end inner class
}

class CoursesTableModel extends AbstractTableModel {
    private Schedule schedule;
    
    final String[] columnNames = {
        "Pre",
        "Num",
        "Section",
        "Name",
        "Credits"
    };
    /** Creates a new instance of RoomsTableModel */
    public CoursesTableModel() {
        schedule = Schedule.getSchedule();
    }
    public int getColumnCount() {
        return columnNames.length;
    }
    public int getRowCount() {
        return schedule.getCourses().size();
    }
    public String getColumnName(int col) {
        return columnNames[col];
    }
    
    public Class getColumnClass(int c) {
        return " ".getClass();
    }
    public boolean isCellEditable(int row, int col) {
        return true;
    }
    public Object getValueAt(int row, int col) {
        Course course = (Course)schedule.getCourses().get(row);
        switch(col){
            case 0: return course.getField();
            case 1: return course.getCourseNumber();
            case 2: return course.getSectionString();
            case 3: return course.getCourseName();
            case 4: return ""+course.getCreditHours();
        }
        return ""; // should never do this
    }
    public void setValueAt(Object value, int row, int col) {
        //fireTableCellUpdated(row, col);
    }
}
