/*
 * DialogCellEditor.java
 *
 * Created on April 19, 2004, 2:41 PM
 */

package resources;

import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import panels.*;

/**
 *
 * @author  kyle
 */
public class DialogCellEditor extends AbstractCellEditor implements TableCellEditor {
    
    private String value;
    private JButton component;
    private JTable table;
    
    /** Creates a new instance of DialogCellEditor */
    public DialogCellEditor() {
        value = "Click to edit";
        component = new JButton();
        component.addActionListener(new buttonActionListener());
    }
    
    public Object getCellEditorValue() {
        return value;
    }
    
    public boolean shouldSelectCell (EventObject anEvent) {
        return false;
    }
    
    public Component getTableCellEditorComponent (JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = (String) value;
        if(table == null) {
            System.out.println("Hmm, got null table");
        }
        this.table = table;
        addCellEditorListener(table);
        return component;
    }

    public Component getTableCellEditorComponent () {
        return component;
    }
    
    class buttonActionListener implements ActionListener {
        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            if(actionEvent.getSource() == component) {
//                System.out.println("Should do a popup dialog here");
//                String inputValue = JOptionPane.showInputDialog("Please input a value");
//                value = inputValue;
                
                NoteDialog dialog = new NoteDialog((Frame) table.getTopLevelAncestor(), true);
                dialog.setNote(value);
                dialog.setVisible(true);
                int ret = dialog.getReturnStatus();
                if(ret == NoteDialog.RET_CANCEL) {
                    fireEditingCanceled();
                    return;
                }
                value = dialog.getNote();
                fireEditingStopped();
                //component.setText(value);
//                fireEditingStopped();
            }
        }
    }
}

