/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.bundlestorage.Util;
import org.knopflerfish.framework.bundlestorage.file.Archive;
import org.knopflerfish.framework.bundlestorage.file.BundleStorageImpl;
import org.osgi.framework.FrameworkListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleArchiveImpl
implements BundleArchive {
    private static final String LOCATION_FILE = "location";
    private static final String REV_FILE = "revision";
    private static final String AUTOSTART_FILE = "autostart";
    private static final String STARTLEVEL_FILE = "startlevel";
    private static final String LAST_MODIFIED_FILE = "lastModifed";
    final BundleStorageImpl storage;
    private final Archive archive;
    private BundleGeneration bundleGeneration = null;
    private final long id;
    private final String location;
    private int autostartSetting = -1;
    private final FileTree bundleDir;
    private ArrayList<Archive> archives;
    private int startLevel = -1;
    private long lastModified = 0L;
    private ArrayList<List<X509Certificate>> trustedCerts = null;
    private ArrayList<List<X509Certificate>> untrustedCerts = null;
    private boolean checkCerts = true;
    private ArrayList<Exception> warnings = null;

    BundleArchiveImpl(BundleStorageImpl bundleStorage, FileTree dir, InputStream is, String bundleLocation, long bundleId) throws Exception {
        URL source = null;
        try {
            source = new URL(bundleLocation);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.bundleDir = dir;
        this.storage = bundleStorage;
        this.id = bundleId;
        this.location = bundleLocation;
        this.archive = new Archive(this, this.bundleDir, 0, is, source, this.location);
        this.putContent(LOCATION_FILE, this.location);
    }

    BundleArchiveImpl(BundleStorageImpl bundleStorage, FileTree dir, long bundleId) throws Exception {
        this.bundleDir = dir;
        this.location = this.getContent(LOCATION_FILE);
        if (this.location == null || this.location.length() == 0) {
            throw new IOException("No bundle location information found");
        }
        int rev = -1;
        String s = this.getContent(REV_FILE);
        if (s != null) {
            try {
                rev = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((s = this.getContent(STARTLEVEL_FILE)) != null) {
            try {
                this.startLevel = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((s = this.getContent(LAST_MODIFIED_FILE)) != null) {
            try {
                this.lastModified = Long.parseLong(s);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        if ((s = this.getContent(AUTOSTART_FILE)) != null) {
            try {
                this.autostartSetting = Integer.parseInt(s);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        this.id = bundleId;
        this.storage = bundleStorage;
        this.archive = new Archive(this, this.bundleDir, rev, this.location);
    }

    BundleArchiveImpl(BundleArchiveImpl old, InputStream is) throws Exception {
        boolean bReference;
        this.bundleDir = old.bundleDir;
        this.location = old.location;
        this.storage = old.storage;
        this.id = old.id;
        this.autostartSetting = old.autostartSetting;
        int rev = old.archive.getRevision() + 1;
        URL source = null;
        boolean bl = bReference = is == null;
        if (bReference) {
            source = new URL(this.location);
        }
        this.archive = new Archive(this, this.bundleDir, rev, is, source, this.location);
        if (!bReference) {
            this.putContent(REV_FILE, Integer.toString(rev));
        }
    }

    @Override
    public String getAttribute(String key) {
        return this.archive.getAttribute(key);
    }

    @Override
    public FileArchive getFileArchive(String path) {
        if (".".equals(path)) {
            return this.archive;
        }
        if (this.archives == null) {
            this.archives = new ArrayList();
        }
        try {
            Archive a = new Archive(this.archive, path, this.archives.size() + 1);
            this.archives.add(a);
            return a;
        }
        catch (IOException io) {
            return null;
        }
    }

    @Override
    public Hashtable<String, String> getLocalizationEntries(String localeFile) {
        BundleResourceStream aif = this.archive.getBundleResourceStream(localeFile);
        if (aif != null) {
            Properties ht;
            Properties l = new Properties();
            try {
                l.load(aif);
            }
            catch (IOException _ignore) {
                // empty catch block
            }
            try {
                aif.close();
            }
            catch (IOException _ignore) {
                // empty catch block
            }
            Properties res = ht = l;
            return res;
        }
        return null;
    }

    @Override
    public HeaderDictionary getUnlocalizedAttributes() {
        return new HeaderDictionary(this.archive.manifest.getMainAttributes());
    }

    @Override
    public BundleGeneration getBundleGeneration() {
        return this.bundleGeneration;
    }

    @Override
    public void setBundleGeneration(BundleGeneration bg) {
        this.bundleGeneration = bg;
        if (this.warnings != null) {
            for (Exception w : this.warnings) {
                this.frameworkWarning(w);
            }
            this.warnings = null;
        }
    }

    @Override
    public long getBundleId() {
        return this.id;
    }

    @Override
    public String getBundleLocation() {
        return this.location;
    }

    @Override
    public int getStartLevel() {
        return this.startLevel;
    }

    @Override
    public void setStartLevel(int level) throws IOException {
        if (this.startLevel != level) {
            this.startLevel = level;
            this.putContent(STARTLEVEL_FILE, Integer.toString(this.startLevel));
        }
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(long timemillisecs) throws IOException {
        this.lastModified = timemillisecs;
        this.putContent(LAST_MODIFIED_FILE, Long.toString(timemillisecs));
    }

    @Override
    public BundleResourceStream getBundleResourceStream(String component, int ix) {
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        if (ix == 0) {
            return this.archive.getBundleResourceStream(component);
        }
        return this.archives.get(ix - 1).getBundleResourceStream(component);
    }

    @Override
    public int getAutostartSetting() {
        return this.autostartSetting;
    }

    @Override
    public void setAutostartSetting(int setting) throws IOException {
        if (setting != this.autostartSetting) {
            this.autostartSetting = setting;
            this.putContent(AUTOSTART_FILE, String.valueOf(this.autostartSetting));
        }
    }

    @Override
    public Enumeration<String> findResourcesPath(String path) {
        return this.archive.findResourcesPath(path);
    }

    @Override
    public String getJarLocation() {
        return this.archive.getPath();
    }

    @Override
    public ArrayList<List<X509Certificate>> getCertificateChains(boolean onlyTrusted) {
        if (this.checkCerts) {
            Certificate[] c = this.archive.getCertificates();
            this.checkCerts = false;
            if (c != null) {
                ArrayList<Certificate> failed = new ArrayList<Certificate>();
                this.untrustedCerts = Util.getCertificateChains(c, failed);
                if (!failed.isEmpty()) {
                    this.untrustedCerts = null;
                }
            }
        }
        ArrayList<List<X509Certificate>> res = this.trustedCerts;
        if (!onlyTrusted && this.untrustedCerts != null) {
            if (res == null) {
                res = this.untrustedCerts;
            } else {
                res = new ArrayList(this.trustedCerts.size() + this.untrustedCerts.size());
                res.addAll(this.trustedCerts);
                res.addAll(this.untrustedCerts);
            }
        }
        return res;
    }

    @Override
    public void trustCertificateChain(List<X509Certificate> trustedChain) {
        if (this.trustedCerts == null) {
            this.trustedCerts = new ArrayList(this.untrustedCerts.size());
        }
        this.trustedCerts.add(trustedChain);
        this.untrustedCerts.remove(trustedChain);
        if (this.untrustedCerts.isEmpty()) {
            this.untrustedCerts = null;
        }
    }

    @Override
    public void purge() {
        this.close();
        if (!this.storage.isReadOnly()) {
            if (this.storage.removeArchive(this)) {
                new File(this.bundleDir, LOCATION_FILE).delete();
                new File(this.bundleDir, AUTOSTART_FILE).delete();
                new File(this.bundleDir, REV_FILE).delete();
                new File(this.bundleDir, STARTLEVEL_FILE).delete();
                new File(this.bundleDir, LAST_MODIFIED_FILE).delete();
            }
            this.archive.purge();
            if (this.bundleDir.list().length == 0) {
                this.bundleDir.delete();
            }
        }
    }

    @Override
    public void close() {
        if (this.archives != null) {
            for (Archive archive2 : this.archives) {
                archive2.close();
            }
            this.archives = null;
        }
        this.archive.close();
    }

    void frameworkWarning(Exception warn) {
        if (this.bundleGeneration != null) {
            this.storage.framework.frameworkWarning(this.bundleGeneration, (Throwable)warn, new FrameworkListener[0]);
        } else {
            if (this.warnings == null) {
                this.warnings = new ArrayList();
            }
            this.warnings.add(warn);
        }
    }

    static boolean isUninstalled(File dir) {
        String s = BundleArchiveImpl.getContent(dir, LAST_MODIFIED_FILE);
        if (s == null || s.length() == 0) {
            return true;
        }
        s = BundleArchiveImpl.getContent(dir, STARTLEVEL_FILE);
        int n = -1;
        try {
            n = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n == -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getContent(File dir, String f) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(new File(dir, f)));
            String string = ((DataInputStream)in).readUTF();
            return string;
        }
        catch (IOException ignore) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(String f) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(new File(this.bundleDir, f)));
            String string = ((DataInputStream)in).readUTF();
            return string;
        }
        catch (IOException ignore) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putContent(String f, String content) throws IOException {
        if (!this.storage.isReadOnly()) {
            FilterOutputStream out = null;
            try {
                out = new DataOutputStream(new FileOutputStream(new File(this.bundleDir, f)));
                ((DataOutputStream)out).writeUTF(content);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }
}

