/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

public class OsmMercator {
    public static final int DEFAUL_TILE_SIZE = 256;
    public static final double MAX_LAT = 85.05112877980659;
    public static final double MIN_LAT = -85.05112877980659;
    private static double EARTH_RADIUS = 6378137.0;
    public static final OsmMercator MERCATOR_256 = new OsmMercator();
    private int tileSize = 256;

    public OsmMercator() {
    }

    public OsmMercator(int tileSize) {
        this.tileSize = tileSize;
    }

    public double radius(int aZoomlevel) {
        return (double)(this.tileSize * (1 << aZoomlevel)) / (Math.PI * 2);
    }

    public int getMaxPixels(int aZoomlevel) {
        return this.tileSize * (1 << aZoomlevel);
    }

    public int falseEasting(int aZoomlevel) {
        return this.getMaxPixels(aZoomlevel) / 2;
    }

    public int falseNorthing(int aZoomlevel) {
        return -1 * this.getMaxPixels(aZoomlevel) / 2;
    }

    public double getDistance(int x1, int y1, int x2, int y2, int zoomLevel) {
        double la1 = this.yToLat(y1, zoomLevel);
        double lo1 = this.xToLon(x1, zoomLevel);
        double la2 = this.yToLat(y2, zoomLevel);
        double lo2 = this.xToLon(x2, zoomLevel);
        return this.getDistance(la1, lo1, la2, lo2);
    }

    public double getDistance(double la1, double lo1, double la2, double lo2) {
        double aStartLat = Math.toRadians(la1);
        double aStartLong = Math.toRadians(lo1);
        double aEndLat = Math.toRadians(la2);
        double aEndLong = Math.toRadians(lo2);
        double distance = Math.acos(Math.sin(aStartLat) * Math.sin(aEndLat) + Math.cos(aStartLat) * Math.cos(aEndLat) * Math.cos(aEndLong - aStartLong));
        return EARTH_RADIUS * distance;
    }

    public double lonToX(double aLongitude, int aZoomlevel) {
        int mp = this.getMaxPixels(aZoomlevel);
        double x = (double)mp * (aLongitude + 180.0) / 360.0;
        return Math.min(x, (double)mp);
    }

    public double latToY(double aLat, int aZoomlevel) {
        if (aLat < -85.05112877980659) {
            aLat = -85.05112877980659;
        } else if (aLat > 85.05112877980659) {
            aLat = 85.05112877980659;
        }
        double sinLat = Math.sin(Math.toRadians(aLat));
        double log = Math.log((1.0 + sinLat) / (1.0 - sinLat));
        int mp = this.getMaxPixels(aZoomlevel);
        double y = (double)mp * (0.5 - log / (Math.PI * 4));
        return Math.min(y, (double)(mp - 1));
    }

    public double xToLon(int aX, int aZoomlevel) {
        return 360.0 * (double)aX / (double)this.getMaxPixels(aZoomlevel) - 180.0;
    }

    public double yToLat(int aY, int aZoomlevel) {
        double latitude = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)(aY += this.falseNorthing(aZoomlevel)) / this.radius(aZoomlevel)));
        return -1.0 * Math.toDegrees(latitude);
    }
}

