/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.IPropertyControlCreator;
import org.freeplane.core.resources.components.KeyProperty;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.MenuSplitter;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.JAutoScrollBarPane;
import org.freeplane.core.ui.components.JResizer;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.icon.IIconInformation;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconGroup;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.icon.mindmapmode.IconAction;
import org.freeplane.features.icon.mindmapmode.RemoveAllIconsAction;
import org.freeplane.features.icon.mindmapmode.RemoveIconAction;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.ui.CollapseableBoxBuilder;
import org.freeplane.features.ui.FrameController;

public class MIconController
extends IconController {
    private final Map<MindIcon, AFreeplaneAction> iconActions = new LinkedHashMap<MindIcon, AFreeplaneAction>();
    private final IconStore STORE = IconStoreFactory.create();
    private final JToolBar iconToolBar;
    private final Box iconBox;

    public MIconController(ModeController modeController) {
        super(modeController);
        modeController.registerExtensionCopier((IExtensionCopier)new ExtensionCopier());
        this.iconToolBar = new FreeplaneToolBar("icon_toolbar", 1);
        JAutoScrollBarPane iconToolBarScrollPane = new JAutoScrollBarPane((Component)this.iconToolBar);
        UITools.setScrollbarIncrement((JScrollPane)iconToolBarScrollPane);
        UITools.addScrollbarIncrementPropertyListener((JScrollPane)iconToolBarScrollPane);
        FrameController frameController = (FrameController)modeController.getController().getViewController();
        this.iconBox = new CollapseableBoxBuilder(frameController).setPropertyNameBase("leftToolbarVisible").setResizeable(false).createBox((Component)iconToolBarScrollPane, JResizer.Direction.LEFT);
        this.createIconActions(modeController);
        this.createPreferences();
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "icon_actions", (EntryVisitor)new IconActionBuilder(modeController));
    }

    public void addIcon(final NodeModel node, final MindIcon icon) {
        IActor actor = new IActor(){

            public void act() {
                node.addIcon(icon);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", null, (Object)icon);
            }

            public String getDescription() {
                return "addIcon";
            }

            public void undo() {
                node.removeIcon();
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", (Object)icon, null);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    public void addIcon(final NodeModel node, final MindIcon icon, final int position) {
        IActor actor = new IActor(){

            public void act() {
                node.addIcon(icon, position);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", null, (Object)icon);
            }

            public String getDescription() {
                return "addIcon";
            }

            public void undo() {
                node.removeIcon(position);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", (Object)icon, null);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    private void createIconActions(ModeController modeController) {
        modeController.addAction((AFreeplaneAction)new RemoveIconAction(0));
        modeController.addAction((AFreeplaneAction)new RemoveIconAction(-1));
        modeController.addAction((AFreeplaneAction)new RemoveAllIconsAction());
        for (MindIcon icon : this.STORE.getMindIcons()) {
            IconAction myAction = new IconAction(icon);
            modeController.addActionIfNotAlreadySet((AFreeplaneAction)myAction);
            this.iconActions.put(icon, (AFreeplaneAction)myAction);
        }
    }

    private void createPreferences() {
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        OptionPanelBuilder optionPanelBuilder = modeController.getOptionPanelBuilder();
        ArrayList<AFreeplaneAction> actions = new ArrayList<AFreeplaneAction>();
        actions.addAll(this.iconActions.values());
        actions.add(modeController.getAction("RemoveIcon_0_Action"));
        actions.add(modeController.getAction("RemoveIconAction"));
        actions.add(modeController.getAction("RemoveAllIconsAction"));
        for (AFreeplaneAction iconAction : actions) {
            final IIconInformation info = (IIconInformation)iconAction;
            optionPanelBuilder.addCreator("Keystrokes/icons", new IPropertyControlCreator(){

                public IPropertyControl createControl() {
                    KeyProperty keyProperty = new KeyProperty(info.getShortcutKey(), info.getTranslationValueLabel());
                    keyProperty.setImageIcon(info.getIcon());
                    keyProperty.disableModifiers();
                    return keyProperty;
                }
            }, 0);
        }
    }

    public Collection<AFreeplaneAction> getIconActions() {
        return Collections.unmodifiableCollection(this.iconActions.values());
    }

    public JComponent getIconToolBarScrollPane() {
        return this.iconBox;
    }

    public Collection<MindIcon> getMindIcons() {
        ArrayList<MindIcon> iconInfoList = new ArrayList<MindIcon>();
        Collection<AFreeplaneAction> iconActions = this.getIconActions();
        for (Action action : iconActions) {
            MindIcon info = ((IconAction)((Object)action)).getMindIcon();
            iconInfoList.add(info);
        }
        return iconInfoList;
    }

    private JMenu getSubmenu(IconGroup group) {
        JMenu menu = new JMenu("\u25ba"){
            private static final long serialVersionUID = 1L;

            @Override
            protected Point getPopupMenuOrigin() {
                return new Point(this.getWidth(), 0);
            }
        };
        menu.setFont(menu.getFont().deriveFont(8.0f));
        menu.setMargin(new Insets(0, 0, 0, 0));
        menu.setIcon(group.getGroupIcon().getIcon());
        for (MindIcon icon : group.getIcons()) {
            this.addActionToIconSubmenu(menu, icon, icon.getFileName());
        }
        menu.setToolTipText(group.getDescription());
        return menu;
    }

    private void addActionToIconSubmenu(JMenu menu, MindIcon icon, String fileName) {
        JMenu lastSubmenu;
        Component lastComponent;
        AFreeplaneAction myAction = this.iconActions.get(icon);
        int separatorPosition = fileName.indexOf(47);
        if (separatorPosition == -1) {
            new MenuSplitter().addMenuComponent(menu, (Component)new JMenuItem((Action)myAction), menu.getItemCount());
            return;
        }
        String submenuName = fileName.substring(0, separatorPosition);
        int componentCount = menu.getItemCount();
        if (componentCount != 0 && (lastComponent = menu.getMenuComponent(componentCount - 1)) instanceof JMenu && (lastSubmenu = (JMenu)lastComponent).getText().equals(submenuName)) {
            this.addActionToIconSubmenu(lastSubmenu, icon, fileName.substring(separatorPosition + 1));
            return;
        }
        JMenu submenu = new JMenu(submenuName);
        menu.add(submenu);
        this.addActionToIconSubmenu(submenu, icon, fileName.substring(separatorPosition + 1));
    }

    private void insertSubmenus(JToolBar iconToolBar) {
        JMenuBar iconMenuBar = new JMenuBar(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                Dimension preferredSize = this.getPreferredSize();
                return new Dimension(Short.MAX_VALUE, preferredSize.height);
            }
        };
        iconMenuBar.setAlignmentX(0.5f);
        iconMenuBar.setLayout(new GridLayout(0, 1));
        for (IconGroup iconGroup : this.STORE.getGroups()) {
            iconMenuBar.add(this.getSubmenu(iconGroup));
        }
        iconToolBar.add(iconMenuBar);
    }

    public void removeAllIcons(NodeModel node) {
        int size = node.getIcons().size();
        MIconController iconController = (MIconController)IconController.getController();
        for (int i = 0; i < size; ++i) {
            iconController.removeIcon(node, 0);
        }
    }

    public int removeIcon(NodeModel node) {
        return this.removeIcon(node, -1);
    }

    public int removeIcon(final NodeModel node, int position) {
        int index;
        int size = node.getIcons().size();
        int n = index = position >= 0 ? position : size + position;
        if (size == 0 || size <= index) {
            return size;
        }
        IActor actor = new IActor(){
            private final MindIcon icon;
            {
                this.icon = node.getIcon(index);
            }

            public void act() {
                node.removeIcon(index);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", (Object)this.icon, null);
            }

            public String getDescription() {
                return "removeIcon";
            }

            public void undo() {
                node.addIcon(this.icon, index);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"icon", null, (Object)this.icon);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
        return node.getIcons().size();
    }

    private void updateIconToolbar(ModeController modeController) {
        String[] fpIcons;
        this.iconToolBar.removeAll();
        this.iconToolBar.add((Action)modeController.getAction("RemoveIcon_0_Action")).setAlignmentX(0.5f);
        this.iconToolBar.add((Action)modeController.getAction("RemoveIconAction")).setAlignmentX(0.5f);
        this.iconToolBar.add((Action)modeController.getAction("RemoveAllIconsAction")).setAlignmentX(0.5f);
        this.iconToolBar.addSeparator();
        if (ResourceController.getResourceController().getBooleanProperty("structured_icon_toolbar")) {
            this.insertSubmenus(this.iconToolBar);
            return;
        }
        for (String icon : fpIcons = ResourceController.getResourceController().getProperty("icons.list").split(";")) {
            MindIcon mindIcon = this.STORE.getMindIcon(icon);
            AFreeplaneAction iconAction = this.iconActions.get(mindIcon);
            this.iconToolBar.add((Action)iconAction).setAlignmentX(0.5f);
        }
        Collection userIcons = this.STORE.getUserIcons();
        for (MindIcon icon : userIcons) {
            AFreeplaneAction iconAction = this.iconActions.get(icon);
            this.iconToolBar.add((Action)iconAction).setAlignmentX(0.5f);
        }
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private ExtensionCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals((Object)Keys.ICONS)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            List sourceIcons = from.getIcons();
            List targetIcons = to.getIcons();
            for (MindIcon icon : sourceIcons) {
                if (targetIcons.contains(icon)) continue;
                to.addIcon(icon);
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals((Object)Keys.ICONS)) {
                return;
            }
            while (from.removeIcon() > 0) {
            }
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals((Object)Keys.ICONS)) {
                return;
            }
            List targetIcons = from.getIcons();
            List whichIcons = which.getIcons();
            Iterator targetIconIterator = targetIcons.iterator();
            while (targetIconIterator.hasNext()) {
                MindIcon icon = (MindIcon)targetIconIterator.next();
                if (!whichIcons.contains(icon)) continue;
                targetIconIterator.remove();
            }
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
        }
    }

    public static enum Keys {
        ICONS;

    }

    private final class IconActionBuilder
    implements EntryVisitor {
        private final HashMap<String, Entry> submenuEntries = new HashMap();
        private final ModeController modeController;

        public IconActionBuilder(ModeController modeController) {
            this.modeController = modeController;
        }

        public void visit(Entry target) {
            this.addIcons(target);
            this.submenuEntries.clear();
            MIconController.this.updateIconToolbar(this.modeController);
        }

        private void addIcons(Entry target) {
            for (IconGroup iconGroup : MIconController.this.STORE.getGroups()) {
                this.addIconGroup(target, iconGroup);
            }
        }

        private void addIconGroup(Entry target, IconGroup group) {
            if (group.getIcons().size() < 1) {
                return;
            }
            Entry item = new Entry();
            EntryAccessor entryAccessor = new EntryAccessor();
            entryAccessor.setIcon(item, group.getGroupIcon().getIcon());
            item.setName(group.getDescriptionKey());
            target.addChild(item);
            for (MindIcon icon : group.getIcons()) {
                String fileName = icon.getFileName();
                this.addAction(item, "", icon, fileName);
            }
        }

        private void addAction(Entry target, String itemKey, MindIcon icon, String fileName) {
            int separatorPosition = fileName.indexOf(47);
            EntryAccessor entryAccessor = new EntryAccessor();
            if (separatorPosition == -1) {
                entryAccessor.addChildAction(target, (AFreeplaneAction)MIconController.this.iconActions.get(icon));
            } else {
                String submenuName = fileName.substring(0, separatorPosition);
                String submenuKey = itemKey + "/" + submenuName;
                Entry submenu = this.submenuEntries.get(submenuKey);
                if (submenu == null) {
                    submenu = new Entry();
                    entryAccessor.setText(submenu, submenuName);
                    this.submenuEntries.put(submenuKey, submenu);
                    target.addChild(submenu);
                }
                this.addAction(submenu, submenuKey, icon, fileName.substring(separatorPosition + 1));
            }
        }

        public boolean shouldSkipChildren(Entry entry) {
            return false;
        }
    }
}

