/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryLevels;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;

public class NewParentNode
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public NewParentNode() {
        super("NewParentNode");
    }

    public void actionPerformed(ActionEvent e) {
        final NodeModel selectedNode = Controller.getCurrentModeController().getMapController().getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        Collection unmodifyable = Controller.getCurrentModeController().getMapController().getSelectedNodes();
        ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>(unmodifyable.size());
        selectedNodes.addAll(unmodifyable);
        Controller.getCurrentModeController().getMapController().sortNodesByDepth(selectedNodes);
        if (selectedNode.isRoot()) {
            UITools.errorMessage((Object)TextUtils.getText((String)"cannot_add_parent_to_root"));
            return;
        }
        final NodeModel newNode = this.moveToNewParent(selectedNode, selectedNodes);
        if (newNode == null) {
            return;
        }
        Controller.getCurrentController().getSelection().selectAsTheOnlyOneSelected(newNode);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((MTextController)TextController.getController()).edit(newNode, selectedNode, true, false, false);
            }
        });
    }

    private NodeModel moveToNewParent(NodeModel selectedNode, List<NodeModel> selectedNodes) {
        Collection summarizedNodes;
        NodeModel oldParent = selectedNode.getParentNode();
        for (NodeModel node : selectedNodes) {
            if (node.getParentNode() != oldParent) {
                UITools.errorMessage((Object)TextUtils.getText((String)"cannot_add_parent_diff_parents"));
                return null;
            }
            if (!node.isRoot()) continue;
            UITools.errorMessage((Object)TextUtils.getText((String)"cannot_add_parent_to_root"));
            return null;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        SummaryLevels summaryLevels = new SummaryLevels(oldParent);
        int childPosition = selectedNode.getIndex();
        NodeModel summaryNode = summaryLevels.findSummaryNode(childPosition);
        if (summaryNode != null && selectedNodes.containsAll(summarizedNodes = summaryLevels.summarizedNodes(summaryNode))) {
            childPosition = summaryLevels.findGroupBeginNodeIndex(childPosition);
        }
        NodeModel newParent = mapController.addNewNode(oldParent, childPosition, selectedNode.isLeft());
        mapController.moveNodesAsChildren(selectedNodes, newParent, false, false);
        return newParent;
    }
}

