/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.event.ActionEvent;
import java.util.List;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

class NewSummaryAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private int start;
    private int end;
    private int summaryLevel;

    public NewSummaryAction() {
        super("NewSummaryAction");
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.addNewSummaryNodeStartEditing()) {
            UITools.errorMessage((Object)TextUtils.getText((String)"summary_not_possible"));
        }
    }

    private boolean addNewSummaryNodeStartEditing() {
        ModeController modeController = Controller.getCurrentModeController();
        IMapSelection selection = modeController.getController().getSelection();
        List sortedSelection = selection.getSortedSelection(false);
        NodeModel firstNode = (NodeModel)sortedSelection.get(0);
        NodeModel lastNode = (NodeModel)sortedSelection.get(sortedSelection.size() - 1);
        boolean isLeft = firstNode.isLeft();
        if (isLeft != lastNode.isLeft()) {
            return false;
        }
        NodeModel parentNode = firstNode.getParentNode();
        if (parentNode == null) {
            return false;
        }
        NodeModel lastParent = lastNode.getParentNode();
        if (lastParent == null) {
            return false;
        }
        if (parentNode.equals(lastParent)) {
            return this.addNewSummaryNodeStartEditing(firstNode, lastNode);
        }
        NodeRelativePath nodeRelativePath = new NodeRelativePath(firstNode, lastNode);
        NodeModel commonAncestor = nodeRelativePath.commonAncestor();
        if (commonAncestor == firstNode || commonAncestor == lastNode) {
            return false;
        }
        NodeModel newFirstNode = nodeRelativePath.beginPathElement(1);
        NodeModel newLastNode = nodeRelativePath.endPathElement(1);
        return this.addNewSummaryNodeStartEditing(newFirstNode, newLastNode);
    }

    private boolean addNewSummaryNodeStartEditing(NodeModel firstNode, NodeModel lastNode) {
        NodeModel parentNode = firstNode.getParentNode();
        ModeController modeController = Controller.getCurrentModeController();
        boolean isLeft = firstNode.isLeft();
        this.start = parentNode.getIndex(firstNode);
        this.end = parentNode.getIndex(lastNode);
        if (this.end < this.start) {
            int temp = this.end;
            this.end = this.start;
            this.start = temp;
        }
        this.summaryLevel = SummaryNode.getSummaryLevel((NodeModel)firstNode);
        if (this.summaryLevel != SummaryNode.getSummaryLevel((NodeModel)lastNode)) {
            return false;
        }
        int level = this.summaryLevel;
        for (int i = this.start + 1; i < this.end; ++i) {
            NodeModel node = parentNode.getChildAt(i);
            if (isLeft != node.isLeft()) continue;
            level = SummaryNode.isSummaryNode((NodeModel)node) ? ++level : 0;
            if (level <= this.summaryLevel) continue;
            return false;
        }
        ((MMapController)modeController.getMapController()).addNewSummaryNodeStartEditing(parentNode, this.start, this.end, this.summaryLevel, isLeft);
        return true;
    }
}

