/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryLevels;
import org.freeplane.features.map.SummaryNode;

public class SummaryGroupEdgeListAdder {
    private final Collection<NodeModel> nodes;
    private List<NodeModel> nodesWithSummaryNodes;

    public SummaryGroupEdgeListAdder(Collection<NodeModel> nodes) {
        this.nodes = nodes;
    }

    public List<NodeModel> addSummaryEdgeNodes() {
        HashMap<NodeModel, ParentProcessedNodes> processedNodes = new HashMap<NodeModel, ParentProcessedNodes>();
        this.nodesWithSummaryNodes = new LinkedList<NodeModel>();
        for (NodeModel node : this.nodes) {
            NodeModel parentNode = node.getParentNode();
            if (parentNode != null) {
                ParentProcessedNodes parentProcessedNodes = (ParentProcessedNodes)processedNodes.get(parentNode);
                if (parentProcessedNodes == null) {
                    parentProcessedNodes = new ParentProcessedNodes(parentNode);
                    processedNodes.put(parentNode, parentProcessedNodes);
                }
                parentProcessedNodes.addSummaryEdgeNodes(node);
                continue;
            }
            this.nodesWithSummaryNodes.add(node);
        }
        return this.nodesWithSummaryNodes;
    }

    private class ParentProcessedNodes {
        int lastSummaryNodeIndex = -1;
        int lastAddedNodeIndex = -1;
        final SummaryLevels summaryLevels;
        private final NodeModel parentNode;

        ParentProcessedNodes(NodeModel parent) {
            this.summaryLevels = new SummaryLevels(parent);
            this.parentNode = parent;
        }

        void addSummaryEdgeNodes(NodeModel node) {
            int nodeIndex = node.getIndex();
            if (this.lastSummaryNodeIndex >= nodeIndex) {
                if (this.summaryLevels.summaryLevels[nodeIndex] == 0) {
                    SummaryGroupEdgeListAdder.this.nodesWithSummaryNodes.add(++this.lastAddedNodeIndex, node);
                }
            } else {
                int groupBeginNodeIndex = this.summaryLevels.findGroupBeginNodeIndex(nodeIndex);
                NodeModel groupBeginNode = this.parentNode.getChildAt(groupBeginNodeIndex);
                this.lastSummaryNodeIndex = this.summaryLevels.findSummaryNodeIndex(nodeIndex);
                if (this.lastSummaryNodeIndex != -1) {
                    NodeModel summaryNode = this.parentNode.getChildAt(this.lastSummaryNodeIndex);
                    Collection summarizedNodes = this.summaryLevels.summarizedNodes(summaryNode);
                    if (SummaryGroupEdgeListAdder.this.nodes.containsAll(summarizedNodes)) {
                        NodeModel nextNode;
                        if (groupBeginNode != null) {
                            SummaryGroupEdgeListAdder.this.nodesWithSummaryNodes.add(groupBeginNode);
                            ++this.lastAddedNodeIndex;
                        }
                        if (groupBeginNode != node) {
                            SummaryGroupEdgeListAdder.this.nodesWithSummaryNodes.add(node);
                            ++this.lastAddedNodeIndex;
                        }
                        SummaryGroupEdgeListAdder.this.nodesWithSummaryNodes.add(summaryNode);
                        while (this.parentNode.getChildCount() > this.lastSummaryNodeIndex + 1 && SummaryNode.isSummaryNode((NodeModel)(nextNode = this.parentNode.getChildAt(this.lastSummaryNodeIndex + 1)))) {
                            ++this.lastSummaryNodeIndex;
                            Collection summarizedSummaries = this.summaryLevels.summarizedNodes(nextNode);
                            if (!SummaryGroupEdgeListAdder.this.nodesWithSummaryNodes.containsAll(summarizedSummaries)) break;
                            SummaryGroupEdgeListAdder.this.nodesWithSummaryNodes.add(nextNode);
                        }
                        return;
                    }
                }
                ++this.lastAddedNodeIndex;
                SummaryGroupEdgeListAdder.this.nodesWithSummaryNodes.add(node);
            }
        }
    }
}

