/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode.mindmapmode;

import java.net.URL;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.UIManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.resources.components.PropertyAction;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.RedoAction;
import org.freeplane.features.mode.mindmapmode.SaveAcceleratorPresetsAction;
import org.freeplane.features.mode.mindmapmode.SelectAllAction;
import org.freeplane.features.mode.mindmapmode.SelectBranchAction;
import org.freeplane.features.mode.mindmapmode.UndoAction;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

public class MModeController
extends ModeController {
    private static final String LOOKANDFEEL_PROPERTY = "lookandfeel";
    public static final String MODENAME = "MindMap";
    private RedoAction redo;
    public static final String RESOURCES_DELETE_NODES_WITHOUT_QUESTION = "delete_nodes_without_question";
    private UndoAction undo;
    private OptionPanelBuilder optionPanelBuilder;

    public static MModeController getMModeController() {
        Controller controller = Controller.getCurrentController();
        return (MModeController)controller.getModeController(MODENAME);
    }

    public MModeController(Controller controller) {
        super(controller);
        this.createActions();
        this.createOptionPanelControls();
    }

    private void addUndoableActor(IActor actor, MapModel map) {
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.addActor(actor);
    }

    public void deactivateUndo(MMapModel map) {
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.deactivate();
    }

    public void commit() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.commit();
    }

    public void delayedCommit() {
        MMapModel map = (MMapModel)this.getController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.delayedCommit();
    }

    public void delayedRollback() {
        MMapModel map = (MMapModel)this.getController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.delayedRollback();
    }

    private void createActions() {
        this.undo = new UndoAction();
        this.redo = new RedoAction();
        this.undo.setRedo((Action)((Object)this.redo));
        this.redo.setUndo((Action)((Object)this.undo));
        this.addAction(this.undo);
        this.addAction(this.redo);
        this.addAction((AFreeplaneAction)new SelectBranchAction());
        this.addAction((AFreeplaneAction)new SelectAllAction());
        this.addAction(new SaveAcceleratorPresetsAction());
    }

    private void createOptionPanelControls() {
        this.optionPanelBuilder = new OptionPanelBuilder();
        ResourceController resourceController = ResourceController.getResourceController();
        URL preferences = resourceController.getResource("/xml/preferences.xml");
        this.optionPanelBuilder.load(preferences);
        this.addAction((AFreeplaneAction)MModeController.createPropertyAction(this.optionPanelBuilder));
    }

    public static PropertyAction createPropertyAction(OptionPanelBuilder optionPanelBuilder) {
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        Vector<String> lafNames = new Vector<String>(lafInfo.length + 1);
        Vector<String> translatedLafNames = new Vector<String>(lafInfo.length + 1);
        lafNames.add("default");
        translatedLafNames.add(TextUtils.getOptionalText((String)"OptionPanel.default"));
        for (int i = 0; i < lafInfo.length; ++i) {
            UIManager.LookAndFeelInfo info = lafInfo[i];
            String className = info.getClassName();
            lafNames.add(className);
            translatedLafNames.add(info.getName());
        }
        MModeController.addCurrentLookAndFeelIfNecessary(lafNames, translatedLafNames);
        optionPanelBuilder.addEditableComboProperty("Appearance/look_and_feel/lookandfeel", LOOKANDFEEL_PROPERTY, lafNames, translatedLafNames, 0);
        return new PropertyAction(optionPanelBuilder.getRoot());
    }

    private static void addCurrentLookAndFeelIfNecessary(Vector<String> lafNames, Vector<String> translatedLafNames) {
        String currentLaf = ResourceController.getResourceController().getProperty(LOOKANDFEEL_PROPERTY);
        if (!lafNames.contains(currentLaf)) {
            lafNames.add(currentLaf);
            translatedLafNames.add(currentLaf.replaceFirst(".*\\.", ""));
        }
    }

    public void execute(IActor actor, MapModel map) {
        this.addUndoableActor(actor, map);
        actor.act();
    }

    public String getModeName() {
        return MODENAME;
    }

    public OptionPanelBuilder getOptionPanelBuilder() {
        return this.optionPanelBuilder;
    }

    public boolean isUndoAction() {
        MapModel model = this.getController().getMap();
        if (!(model instanceof MMapModel)) {
            return false;
        }
        return ((IUndoHandler)((MMapModel)model).getExtension(IUndoHandler.class)).isUndoActionRunning();
    }

    public void rollback() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.rollback();
    }

    public boolean save() {
        return ((MFileManager)UrlManager.getController()).save(this.getController().getMap());
    }

    public void shutdown() {
        super.shutdown();
        MNoteController noteController = (MNoteController)NoteController.getController();
        if (noteController != null) {
            noteController.shutdownController();
        }
    }

    public void startTransaction() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.startTransaction();
    }

    public void forceNewTransaction() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.forceNewTransaction();
    }

    public void startup() {
        super.startup();
        NoteController noteController = NoteController.getController();
        if (noteController != null) {
            ((MNoteController)noteController).startupController();
        }
    }

    public void undo() {
        this.undo.actionPerformed(null);
    }

    public void resetRedo() {
        this.redo.reset();
    }

    public boolean canEdit() {
        return true;
    }

    public boolean supportsHookActions() {
        return true;
    }

    public boolean shouldCenterCompactMaps() {
        return ResourceController.getResourceController().getBooleanProperty("shouldCenterSmallMaps");
    }
}

