/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode.mindmapmode;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;

class UndoAction
extends AFreeplaneAction
implements IMapSelectionListener {
    private static final long serialVersionUID = 1L;
    private Action redo;
    private final ChangeListener changeListener;

    public UndoAction() {
        super("UndoAction");
        Controller.getCurrentController().getMapViewManager().addMapSelectionListener((IMapSelectionListener)this);
        this.setEnabled(false);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MapModel map = Controller.getCurrentController().getMap();
                IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
                if (undoHandler == null) {
                    return;
                }
                Object eventSource = e.getSource();
                if (!eventSource.equals(undoHandler)) {
                    return;
                }
                UndoAction.this.setEnabled(undoHandler.canUndo());
                UndoAction.this.redo.setEnabled(undoHandler.canRedo());
            }
        };
    }

    public void actionPerformed(ActionEvent e) {
        if (UITools.isEditingText()) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.getUndoAction().actionPerformed(e);
    }

    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        IUndoHandler undoHandler;
        if (oldMap instanceof MMapModel) {
            undoHandler = (IUndoHandler)oldMap.getExtension(IUndoHandler.class);
            undoHandler.removeChangeListener(this.changeListener);
        }
        if (newMap == null) {
            this.setEnabled(false);
            this.redo.setEnabled(false);
            return;
        }
        undoHandler = (IUndoHandler)newMap.getExtension(IUndoHandler.class);
        if (undoHandler != null) {
            this.setEnabled(undoHandler.canUndo());
            this.redo.setEnabled(undoHandler.canRedo());
            undoHandler.addChangeListener(this.changeListener);
        }
    }

    public void afterMapChange(Object newMap) {
    }

    public void beforeMapChange(MapModel oldMap, MapModel newMap) {
    }

    public void setRedo(Action redo) {
        this.redo = redo;
    }
}

