/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.ColorProperty;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.FontProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.NextColumnProperty;
import org.freeplane.core.resources.components.NextLineProperty;
import org.freeplane.core.resources.components.NumberProperty;
import org.freeplane.core.resources.components.QuantityProperty;
import org.freeplane.core.resources.components.SeparatorProperty;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElement;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.Quantity;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.cloud.mindmapmode.MCloudController;
import org.freeplane.features.edge.AutomaticEdgeColor;
import org.freeplane.features.edge.AutomaticEdgeColorHook;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.format.PatternFormat;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.AMapChangeListenerAdapter;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.AutomaticLayout;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.mindmapmode.EditablePatternComboProperty;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.styles.mindmapmode.MUIFactory;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;

public class StyleEditorPanel
extends JPanel {
    private static final int FONT_SIZE = Math.round(UITools.FONT_SCALE_FACTOR * 8.0f);
    private static final TranslatedObject AUTOMATIC_LAYOUT_DISABLED = new TranslatedObject("automatic_layout_disabled");
    private static final String CLOUD_COLOR = "cloudcolor";
    private static final String EDGE_COLOR = "edgecolor";
    private static final String EDGE_STYLE = "edgestyle";
    private static final String CLOUD_SHAPE = "cloudshape";
    private static final String[] EDGE_STYLES = StyleEditorPanel.enumStrings(EdgeStyle.class, EdgeStyle.values().length - 1);
    private static final String[] CLOUD_SHAPES = StyleEditorPanel.enumStrings(CloudModel.Shape.class);
    private static final String EDGE_WIDTH = "edgewidth";
    private static final String NODE_BACKGROUND_COLOR = "nodebackgroundcolor";
    private static final String NODE_COLOR = "nodecolor";
    private static final String NODE_FONT_BOLD = "nodefontbold";
    private static final String NODE_FONT_ITALIC = "nodefontitalic";
    private static final String NODE_FONT_HYPERLINK = "nodefonthyperlink";
    private static final String NODE_FONT_NAME = "nodefontname";
    private static final String NODE_FONT_SIZE = "nodefontsize";
    private static final String NODE_NUMBERING = "nodenumbering";
    private static final String NODE_SHAPE = "nodeshape";
    private static final String NODE_TEXT_COLOR = "standardnodetextcolor";
    private static final String NODE_FORMAT = "nodeformat";
    private static final String TEXT_ALIGNMENT = "textalignment";
    private static final String[] TEXT_ALIGNMENTS = StyleEditorPanel.enumStrings(NodeStyleModel.TextAlign.class);
    private static final long serialVersionUID = 1L;
    private static final String SET_RESOURCE = "set_property_text";
    private static final String MAX_TEXT_WIDTH = "max_node_width";
    private static final String MIN_NODE_WIDTH = "min_node_width";
    private static final String VERTICAL_CHILD_GAP = "vertical_child_gap";
    private static final String SHAPE_HORIZONTAL_MARGIN = "shape_horizontal_margin";
    private static final String SHAPE_VERTICAL_MARGIN = "shape_vertical_margin";
    private static final String UNIFORM_SHAPE = "uniform_shape";
    private boolean internalChange;
    private ColorProperty mCloudColor;
    private ComboProperty mCloudShape;
    private List<IPropertyControl> mControls;
    private ColorProperty mEdgeColor;
    private ComboProperty mEdgeStyle;
    private NumberProperty mEdgeWidth;
    private ColorProperty mNodeBackgroundColor;
    private ColorProperty mNodeColor;
    private BooleanProperty mNodeFontBold;
    private BooleanProperty mNodeFontItalic;
    private BooleanProperty mNodeFontHyperlink;
    private FontProperty mNodeFontName;
    private ComboProperty mNodeFontSize;
    private BooleanProperty mNodeNumbering;
    private ComboProperty mNodeShape;
    private QuantityProperty<LengthUnits> mShapeHorizontalMargin;
    private QuantityProperty<LengthUnits> mShapeVerticalMargin;
    private BooleanProperty mUniformShape;
    private EditablePatternComboProperty mNodeFormat;
    private QuantityProperty<LengthUnits> mMaxNodeWidth;
    private QuantityProperty<LengthUnits> mMinNodeWidth;
    private QuantityProperty<LengthUnits> mChildDistance;
    private ComboProperty mNodeTextAlignment;
    private BooleanProperty mSetCloud;
    private BooleanProperty mSetEdgeColor;
    private BooleanProperty mSetEdgeStyle;
    private BooleanProperty mSetEdgeWidth;
    private BooleanProperty mSetNodeBackgroundColor;
    private BooleanProperty mSetNodeColor;
    private BooleanProperty mSetNodeFontBold;
    private BooleanProperty mSetNodeFontItalic;
    private BooleanProperty mSetNodeFontHyperlink;
    private BooleanProperty mSetNodeFontName;
    private BooleanProperty mSetNodeFontSize;
    private BooleanProperty mSetNodeNumbering;
    private BooleanProperty mSetNodeShape;
    private BooleanProperty mSetNodeFormat;
    private BooleanProperty mSetStyle;
    private BooleanProperty mSetMaxNodeWidth;
    private BooleanProperty mSetMinNodeWidth;
    private BooleanProperty mSetChildDistance;
    private BooleanProperty mSetNodeTextAlignment;
    private final boolean addStyleBox;
    private final MUIFactory uiFactory;
    private final ModeController modeController;
    private JButton mNodeStyleButton;
    private JButton mMapStyleButton;
    private JComboBox mAutomaticLayoutComboBox;
    private JComboBox mAutomaticEdgeColorComboBox;
    private Container mStyleBox;

    private static <U extends Enum<U>> String[] enumStrings(Class<U> enumerationClass, int length) {
        Enum[] enumConstants = (Enum[])enumerationClass.getEnumConstants();
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = enumConstants[i].toString();
        }
        return strings;
    }

    private static <U extends Enum<U>> String[] enumStrings(Class<U> enumerationClass) {
        return StyleEditorPanel.enumStrings(enumerationClass, ((Enum[])enumerationClass.getEnumConstants()).length);
    }

    public StyleEditorPanel(ModeController modeController, MUIFactory uiFactory, boolean addStyleBox) throws HeadlessException {
        this.modeController = modeController;
        this.addStyleBox = addStyleBox;
        this.uiFactory = uiFactory;
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (StyleEditorPanel.this.isDisplayable()) {
                    StyleEditorPanel.this.removeHierarchyListener(this);
                    StyleEditorPanel.this.init();
                }
            }
        });
    }

    private void addBgColorControl(List<IPropertyControl> controls) {
        this.mSetNodeBackgroundColor = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeBackgroundColor);
        this.mNodeBackgroundColor = new ColorProperty(NODE_BACKGROUND_COLOR, ResourceController.getResourceController().getDefaultProperty(NODE_BACKGROUND_COLOR));
        controls.add((IPropertyControl)this.mNodeBackgroundColor);
        BgColorChangeListener listener = new BgColorChangeListener(this.mSetNodeBackgroundColor, (IPropertyControl)this.mNodeBackgroundColor);
        this.mSetNodeBackgroundColor.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeBackgroundColor.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addFormatControl(List<IPropertyControl> controls) {
        this.mSetNodeFormat = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeFormat);
        this.mNodeFormat = new EditablePatternComboProperty(NODE_FORMAT, PatternFormat.getIdentityPatternFormat(), FormatController.getController().getAllFormats());
        controls.add((IPropertyControl)this.mNodeFormat);
        NodeFormatChangeListener listener = new NodeFormatChangeListener(this.mSetNodeFormat, (IPropertyControl)this.mNodeFormat);
        this.mSetNodeFormat.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeFormat.addPropertyChangeListener(listener);
    }

    private void addNodeNumberingControl(List<IPropertyControl> controls) {
        this.mSetNodeNumbering = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeNumbering);
        this.mNodeNumbering = new BooleanProperty(NODE_NUMBERING);
        controls.add((IPropertyControl)this.mNodeNumbering);
        NodeNumberingChangeListener listener = new NodeNumberingChangeListener(this.mSetNodeNumbering, (IPropertyControl)this.mNodeNumbering);
        this.mSetNodeNumbering.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeNumbering.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addCloudColorControl(List<IPropertyControl> controls) {
        this.mSetCloud = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetCloud);
        this.mCloudColor = new ColorProperty(CLOUD_COLOR, ResourceController.getResourceController().getDefaultProperty("standardcloudcolor"));
        controls.add((IPropertyControl)this.mCloudColor);
        CloudColorChangeListener listener = new CloudColorChangeListener(this.mSetCloud, (IPropertyControl)this.mCloudColor);
        this.mSetCloud.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mCloudColor.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addColorControl(List<IPropertyControl> controls) {
        this.mSetNodeColor = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeColor);
        this.mNodeColor = new ColorProperty(NODE_COLOR, ResourceController.getResourceController().getDefaultProperty(NODE_TEXT_COLOR));
        controls.add((IPropertyControl)this.mNodeColor);
        ColorChangeListener listener = new ColorChangeListener(this.mSetNodeColor, (IPropertyControl)this.mNodeColor);
        this.mSetNodeColor.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeColor.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addEdgeColorControl(List<IPropertyControl> controls) {
        this.mSetEdgeColor = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetEdgeColor);
        this.mEdgeColor = new ColorProperty(EDGE_COLOR, ColorUtils.colorToString((Color)EdgeController.STANDARD_EDGE_COLOR));
        controls.add((IPropertyControl)this.mEdgeColor);
        EdgeColorChangeListener listener = new EdgeColorChangeListener(this.mSetEdgeColor, (IPropertyControl)this.mEdgeColor);
        this.mSetEdgeColor.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mEdgeColor.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addEdgeStyleControl(List<IPropertyControl> controls) {
        this.mSetEdgeStyle = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetEdgeStyle);
        this.mEdgeStyle = new ComboProperty(EDGE_STYLE, EDGE_STYLES);
        controls.add((IPropertyControl)this.mEdgeStyle);
        EdgeStyleChangeListener listener = new EdgeStyleChangeListener(this.mSetEdgeStyle, (IPropertyControl)this.mEdgeStyle);
        this.mSetEdgeStyle.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mEdgeStyle.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addCloudShapeControl(List<IPropertyControl> controls) {
        this.mCloudShape = new ComboProperty(CLOUD_SHAPE, CLOUD_SHAPES);
        controls.add((IPropertyControl)this.mCloudShape);
        CloudShapeChangeListener listener = new CloudShapeChangeListener(this.mSetCloud, (IPropertyControl)this.mCloudShape);
        this.mSetCloud.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mCloudShape.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addEdgeWidthControl(List<IPropertyControl> controls) {
        this.mSetEdgeWidth = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetEdgeWidth);
        this.mEdgeWidth = new NumberProperty(EDGE_WIDTH, 0, 100, 1);
        controls.add((IPropertyControl)this.mEdgeWidth);
        EdgeWidthChangeListener listener = new EdgeWidthChangeListener(this.mSetEdgeWidth, (IPropertyControl)this.mEdgeWidth);
        this.mSetEdgeWidth.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mEdgeWidth.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addMaxNodeWidthControl(List<IPropertyControl> controls) {
        this.mSetMaxNodeWidth = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetMaxNodeWidth);
        this.mMaxNodeWidth = new QuantityProperty(MAX_TEXT_WIDTH, 0.0, 100000.0, 0.1, (Enum)LengthUnits.px);
        controls.add((IPropertyControl)this.mMaxNodeWidth);
        MaxNodeWidthChangeListener listener = new MaxNodeWidthChangeListener(this.mSetMaxNodeWidth, (IPropertyControl)this.mMaxNodeWidth);
        this.mSetMaxNodeWidth.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mMaxNodeWidth.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addMinNodeWidthControl(List<IPropertyControl> controls) {
        this.mSetMinNodeWidth = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetMinNodeWidth);
        this.mMinNodeWidth = new QuantityProperty(MIN_NODE_WIDTH, 0.0, 100000.0, 0.1, (Enum)LengthUnits.px);
        controls.add((IPropertyControl)this.mMinNodeWidth);
        MinNodeWidthChangeListener listener = new MinNodeWidthChangeListener(this.mSetMinNodeWidth, (IPropertyControl)this.mMinNodeWidth);
        this.mSetMinNodeWidth.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mMinNodeWidth.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addChildDistanceControl(List<IPropertyControl> controls) {
        this.mSetChildDistance = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetChildDistance);
        this.mChildDistance = new QuantityProperty(VERTICAL_CHILD_GAP, 0.0, 1000.0, 0.1, (Enum)LengthUnits.px);
        controls.add((IPropertyControl)this.mChildDistance);
        ChildDistanceChangeListener listener = new ChildDistanceChangeListener(this.mSetChildDistance, (IPropertyControl)this.mChildDistance);
        this.mSetChildDistance.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mChildDistance.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addFontBoldControl(List<IPropertyControl> controls) {
        this.mSetNodeFontBold = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeFontBold);
        this.mNodeFontBold = new BooleanProperty(NODE_FONT_BOLD);
        controls.add((IPropertyControl)this.mNodeFontBold);
        FontBoldChangeListener listener = new FontBoldChangeListener(this.mSetNodeFontBold, (IPropertyControl)this.mNodeFontBold);
        this.mSetNodeFontBold.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeFontBold.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addFontItalicControl(List<IPropertyControl> controls) {
        this.mSetNodeFontItalic = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeFontItalic);
        this.mNodeFontItalic = new BooleanProperty(NODE_FONT_ITALIC);
        controls.add((IPropertyControl)this.mNodeFontItalic);
        FontItalicChangeListener listener = new FontItalicChangeListener(this.mSetNodeFontItalic, (IPropertyControl)this.mNodeFontItalic);
        this.mSetNodeFontItalic.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeFontItalic.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addFontHyperlinkControl(List<IPropertyControl> controls) {
        this.mSetNodeFontHyperlink = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeFontHyperlink);
        this.mNodeFontHyperlink = new BooleanProperty(NODE_FONT_HYPERLINK);
        controls.add((IPropertyControl)this.mNodeFontHyperlink);
        FontHyperlinkChangeListener listener = new FontHyperlinkChangeListener(this.mSetNodeFontHyperlink, (IPropertyControl)this.mNodeFontHyperlink);
        this.mSetNodeFontHyperlink.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeFontHyperlink.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addFontNameControl(List<IPropertyControl> controls) {
        this.mSetNodeFontName = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeFontName);
        this.mNodeFontName = new FontProperty(NODE_FONT_NAME);
        controls.add((IPropertyControl)this.mNodeFontName);
        FontNameChangeListener listener = new FontNameChangeListener(this.mSetNodeFontName, (IPropertyControl)this.mNodeFontName);
        this.mSetNodeFontName.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeFontName.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addFontSizeControl(List<IPropertyControl> controls) {
        this.mSetNodeFontSize = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeFontSize);
        ArrayList<String> sizesVector = new ArrayList<String>(Arrays.asList(MUIFactory.FONT_SIZES));
        this.mNodeFontSize = new ComboProperty(NODE_FONT_SIZE, sizesVector, sizesVector);
        this.mNodeFontSize.setEditable(true);
        controls.add((IPropertyControl)this.mNodeFontSize);
        FontSizeChangeListener listener = new FontSizeChangeListener(this.mSetNodeFontSize, (IPropertyControl)this.mNodeFontSize);
        this.mSetNodeFontSize.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeFontSize.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addNodeShapeControls(List<IPropertyControl> controls) {
        this.mSetNodeShape = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeShape);
        this.mNodeShape = new ComboProperty(NODE_SHAPE, StyleEditorPanel.enumStrings(NodeStyleModel.Shape.class));
        controls.add((IPropertyControl)this.mNodeShape);
        controls.add((IPropertyControl)new NextColumnProperty(2));
        this.mShapeHorizontalMargin = new QuantityProperty(SHAPE_HORIZONTAL_MARGIN, 0.0, 1000.0, 0.1, (Enum)LengthUnits.pt);
        controls.add((IPropertyControl)this.mShapeHorizontalMargin);
        controls.add((IPropertyControl)new NextColumnProperty(2));
        this.mShapeVerticalMargin = new QuantityProperty(SHAPE_VERTICAL_MARGIN, 0.0, 1000.0, 0.1, (Enum)LengthUnits.pt);
        controls.add((IPropertyControl)this.mShapeVerticalMargin);
        controls.add((IPropertyControl)new NextColumnProperty(2));
        this.mUniformShape = new BooleanProperty(UNIFORM_SHAPE);
        controls.add((IPropertyControl)this.mUniformShape);
        NodeShapeChangeListener listener = new NodeShapeChangeListener(this.mSetNodeShape, new IPropertyControl[]{this.mNodeShape, this.mShapeHorizontalMargin, this.mShapeVerticalMargin, this.mUniformShape});
        this.mSetNodeShape.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeShape.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mShapeHorizontalMargin.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mShapeVerticalMargin.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mUniformShape.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void addNodeTextAlignmentControl(List<IPropertyControl> controls) {
        this.mSetNodeTextAlignment = new BooleanProperty(SET_RESOURCE);
        controls.add((IPropertyControl)this.mSetNodeTextAlignment);
        Vector<String> possibleTranslations = new Vector<String>(TEXT_ALIGNMENTS.length);
        for (int i = 0; i < TEXT_ALIGNMENTS.length; ++i) {
            possibleTranslations.add(TextUtils.getText((String)("TextAlignAction." + TEXT_ALIGNMENTS[i] + ".text")));
        }
        Vector<String> translations = possibleTranslations;
        this.mNodeTextAlignment = new ComboProperty(TEXT_ALIGNMENT, Arrays.asList(TEXT_ALIGNMENTS), translations);
        controls.add((IPropertyControl)this.mNodeTextAlignment);
        TextAlignmentChangeListener listener = new TextAlignmentChangeListener(this.mSetNodeTextAlignment, (IPropertyControl)this.mNodeTextAlignment);
        this.mSetNodeTextAlignment.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mNodeTextAlignment.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private List<IPropertyControl> getControls() {
        ArrayList<IPropertyControl> controls = new ArrayList<IPropertyControl>();
        controls.add((IPropertyControl)new SeparatorProperty("OptionPanel.separator.NodeColors"));
        this.addColorControl(controls);
        this.addBgColorControl(controls);
        controls.add((IPropertyControl)new SeparatorProperty("OptionPanel.separator.NodeText"));
        this.addFormatControl(controls);
        this.addNodeNumberingControl(controls);
        controls.add((IPropertyControl)new SeparatorProperty("OptionPanel.separator.NodeShape"));
        this.addNodeShapeControls(controls);
        this.addMinNodeWidthControl(controls);
        this.addMaxNodeWidthControl(controls);
        this.addChildDistanceControl(controls);
        controls.add((IPropertyControl)new NextLineProperty());
        controls.add((IPropertyControl)new SeparatorProperty("OptionPanel.separator.NodeFont"));
        this.addFontNameControl(controls);
        this.addFontSizeControl(controls);
        this.addFontBoldControl(controls);
        this.addFontItalicControl(controls);
        this.addNodeTextAlignmentControl(controls);
        this.addFontHyperlinkControl(controls);
        controls.add((IPropertyControl)new NextLineProperty());
        controls.add((IPropertyControl)new SeparatorProperty("OptionPanel.separator.EdgeControls"));
        this.addEdgeWidthControl(controls);
        this.addEdgeStyleControl(controls);
        this.addEdgeColorControl(controls);
        controls.add((IPropertyControl)new NextLineProperty());
        controls.add((IPropertyControl)new SeparatorProperty("OptionPanel.separator.CloudControls"));
        this.addCloudColorControl(controls);
        controls.add((IPropertyControl)new NextLineProperty());
        controls.add((IPropertyControl)new NextColumnProperty(2));
        this.addCloudShapeControl(controls);
        return controls;
    }

    private void init() {
        if (this.mControls != null) {
            return;
        }
        String form = "right:max(20dlu;p), 2dlu, p, 1dlu,right:max(20dlu;p), 4dlu, 80dlu, 7dlu";
        FormLayout rightLayout = new FormLayout("right:max(20dlu;p), 2dlu, p, 1dlu,right:max(20dlu;p), 4dlu, 80dlu, 7dlu", "");
        DefaultFormBuilder rightBuilder = new DefaultFormBuilder(rightLayout);
        rightBuilder.border(Borders.DLU2);
        new SeparatorProperty("OptionPanel.separator.NodeStyle").layout(rightBuilder);
        if (this.addStyleBox) {
            this.addAutomaticLayout(rightBuilder);
            this.addStyleBox(rightBuilder);
        }
        this.mNodeStyleButton = this.addStyleButton(rightBuilder, "actual_node_styles", this.modeController.getAction("ManageNodeConditionalStylesAction"));
        if (this.addStyleBox) {
            this.mMapStyleButton = this.addStyleButton(rightBuilder, "actual_map_styles", this.modeController.getAction("ManageConditionalStylesAction"));
        }
        this.mControls = this.getControls();
        for (IPropertyControl control : this.mControls) {
            control.layout(rightBuilder);
        }
        this.add((Component)rightBuilder.getPanel(), "Center");
        this.addListeners();
        this.setFont(this, FONT_SIZE);
    }

    private JButton addStyleButton(DefaultFormBuilder rightBuilder, String label, AFreeplaneAction action) {
        JButton button = new JButton(){
            private static final long serialVersionUID = 1L;
            {
                this.setUI(BasicButtonUI.createUI(this));
            }
        };
        button.addActionListener((ActionListener)action);
        button.setHorizontalAlignment(2);
        String labelText = TextUtils.getText((String)label);
        UITools.addTitledBorder((JComponent)button, (String)labelText, (float)FONT_SIZE);
        TranslatedElement.BORDER.setKey((JComponent)button, label);
        rightBuilder.append((Component)button, rightBuilder.getColumnCount());
        rightBuilder.nextLine();
        return button;
    }

    private void addStyleBox(DefaultFormBuilder rightBuilder) {
        this.mStyleBox = this.uiFactory.createStyleBox();
        this.mSetStyle = new BooleanProperty(SET_RESOURCE);
        StyleChangeListener listener = new StyleChangeListener();
        this.mSetStyle.addPropertyChangeListener((PropertyChangeListener)listener);
        this.mSetStyle.layout(rightBuilder);
        rightBuilder.append((Component)new JLabel(TextUtils.getText((String)"style")));
        rightBuilder.append((Component)this.mStyleBox);
        rightBuilder.nextLine();
    }

    private void addAutomaticLayout(DefaultFormBuilder rightBuilder) {
        Object[] automaticLayoutTypes;
        if (this.mAutomaticLayoutComboBox == null) {
            automaticLayoutTypes = TranslatedObject.fromEnum(AutomaticLayout.class);
            this.mAutomaticLayoutComboBox = new JComboBoxWithBorder(automaticLayoutTypes);
            DefaultComboBoxModel automaticLayoutComboBoxModel = (DefaultComboBoxModel)this.mAutomaticLayoutComboBox.getModel();
            automaticLayoutComboBoxModel.addElement(AUTOMATIC_LAYOUT_DISABLED);
            automaticLayoutComboBoxModel.setSelectedItem(AUTOMATIC_LAYOUT_DISABLED);
            this.mAutomaticLayoutComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (StyleEditorPanel.this.internalChange) {
                        return;
                    }
                    ModeController modeController = Controller.getCurrentModeController();
                    AutomaticLayoutController al = (AutomaticLayoutController)modeController.getExtension(AutomaticLayoutController.class);
                    TranslatedObject selectedItem = (TranslatedObject)StyleEditorPanel.this.mAutomaticLayoutComboBox.getSelectedItem();
                    al.undoableDeactivateHook(Controller.getCurrentController().getMap().getRootNode());
                    if (!selectedItem.equals((Object)AUTOMATIC_LAYOUT_DISABLED)) {
                        al.undoableActivateHook(Controller.getCurrentController().getMap().getRootNode(), (IExtension)((AutomaticLayout)selectedItem.getObject()));
                    }
                }
            });
        }
        this.appendLabeledComponent(rightBuilder, "AutomaticLayoutAction.text", this.mAutomaticLayoutComboBox);
        if (this.mAutomaticEdgeColorComboBox == null) {
            automaticLayoutTypes = TranslatedObject.fromEnum((String)(AutomaticEdgeColor.class.getSimpleName() + "."), AutomaticEdgeColor.Rule.class);
            this.mAutomaticEdgeColorComboBox = new JComboBoxWithBorder(automaticLayoutTypes);
            DefaultComboBoxModel automaticEdgeColorComboBoxModel = (DefaultComboBoxModel)this.mAutomaticEdgeColorComboBox.getModel();
            automaticEdgeColorComboBoxModel.addElement(AUTOMATIC_LAYOUT_DISABLED);
            automaticEdgeColorComboBoxModel.setSelectedItem(AUTOMATIC_LAYOUT_DISABLED);
            this.mAutomaticEdgeColorComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (StyleEditorPanel.this.internalChange) {
                        return;
                    }
                    ModeController modeController = Controller.getCurrentModeController();
                    AutomaticEdgeColorHook hook = (AutomaticEdgeColorHook)modeController.getExtension(AutomaticEdgeColorHook.class);
                    TranslatedObject selectedItem = (TranslatedObject)StyleEditorPanel.this.mAutomaticEdgeColorComboBox.getSelectedItem();
                    MapModel map = Controller.getCurrentController().getMap();
                    AutomaticEdgeColor oldExtension = (AutomaticEdgeColor)hook.getMapHook(map);
                    int colorCount = oldExtension == null ? 0 : oldExtension.getColorCounter();
                    NodeModel rootNode = map.getRootNode();
                    hook.undoableDeactivateHook(rootNode);
                    if (!selectedItem.equals((Object)AUTOMATIC_LAYOUT_DISABLED)) {
                        AutomaticEdgeColor newExtension = new AutomaticEdgeColor((AutomaticEdgeColor.Rule)selectedItem.getObject(), colorCount);
                        hook.undoableActivateHook(rootNode, (IExtension)newExtension);
                    }
                }
            });
        }
        this.appendLabeledComponent(rightBuilder, "AutomaticEdgeColorHookAction.text", this.mAutomaticEdgeColorComboBox);
    }

    private void appendLabeledComponent(DefaultFormBuilder rightBuilder, String labelKey, Component component) {
        String text = TextUtils.getText((String)labelKey);
        JLabel label = new JLabel(text);
        TranslatedElement.TEXT.setKey((JComponent)label, labelKey);
        rightBuilder.append((Component)label, 5);
        rightBuilder.append(component);
        rightBuilder.nextLine();
    }

    private void setFont(Container c, float size) {
        c.setFont(c.getFont().deriveFont(size));
        for (int i = 0; i < c.getComponentCount(); ++i) {
            this.setFont((Container)c.getComponent(i), size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStyle(NodeModel node) {
        if (this.internalChange) {
            return;
        }
        this.internalChange = true;
        try {
            IExtension extension;
            AutomaticLayoutController al;
            ModeController modeController;
            LogicalStyleController logicalStyleController = LogicalStyleController.getController();
            if (this.addStyleBox) {
                boolean isStyleSet = LogicalStyleModel.getStyle((NodeModel)node) != null;
                this.mSetStyle.setValue(isStyleSet);
                this.setStyleList(this.mMapStyleButton, logicalStyleController.getMapStyleNames(node, "\n"));
            }
            this.setStyleList(this.mNodeStyleButton, logicalStyleController.getNodeStyleNames(node, "\n"));
            NodeStyleController styleController = NodeStyleController.getController();
            Color nodeColor = NodeStyleModel.getColor((NodeModel)node);
            Color viewNodeColor = styleController.getColor(node);
            this.mSetNodeColor.setValue(nodeColor != null);
            this.mNodeColor.setColorValue(viewNodeColor);
            Color color = NodeStyleModel.getBackgroundColor((NodeModel)node);
            Color viewColor = styleController.getBackgroundColor(node);
            this.mSetNodeBackgroundColor.setValue(color != null);
            this.mNodeBackgroundColor.setColorValue(viewColor != null ? viewColor : Controller.getCurrentController().getMapViewManager().getBackgroundColor(node));
            NodeStyleModel.Shape shape = NodeStyleModel.getShape((NodeModel)node);
            ShapeConfigurationModel viewShape = styleController.getShapeConfiguration(node);
            boolean enabled = shape != null;
            this.mSetNodeShape.setValue(enabled);
            this.mNodeShape.setValue(viewShape.getShape().toString());
            this.enableShapeConfigurationProperties(enabled, shape);
            this.mShapeHorizontalMargin.setQuantifiedValue(viewShape.getHorizontalMargin());
            this.mShapeVerticalMargin.setQuantifiedValue(viewShape.getVerticalMargin());
            this.mUniformShape.setValue(viewShape.isUniform());
            NodeSizeModel nodeSizeModel = NodeSizeModel.getModel((NodeModel)node);
            Quantity width = nodeSizeModel != null ? nodeSizeModel.getMaxNodeWidth() : null;
            Quantity viewWidth = styleController.getMaxWidth(node);
            this.mSetMaxNodeWidth.setValue(width != null);
            this.mMaxNodeWidth.setQuantifiedValue(viewWidth);
            width = nodeSizeModel != null ? nodeSizeModel.getMinNodeWidth() : null;
            viewWidth = styleController.getMinWidth(node);
            this.mSetMinNodeWidth.setValue(width != null);
            this.mMinNodeWidth.setQuantifiedValue(viewWidth);
            LocationModel locationModel = LocationModel.getModel((NodeModel)node);
            LocationController locationController = (LocationController)this.modeController.getExtension(LocationController.class);
            Quantity gap = locationModel.getVGap();
            Quantity viewGap = locationController.getMinimalDistanceBetweenChildren(node);
            this.mSetChildDistance.setValue(gap != LocationModel.DEFAULT_VGAP);
            this.mChildDistance.setQuantifiedValue(viewGap);
            EdgeController edgeController = EdgeController.getController();
            EdgeModel edgeModel = EdgeModel.getModel((NodeModel)node);
            Color edgeColor = edgeModel != null ? edgeModel.getColor() : null;
            Color viewColor2 = edgeController.getColor(node);
            this.mSetEdgeColor.setValue(edgeColor != null);
            this.mEdgeColor.setColorValue(viewColor2);
            EdgeStyle style = edgeModel != null ? edgeModel.getStyle() : null;
            EdgeStyle viewStyle = edgeController.getStyle(node);
            this.mSetEdgeStyle.setValue(style != null);
            this.mEdgeStyle.setValue(viewStyle.toString());
            int width2 = edgeModel != null ? edgeModel.getWidth() : -1;
            int viewWidth2 = edgeController.getWidth(node);
            this.mSetEdgeWidth.setValue(width2 != -1);
            this.mEdgeWidth.setValue(Integer.toString(viewWidth2));
            CloudController cloudController = CloudController.getController();
            CloudModel cloudModel = CloudModel.getModel((NodeModel)node);
            Color viewCloudColor = cloudController.getColor(node);
            this.mSetCloud.setValue(cloudModel != null);
            this.mCloudColor.setColorValue(viewCloudColor);
            CloudModel.Shape viewCloudShape = cloudController.getShape(node);
            this.mCloudShape.setValue(viewCloudShape != null ? viewCloudShape.toString() : CloudModel.Shape.ARC.toString());
            String fontFamilyName = NodeStyleModel.getFontFamilyName((NodeModel)node);
            String viewFontFamilyName = styleController.getFontFamilyName(node);
            this.mSetNodeFontName.setValue(fontFamilyName != null);
            this.mNodeFontName.setValue(viewFontFamilyName);
            Integer fontSize = NodeStyleModel.getFontSize((NodeModel)node);
            Integer viewfontSize = styleController.getFontSize(node);
            this.mSetNodeFontSize.setValue(fontSize != null);
            this.mNodeFontSize.setValue(viewfontSize.toString());
            Boolean bold = NodeStyleModel.isBold((NodeModel)node);
            Boolean viewbold = styleController.isBold(node);
            this.mSetNodeFontBold.setValue(bold != null);
            this.mNodeFontBold.setValue(viewbold.booleanValue());
            Boolean italic = NodeStyleModel.isItalic((NodeModel)node);
            Boolean viewitalic = styleController.isItalic(node);
            this.mSetNodeFontItalic.setValue(italic != null);
            this.mNodeFontItalic.setValue(viewitalic.booleanValue());
            NodeStyleModel.TextAlign style2 = NodeStyleModel.getTextAlign((NodeModel)node);
            NodeStyleModel.TextAlign viewStyle2 = styleController.getTextAlign(node);
            this.mSetNodeTextAlignment.setValue(style2 != null);
            this.mNodeTextAlignment.setValue(viewStyle2.toString());
            Boolean hyperlink = NodeLinks.formatNodeAsHyperlink((NodeModel)node);
            Boolean viewhyperlink = LinkController.getController().formatNodeAsHyperlink(node);
            this.mSetNodeFontHyperlink.setValue(hyperlink != null);
            this.mNodeFontHyperlink.setValue(viewhyperlink.booleanValue());
            Boolean nodeNumbering = NodeStyleModel.getNodeNumbering((NodeModel)node);
            Boolean viewNodeNumbering = styleController.getNodeNumbering(node);
            this.mSetNodeNumbering.setValue(nodeNumbering != null);
            this.mNodeNumbering.setValue(viewNodeNumbering.booleanValue());
            String nodeFormat = NodeStyleModel.getNodeFormat((NodeModel)node);
            String viewNodeFormat = TextController.getController().getNodeFormat(node);
            this.mSetNodeFormat.setValue(nodeFormat != null);
            if (viewNodeFormat == null && node.getUserObject() instanceof IFormattedObject) {
                viewNodeFormat = ((IFormattedObject)node.getUserObject()).getPattern();
            }
            this.mNodeFormat.setValue(viewNodeFormat);
            if (this.mAutomaticLayoutComboBox != null) {
                modeController = Controller.getCurrentModeController();
                al = (AutomaticLayoutController)modeController.getExtension(AutomaticLayoutController.class);
                extension = al.getExtension(node);
                if (extension == null) {
                    this.mAutomaticLayoutComboBox.setSelectedItem(AUTOMATIC_LAYOUT_DISABLED);
                } else {
                    this.mAutomaticLayoutComboBox.setSelectedIndex(((AutomaticLayout)extension).ordinal());
                }
            }
            if (this.mAutomaticEdgeColorComboBox != null) {
                modeController = Controller.getCurrentModeController();
                al = (AutomaticEdgeColorHook)modeController.getExtension(AutomaticEdgeColorHook.class);
                extension = (AutomaticEdgeColor)al.getExtension(node);
                if (extension == null) {
                    this.mAutomaticEdgeColorComboBox.setSelectedItem(AUTOMATIC_LAYOUT_DISABLED);
                } else {
                    this.mAutomaticEdgeColorComboBox.setSelectedIndex(extension.rule.ordinal());
                }
            }
        }
        finally {
            this.internalChange = false;
        }
    }

    private void setStyleList(JButton btn, String styles) {
        if ("".equals(styles)) {
            btn.setToolTipText(null);
            btn.setText(" ");
            return;
        }
        btn.setToolTipText(HtmlUtils.plainToHTML((String)styles));
        String text = styles.replaceAll("\n", ", ");
        btn.setText(text);
    }

    private void addListeners() {
        final Controller controller = Controller.getCurrentController();
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        mapController.addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                if (selection.size() == 1) {
                    StyleEditorPanel.this.setStyle(node);
                }
            }

            public void onDeselect(NodeModel node) {
            }
        });
        mapController.addNodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                NodeModel node = event.getNode();
                if (selection.getSelected().equals(node)) {
                    StyleEditorPanel.this.setStyle(node);
                }
            }
        });
        mapController.addMapChangeListener((IMapChangeListener)new AMapChangeListenerAdapter(){

            public void mapChanged(MapChangeEvent event) {
                if (!"MAP_STYLES".equals(event.getProperty())) {
                    return;
                }
                IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                NodeModel node = selection.getSelected();
                StyleEditorPanel.this.setStyle(node);
            }
        });
        IMapViewManager mapViewManager = controller.getMapViewManager();
        mapViewManager.addMapViewChangeListener(new IMapViewChangeListener(){

            public void beforeViewChange(Component oldView, Component newView) {
            }

            public void afterViewCreated(Component mapView) {
            }

            public void afterViewClose(Component oldView) {
            }

            public void afterViewChange(Component oldView, Component newView) {
                Container panel = (Container)StyleEditorPanel.this.getComponent(0);
                for (int i = 0; i < panel.getComponentCount(); ++i) {
                    panel.getComponent(i).setEnabled(newView != null);
                }
            }
        });
    }

    private void enableShapeConfigurationProperties(boolean enabled, NodeStyleModel.Shape shape) {
        boolean enableConfigurationProperties = enabled && shape.hasConfiguration;
        this.mShapeHorizontalMargin.setEnabled(enableConfigurationProperties);
        this.mShapeVerticalMargin.setEnabled(enableConfigurationProperties);
        this.mUniformShape.setEnabled(enableConfigurationProperties);
    }

    private abstract class ChangeListener
    implements PropertyChangeListener {
        private final Collection<IPropertyControl> properties;
        private final BooleanProperty mSet;

        public ChangeListener(BooleanProperty mSet, IPropertyControl ... properties) {
            this.mSet = mSet;
            this.properties = Arrays.asList(properties);
        }

        abstract void applyValue(boolean var1, NodeModel var2, PropertyChangeEvent var3);

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean enabled;
            if (StyleEditorPanel.this.internalChange) {
                return;
            }
            if (evt.getSource().equals(this.mSet)) {
                enabled = this.mSet.getBooleanValue();
            } else {
                assert (this.properties.contains(evt.getSource()));
                enabled = true;
            }
            IMapSelection selection = Controller.getCurrentController().getSelection();
            Set nodes = selection.getSelection();
            if (enabled) {
                StyleEditorPanel.this.internalChange = true;
            }
            for (NodeModel node : nodes) {
                this.applyValue(enabled, node, evt);
            }
            if (enabled && !this.mSet.getBooleanValue()) {
                this.mSet.setValue(true);
            }
            StyleEditorPanel.this.internalChange = false;
            StyleEditorPanel.this.setStyle(selection.getSelected());
        }
    }

    private class StyleChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StyleEditorPanel.this.internalChange) {
                return;
            }
            BooleanProperty isSet = (BooleanProperty)evt.getSource();
            MLogicalStyleController styleController = (MLogicalStyleController)LogicalStyleController.getController();
            if (isSet.getBooleanValue()) {
                styleController.setStyle((IStyle)StyleEditorPanel.this.uiFactory.getStyles().getSelectedItem());
            } else {
                styleController.setStyle(null);
            }
        }
    }

    private class NodeFormatChangeListener
    extends ChangeListener {
        public NodeFormatChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setNodeFormat(node, enabled ? StyleEditorPanel.this.mNodeFormat.getSelectedPattern() : null);
        }
    }

    private class NodeNumberingChangeListener
    extends ChangeListener {
        public NodeNumberingChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setNodeNumbering(node, enabled ? Boolean.valueOf(StyleEditorPanel.this.mNodeNumbering.getBooleanValue()) : null);
        }
    }

    private class CloudShapeChangeListener
    extends ChangeListener {
        public CloudShapeChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MCloudController styleController = (MCloudController)Controller.getCurrentModeController().getExtension(CloudController.class);
            if (enabled) {
                styleController.setShape(node, CloudModel.Shape.valueOf((String)StyleEditorPanel.this.mCloudShape.getValue()));
            } else {
                styleController.setCloud(node, false);
            }
        }
    }

    private class CloudColorChangeListener
    extends ChangeListener {
        public CloudColorChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MCloudController styleController = (MCloudController)Controller.getCurrentModeController().getExtension(CloudController.class);
            if (enabled) {
                styleController.setColor(node, StyleEditorPanel.this.mCloudColor.getColorValue());
            } else {
                styleController.setCloud(node, false);
            }
        }
    }

    private class ChildDistanceChangeListener
    extends ChangeListener {
        public ChildDistanceChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MLocationController locationController = (MLocationController)Controller.getCurrentModeController().getExtension(LocationController.class);
            locationController.setMinimalDistanceBetweenChildren(node, (Quantity<LengthUnits>)(enabled ? StyleEditorPanel.this.mChildDistance.getQuantifiedValue() : LocationModel.DEFAULT_VGAP));
        }
    }

    private class MinNodeWidthChangeListener
    extends ChangeListener {
        public MinNodeWidthChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setMinNodeWidth(node, enabled ? StyleEditorPanel.this.mMinNodeWidth.getQuantifiedValue() : null);
        }
    }

    private class MaxNodeWidthChangeListener
    extends ChangeListener {
        public MaxNodeWidthChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setMaxNodeWidth(node, enabled ? StyleEditorPanel.this.mMaxNodeWidth.getQuantifiedValue() : null);
        }
    }

    private class EdgeWidthChangeListener
    extends ChangeListener {
        public EdgeWidthChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MEdgeController styleController = (MEdgeController)Controller.getCurrentModeController().getExtension(EdgeController.class);
            styleController.setWidth(node, enabled ? Integer.parseInt(StyleEditorPanel.this.mEdgeWidth.getValue()) : -1);
        }
    }

    private class TextAlignmentChangeListener
    extends ChangeListener {
        public TextAlignmentChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setTextAlign(node, enabled ? NodeStyleModel.TextAlign.valueOf((String)StyleEditorPanel.this.mNodeTextAlignment.getValue()) : null);
        }
    }

    private class EdgeStyleChangeListener
    extends ChangeListener {
        public EdgeStyleChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MEdgeController styleController = (MEdgeController)Controller.getCurrentModeController().getExtension(EdgeController.class);
            styleController.setStyle(node, enabled ? EdgeStyle.getStyle((String)StyleEditorPanel.this.mEdgeStyle.getValue()) : null);
        }
    }

    private class EdgeColorChangeListener
    extends ChangeListener {
        public EdgeColorChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MEdgeController edgeController = (MEdgeController)MEdgeController.getController();
            edgeController.setColor(node, enabled ? StyleEditorPanel.this.mEdgeColor.getColorValue() : null);
        }
    }

    private class FontNameChangeListener
    extends ChangeListener {
        public FontNameChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setFontFamily(node, enabled ? StyleEditorPanel.this.mNodeFontName.getValue() : null);
        }
    }

    private class FontSizeChangeListener
    extends ChangeListener {
        public FontSizeChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            try {
                styleController.setFontSize(node, enabled ? Integer.valueOf(StyleEditorPanel.this.mNodeFontSize.getValue()) : null);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class FontHyperlinkChangeListener
    extends ChangeListener {
        public FontHyperlinkChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MLinkController styleController = (MLinkController)Controller.getCurrentModeController().getExtension(LinkController.class);
            styleController.setFormatNodeAsHyperlink(node, enabled ? Boolean.valueOf(StyleEditorPanel.this.mNodeFontHyperlink.getBooleanValue()) : null);
        }
    }

    private class FontItalicChangeListener
    extends ChangeListener {
        public FontItalicChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setItalic(node, enabled ? Boolean.valueOf(StyleEditorPanel.this.mNodeFontItalic.getBooleanValue()) : null);
        }
    }

    private class FontBoldChangeListener
    extends ChangeListener {
        public FontBoldChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setBold(node, enabled ? Boolean.valueOf(StyleEditorPanel.this.mNodeFontBold.getBooleanValue()) : null);
        }
    }

    private class ColorChangeListener
    extends ChangeListener {
        public ColorChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setColor(node, enabled ? StyleEditorPanel.this.mNodeColor.getColorValue() : null);
        }
    }

    private class NodeShapeChangeListener
    extends ChangeListener {
        public NodeShapeChangeListener(BooleanProperty mSet, IPropertyControl ... mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            if (enabled) {
                styleController.setShapeConfiguration(node, ShapeConfigurationModel.NULL_SHAPE.withShape(NodeStyleModel.Shape.valueOf((String)StyleEditorPanel.this.mNodeShape.getValue())).withHorizontalMargin(StyleEditorPanel.this.mShapeHorizontalMargin.getQuantifiedValue()).withVerticalMargin(StyleEditorPanel.this.mShapeVerticalMargin.getQuantifiedValue()).withUniform(StyleEditorPanel.this.mUniformShape.getBooleanValue()));
            } else {
                styleController.setShapeConfiguration(node, ShapeConfigurationModel.NULL_SHAPE);
            }
            NodeStyleModel.Shape shape = styleController.getShape(node);
            StyleEditorPanel.this.enableShapeConfigurationProperties(enabled, shape);
        }
    }

    private class BgColorChangeListener
    extends ChangeListener {
        public BgColorChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setBackgroundColor(node, enabled ? StyleEditorPanel.this.mNodeBackgroundColor.getColorValue() : null);
        }
    }
}

