/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.ui.IMapViewManager;

public class EditNodeDialog
extends EditNodeBase {
    private JTextComponent textComponent;
    private final boolean enableSplit;
    private final KeyEvent firstEvent;
    private String title;
    private boolean isModal;

    public EditNodeDialog(NodeModel node, String text, KeyEvent firstEvent, EditNodeBase.IEditControl editControl, boolean enableSplit) {
        super(node, text, editControl);
        this.firstEvent = firstEvent;
        this.enableSplit = enableSplit;
    }

    public EditNodeDialog(NodeModel nodeModel, String text, KeyEvent firstEvent, EditNodeBase.IEditControl editControl, boolean enableSplit, JEditorPane textEditor) {
        this(nodeModel, text, firstEvent, editControl, enableSplit);
        this.textComponent = textEditor;
    }

    @Override
    public void show(RootPaneContainer frame) {
        if (this.title == null) {
            this.title = TextUtils.getText((String)"edit_long_node");
        }
        final LongNodeDialog dialog = new LongNodeDialog(frame, this.title, this.getBackground());
        this.redispatchKeyEvents(this.textComponent, this.firstEvent);
        if (this.firstEvent == null) {
            this.textComponent.setCaretPosition(this.getText().length());
        }
        dialog.getDialog().setModal(this.isModal);
        dialog.getDialog().pack();
        Controller.getCurrentModeController().getController().getMapViewManager().scrollNodeToVisible(this.node);
        if (ResourceController.getResourceController().getBooleanProperty("el__position_window_below_node")) {
            UITools.setDialogLocationUnder((JDialog)dialog.getDialog(), (NodeModel)this.getNode());
        } else {
            UITools.setDialogLocationRelativeTo((JDialog)dialog.getDialog(), (NodeModel)this.getNode());
        }
        ((EditNodeBase.EditDialog)dialog).show();
        dialog.getDialog().addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                dialog.dispose();
            }
        });
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void setModal(boolean isModal) {
        this.isModal = isModal;
    }

    private class LongNodeDialog
    extends EditNodeBase.EditDialog {
        public LongNodeDialog(RootPaneContainer frame, String title, Color background) {
            JScrollPane editorScrollPane;
            super(EditNodeDialog.this, title, frame);
            IMapViewManager viewController = Controller.getCurrentModeController().getController().getMapViewManager();
            if (EditNodeDialog.this.textComponent == null) {
                JTextArea textArea = new JTextArea(EditNodeDialog.this.getText());
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                EditNodeDialog.this.textComponent = textArea;
                editorScrollPane = new JScrollPane(EditNodeDialog.this.textComponent);
                SpellCheckerController spellCheckerController = SpellCheckerController.getController();
                spellCheckerController.enableAutoSpell(EditNodeDialog.this.textComponent, true);
                Font nodeFont = viewController.getFont(EditNodeDialog.this.getNode());
                EditNodeDialog.this.textComponent.setFont(nodeFont);
                Color nodeTextColor = viewController.getTextColor(EditNodeDialog.this.getNode());
                EditNodeDialog.this.textComponent.setForeground(nodeTextColor);
                EditNodeDialog.this.textComponent.setBackground(background);
                EditNodeDialog.this.textComponent.setCaretColor(nodeTextColor);
                editorScrollPane.setVerticalScrollBarPolicy(22);
                int preferredHeight = viewController.getComponent(EditNodeDialog.this.getNode()).getHeight();
                preferredHeight = Math.max(preferredHeight, Integer.parseInt(ResourceController.getResourceController().getProperty("el__min_default_window_height")));
                preferredHeight = Math.min(preferredHeight, Integer.parseInt(ResourceController.getResourceController().getProperty("el__max_default_window_height")));
                int preferredWidth = viewController.getComponent(EditNodeDialog.this.getNode()).getWidth();
                preferredWidth = Math.max(preferredWidth, Integer.parseInt(ResourceController.getResourceController().getProperty("el__min_default_window_width")));
                preferredWidth = Math.min(preferredWidth, Integer.parseInt(ResourceController.getResourceController().getProperty("el__max_default_window_width")));
                editorScrollPane.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
            } else {
                EditNodeDialog.this.textComponent.setText(EditNodeDialog.this.getText());
                JScrollPane ancestorScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, EditNodeDialog.this.textComponent);
                editorScrollPane = ancestorScrollPane != null ? ancestorScrollPane : new JScrollPane(EditNodeDialog.this.textComponent);
            }
            JPanel panel = new JPanel();
            JButton okButton = new JButton();
            JButton cancelButton = new JButton();
            JButton splitButton = new JButton();
            final JCheckBox enterConfirms = new JCheckBox("", ResourceController.getResourceController().getBooleanProperty("el__enter_confirms_by_default"));
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)okButton, (String)TextUtils.getRawText((String)"ok"));
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)cancelButton, (String)TextUtils.getRawText((String)"cancel"));
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)splitButton, (String)TextUtils.getRawText((String)"split"));
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)enterConfirms, (String)TextUtils.getRawText((String)"enter_confirms"));
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LongNodeDialog.this.submit();
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LongNodeDialog.this.cancel();
                }
            });
            splitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LongNodeDialog.this.split();
                }
            });
            enterConfirms.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditNodeDialog.this.textComponent.requestFocus();
                    ResourceController.getResourceController().setProperty("el__enter_confirms_by_default", Boolean.toString(enterConfirms.isSelected()));
                }
            });
            EditNodeDialog.this.textComponent.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 27: {
                            e.consume();
                            LongNodeDialog.this.confirmedCancel();
                            break;
                        }
                        case 10: {
                            e.consume();
                            if ((e.getModifiers() & 1) != 0 || enterConfirms.isSelected() == ((e.getModifiers() & 8) != 0)) {
                                this.insertString("\n");
                                break;
                            }
                            LongNodeDialog.this.submit();
                            break;
                        }
                        case 9: {
                            e.consume();
                            this.insertString("    ");
                        }
                    }
                }

                public void insertString(String text) {
                    try {
                        EditNodeDialog.this.textComponent.getDocument().insertString(EditNodeDialog.this.textComponent.getCaretPosition(), text, null);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            EditNodeDialog.this.textComponent.addMouseListener(new MouseListener(){

                private void conditionallyShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        Component component = e.getComponent();
                        JPopupMenu popupMenu = EditNodeDialog.this.createPopupMenu(component);
                        popupMenu.show(component, e.getX(), e.getY());
                        e.consume();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.conditionallyShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.conditionallyShowPopup(e);
                }
            });
            JPanel buttonPane = new JPanel();
            buttonPane.add(enterConfirms);
            buttonPane.add(okButton);
            buttonPane.add(cancelButton);
            if (EditNodeDialog.this.enableSplit) {
                buttonPane.add(splitButton);
            }
            buttonPane.setMaximumSize(new Dimension(1000, 20));
            if (ResourceController.getResourceController().getBooleanProperty("el__buttons_above")) {
                panel.add(buttonPane);
                panel.add(editorScrollPane);
            } else {
                panel.add(editorScrollPane);
                panel.add(buttonPane);
            }
            panel.setLayout(new BoxLayout(panel, 1));
            this.getDialog().setContentPane(panel);
        }

        @Override
        protected void cancel() {
            super.cancel();
            EditNodeDialog.this.getEditControl().cancel();
        }

        @Override
        public Component getMostRecentFocusOwner() {
            if (this.getDialog().isFocused()) {
                return this.getFocusOwner();
            }
            return EditNodeDialog.this.textComponent;
        }

        @Override
        protected boolean isChanged() {
            return !EditNodeDialog.this.getText().equals(EditNodeDialog.this.textComponent.getText());
        }

        @Override
        public void show() {
            EditNodeDialog.this.textComponent.requestFocus();
            super.show();
        }

        @Override
        protected void split() {
            super.split();
            EditNodeDialog.this.getEditControl().split(EditNodeDialog.this.textComponent.getText(), EditNodeDialog.this.textComponent.getCaretPosition());
        }

        @Override
        protected void submit() {
            super.submit();
            EditNodeDialog.this.getEditControl().ok(EditNodeDialog.this.textComponent.getText());
        }
    }
}

