/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.dpolivaev.mnemonicsetter.MnemonicSetter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ShowSelectionAsRectangleAction;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.ChildActionEntryRemover;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.features.attribute.ModelessAttributeController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.NextNodeAction;
import org.freeplane.features.filter.NextPresentationItemAction;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.help.HelpController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.FreeplaneActions;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.QuitAction;
import org.freeplane.features.mode.mindmapmode.LoadAcceleratorPresetsAction;
import org.freeplane.features.print.PrintController;
import org.freeplane.features.styles.LogicalStyleFilterController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.TextController;
import org.freeplane.features.time.TimeController;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.main.application.ApplicationLifecycleListener;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.ApplicationViewController;
import org.freeplane.main.application.CommandLineParser;
import org.freeplane.main.application.FreeplaneSplashModern;
import org.freeplane.main.application.FreeplaneStarter;
import org.freeplane.main.application.LastOpenedList;
import org.freeplane.main.application.MenuKeyProcessor;
import org.freeplane.main.application.UserPropertiesUpdater;
import org.freeplane.main.browsemode.BModeControllerFactory;
import org.freeplane.main.filemode.FModeControllerFactory;
import org.freeplane.main.mindmapmode.MModeControllerFactory;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.ViewLayoutTypeAction;
import org.freeplane.view.swing.map.mindmapmode.MMapViewController;

public class FreeplaneGUIStarter
implements FreeplaneStarter {
    private static String RESOURCE_BASE_DIRECTORY;
    private static String INSTALLATION_BASE_DIRECTORY;
    private final ApplicationResourceController applicationResourceController;
    private FreeplaneSplashModern splash = null;
    private boolean startupFinished = false;
    private ApplicationViewController viewController;
    private boolean dontLoadLastMaps;
    private final boolean firstRun;
    private static final String LOAD_LAST_MAPS = "load_last_maps";
    private static final String LOAD_LAST_MAP = "load_last_map";
    private final CommandLineParser.Options options;

    public static String getResourceBaseDir() {
        return RESOURCE_BASE_DIRECTORY;
    }

    public static String getInstallationBaseDir() {
        return INSTALLATION_BASE_DIRECTORY;
    }

    public static void showSysInfo() {
        StringBuilder info = new StringBuilder();
        info.append("freeplane_version = ");
        info.append(FreeplaneVersion.getVersion());
        String revision = FreeplaneVersion.getVersion().getRevision();
        info.append("; freeplane_xml_version = ");
        info.append("freeplane 1.5.9");
        if (!revision.equals("")) {
            info.append("\ngit revision = ");
            info.append(revision);
        }
        info.append("\njava_version = ");
        info.append(System.getProperty("java.version"));
        info.append("; os_name = ");
        info.append(System.getProperty("os.name"));
        info.append("; os_version = ");
        info.append(System.getProperty("os.version"));
        LogUtils.info((String)info.toString());
    }

    public FreeplaneGUIStarter(String[] args) {
        this.options = CommandLineParser.parse(args, true);
        File userPreferencesFile = ApplicationResourceController.getUserPreferencesFile();
        this.firstRun = !userPreferencesFile.exists();
        new UserPropertiesUpdater().importOldProperties();
        this.applicationResourceController = new ApplicationResourceController();
    }

    @Override
    public void setDontLoadLastMaps() {
        this.dontLoadLastMaps = true;
    }

    @Override
    public Controller createController() {
        try {
            Controller controller = new Controller((ResourceController)this.applicationResourceController);
            Controller.setCurrentController((Controller)controller);
            Compat.macAppChanges();
            controller.addAction((AFreeplaneAction)new QuitAction());
            this.applicationResourceController.init();
            LogUtils.createLogger();
            FreeplaneGUIStarter.showSysInfo();
            String lookandfeel = System.getProperty("lookandfeel", this.applicationResourceController.getProperty("lookandfeel"));
            boolean supportHidpi = Boolean.valueOf(System.getProperty("lookandfeel.scaleuifonts", this.applicationResourceController.getProperty("lookandfeel.scaleuifonts")));
            FrameController.setLookAndFeel((String)lookandfeel, (boolean)supportHidpi);
            JFrame frame = new JFrame("Freeplane");
            frame.setContentPane(new JPanel(){

                @Override
                protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                    return super.processKeyBinding(ks, e, condition, pressed) || MenuKeyProcessor.INSTANCE.processKeyBinding(ks, e, condition, pressed);
                }
            });
            frame.setName("mainFreeplaneFrame");
            MMapViewController mapViewController = new MMapViewController(controller);
            this.viewController = new ApplicationViewController(controller, (IMapViewManager)mapViewController, frame);
            this.splash = new FreeplaneSplashModern(frame);
            if (!System.getProperty("org.freeplane.nosplash", "false").equals("true")) {
                this.splash.setVisible(true);
            }
            mapViewController.addMapViewChangeListener(this.applicationResourceController.getLastOpenedList());
            FilterController.install();
            PrintController.install();
            FormatController.install((FormatController)new FormatController());
            ScannerController scannerController = new ScannerController();
            ScannerController.install((ScannerController)scannerController);
            scannerController.addParsersForStandardFormats();
            ModelessAttributeController.install();
            TextController.install();
            TimeController.install();
            LinkController.install();
            IconController.install();
            HelpController.install();
            controller.addAction((AFreeplaneAction)new NextNodeAction(MapController.Direction.FORWARD));
            controller.addAction((AFreeplaneAction)new NextNodeAction(MapController.Direction.BACK));
            controller.addAction((AFreeplaneAction)new NextNodeAction(MapController.Direction.FORWARD_N_FOLD));
            controller.addAction((AFreeplaneAction)new NextNodeAction(MapController.Direction.BACK_N_FOLD));
            controller.addAction((AFreeplaneAction)new NextPresentationItemAction());
            controller.addAction((AFreeplaneAction)new ShowSelectionAsRectangleAction());
            controller.addAction((AFreeplaneAction)new ViewLayoutTypeAction(MapViewLayout.OUTLINE));
            FilterController.getCurrentFilterController().getConditionFactory().addConditionController(70, (IElementaryConditionController)new LogicalStyleFilterController());
            MapController.install();
            NodeHistory.install((Controller)controller);
            return controller;
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createModeControllers(Controller controller) {
        MModeControllerFactory.createModeController();
        ModeController mindMapModeController = controller.getModeController("MindMap");
        LastOpenedList lastOpenedList = this.applicationResourceController.getLastOpenedList();
        mindMapModeController.getMapController().addMapChangeListener((IMapChangeListener)lastOpenedList);
        lastOpenedList.registerMenuContributor(mindMapModeController);
        mindMapModeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "filterConditions", FilterController.getController((Controller)controller).getMenuBuilder(), (EntryVisitor)new ChildActionEntryRemover((FreeplaneActions)controller));
        BModeControllerFactory.createModeController();
        FModeControllerFactory.createModeController();
    }

    @Override
    public void buildMenus(Controller controller, Set<String> plugins) {
        LoadAcceleratorPresetsAction.install(controller.getModeController("MindMap"));
        this.buildMenus(controller, plugins, "MindMap", "/xml/mindmapmodemenu.xml");
        this.buildMenus(controller, plugins, "Browse", "/xml/browsemodemenu.xml");
        this.buildMenus(controller, plugins, "File", "/xml/filemodemenu.xml");
        ResourceController.getResourceController().getAcceleratorManager().loadAcceleratorPresets();
    }

    private void buildMenus(Controller controller, Set<String> plugins, String mode, String xml) {
        ModeController modeController = controller.getModeController(mode);
        controller.selectModeForBuild(modeController);
        modeController.updateMenus(xml, plugins);
        FreeplaneMenuBar menuBar = modeController.getUserInputListenerFactory().getMenuBar();
        MnemonicSetter.INSTANCE.setComponentMnemonics(new Container[]{menuBar});
        controller.selectModeForBuild(null);
    }

    @Override
    public void createFrame(final String[] args) {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController("MindMap");
        controller.selectModeForBuild(modeController);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FreeplaneGUIStarter.this.viewController.init(Controller.getCurrentController());
                FreeplaneGUIStarter.this.splash.toBack();
                JFrame frame = (JFrame)FreeplaneGUIStarter.this.viewController.getMenuComponent();
                int extendedState = frame.getExtendedState();
                Container contentPane = frame.getContentPane();
                contentPane.setVisible(false);
                FreeplaneGUIStarter.this.splash.dispose();
                FreeplaneGUIStarter.this.splash = null;
                ToolTipManager.sharedInstance().setDismissDelay(12000);
                frame.setVisible(true);
                if (extendedState != frame.getExtendedState()) {
                    frame.setExtendedState(extendedState);
                }
                FreeplaneGUIStarter.this.loadMaps(CommandLineParser.parse(args, false).getFilesToOpenAsArray());
                this.focusCurrentView();
                contentPane.setVisible(true);
                frame.toFront();
                FreeplaneGUIStarter.this.startupFinished = true;
                System.setProperty("nonInteractive", Boolean.toString(FreeplaneGUIStarter.this.options.isNonInteractive()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                FreeplaneGUIStarter.this.fireStartupFinished();
                MenuUtils.executeMenuItems(FreeplaneGUIStarter.this.options.getMenuItemsToExecute());
            }

            private void focusCurrentView() {
                MapView currentMapView = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
                if (currentMapView != null) {
                    FreeplaneGUIStarter.this.viewController.focusTo(currentMapView);
                }
            }
        });
    }

    protected void fireStartupFinished() {
        for (ApplicationLifecycleListener listener : Controller.getCurrentController().getApplicationLifecycleListeners()) {
            listener.onStartupFinished();
        }
    }

    private void loadMaps(String[] args) {
        Controller controller = Controller.getCurrentController();
        boolean alwaysLoadLastMaps = ResourceController.getResourceController().getBooleanProperty("always_load_last_maps");
        if (alwaysLoadLastMaps && !this.dontLoadLastMaps) {
            this.loadLastMaps();
        }
        this.loadMaps(controller, args);
        if (controller.getMap() == null && !alwaysLoadLastMaps && !this.dontLoadLastMaps) {
            AddOnsController addonsController = AddOnsController.getController();
            addonsController.setAutoInstallEnabled(false);
            this.loadLastMaps();
            addonsController.setAutoInstallEnabled(true);
        }
        ModeController modeController = Controller.getCurrentModeController();
        if (this.firstRun && !this.dontLoadLastMaps) {
            String map = ResourceController.getResourceController().getProperty("whatsnew_map");
            ((MMapController)modeController.getMapController()).newDocumentationMap(map);
        }
        if (null != controller.getMap()) {
            return;
        }
        controller.selectMode("MindMap");
        MFileManager.getController(modeController).newMapFromDefaultTemplate();
    }

    private void loadLastMaps() {
        boolean loadLastMap = ResourceController.getResourceController().getBooleanProperty(LOAD_LAST_MAP);
        boolean loadLastMaps = ResourceController.getResourceController().getBooleanProperty(LOAD_LAST_MAPS);
        if (loadLastMaps) {
            this.viewController.openMapsOnStart();
        }
        if (loadLastMaps || loadLastMap) {
            this.applicationResourceController.getLastOpenedList().openLastMapOnStart();
        }
    }

    @Override
    public void loadMapsLater(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FreeplaneGUIStarter.this.startupFinished && EventQueue.isDispatchThread()) {
                    FreeplaneGUIStarter.this.loadMaps(Controller.getCurrentController(), args);
                    FreeplaneGUIStarter.this.toFront();
                    return;
                }
                EventQueue.invokeLater(this);
            }
        });
    }

    private void toFront() {
        Frame frame;
        int state;
        Component menuComponent = UITools.getMenuComponent();
        if (menuComponent instanceof Frame && ((state = (frame = (Frame)menuComponent).getExtendedState()) & 1) != 0) {
            frame.setExtendedState(state & 0xFFFFFFFE);
        }
        if (menuComponent instanceof Window) {
            Window window = (Window)menuComponent;
            if (!window.isVisible()) {
                window.setVisible(true);
            }
            window.toFront();
            window.requestFocus();
        }
    }

    private void loadMaps(Controller controller, String[] args) {
        controller.selectMode("MindMap");
        for (int i = 0; i < args.length; ++i) {
            String fileArgument = args[i];
            try {
                LinkController linkController = LinkController.getController();
                linkController.loadMap(fileArgument);
                continue;
            }
            catch (Exception ex) {
                System.err.println("File " + fileArgument + " not loaded");
            }
        }
    }

    @Override
    public void run(String[] args) {
        try {
            if (null == System.getProperty("org.freeplane.core.dir.lib", null)) {
                System.setProperty("org.freeplane.core.dir.lib", "/lib/");
            }
            Controller controller = this.createController();
            this.createModeControllers(controller);
            FilterController.getController((Controller)controller).loadDefaultConditions();
            Set<String> emptySet = Collections.emptySet();
            this.buildMenus(controller, emptySet);
            this.createFrame(args);
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
            JOptionPane.showMessageDialog(UITools.getMenuComponent(), "freeplane.main.Freeplane can't be started", "Startup problem", 0);
            System.exit(1);
        }
    }

    @Override
    public void stop() {
        try {
            if (EventQueue.isDispatchThread()) {
                Controller.getCurrentController().shutdown();
                return;
            }
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Controller.getCurrentController().shutdown();
                }
            });
        }
        catch (InterruptedException e) {
            LogUtils.severe((Throwable)e);
        }
        catch (InvocationTargetException e) {
            LogUtils.severe((Throwable)e);
        }
    }

    @Override
    public ResourceController getResourceController() {
        return this.applicationResourceController;
    }

    static {
        try {
            RESOURCE_BASE_DIRECTORY = new File(System.getProperty("org.freeplane.globalresourcedir", "resources")).getCanonicalPath();
            INSTALLATION_BASE_DIRECTORY = new File(System.getProperty("org.freeplane.basedirectory", RESOURCE_BASE_DIRECTORY + "/..")).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Compat.fixMousePointerForLinux();
    }
}

