/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.BlindIcon;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.DelayedRunner;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderExtension;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.CoreTextAccessor;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.DateRenderer;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.DetailTextAccessor;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.FlatNodeTableFilterModel;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.IconsHolder;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.IconsRenderer;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.NoteTextAccessor;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TableSorter;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextHolder;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextRenderer;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TimeWindowColumnSetting;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TimeWindowConfigurationStorage;

public class NodeList {
    private static String COLUMN_CREATED = "Created";
    private static String COLUMN_DATE = "Date";
    private static String COLUMN_ICONS = "Icons";
    private static String COLUMN_MODIFIED = "Modified";
    private static String COLUMN_NOTES = "Notes";
    private static String COLUMN_TEXT = "Text";
    private static String COLUMN_DETAILS = "Details";
    private static final int DATE_COLUMN = 0;
    protected static final int NODE_CREATED_COLUMN = 3;
    protected static final int NODE_ICON_COLUMN = 2;
    protected static final int NODE_MODIFIED_COLUMN = 4;
    protected static final int NODE_DETAILS_COLUMN = 5;
    protected static final int NODE_NOTES_COLUMN = 6;
    public static final int NODE_TEXT_COLUMN = 1;
    private static final String PLUGINS_TIME_LIST_XML_CREATED = "plugins/TimeList.xml_Created";
    private static final String PLUGINS_TIME_LIST_XML_DATE = "plugins/TimeList.xml_Date";
    private static final String PLUGINS_TIME_LIST_XML_ICONS = "plugins/TimeList.xml_Icons";
    private static final String PLUGINS_TIME_LIST_XML_MODIFIED = "plugins/TimeList.xml_Modified";
    private static final String PLUGINS_TIME_LIST_XML_NOTES = "plugins/TimeList.xml_Notes";
    private static final String PLUGINS_TIME_LIST_XML_DETAILS = "plugins/TimeList.xml_Details";
    private static final String PLUGINS_TIME_LIST_XML_TEXT = "plugins/TimeList.xml_Text";
    private static final String PLUGINS_TIME_MANAGEMENT_XML_CLOSE = "plugins/TimeManagement.xml_closeButton";
    private static final String PLUGINS_TIME_MANAGEMENT_XML_FIND = "plugins/TimeManagement.xml_Find";
    private static final String PLUGINS_TIME_MANAGEMENT_XML_REPLACE = "plugins/TimeManagement.xml_Replace";
    private static final String PLUGINS_TIME_MANAGEMENT_XML_WINDOW_TITLE = "plugins/TimeManagement.xml_WindowTitle";
    private static final String PLUGINS_TIME_MANAGEMENT_XML_WINDOW_TITLE_ALL_NODES = "plugins/TimeManagement.xml_WindowTitle_All_Nodes";
    private final String windowPreferenceStorageProperty;
    private DateRenderer dateRenderer;
    private JDialog dialog;
    private IconsRenderer iconsRenderer;
    private final JComboBox mFilterTextReplaceField;
    private final JComboBox mFilterTextSearchField;
    private FlatNodeTableFilterModel mFlatNodeTableFilterModel;
    private JLabel mTreeLabel;
    private TextRenderer textRenderer;
    private boolean showAllNodes = false;
    private TableSorter sorter;
    private JTable tableView;
    private DefaultTableModel tableModel;
    private final boolean searchInAllMaps;
    private final JCheckBox useRegexInReplace;
    private final JCheckBox useRegexInFind;
    private final JCheckBox matchCase;
    private final boolean modal;
    private final MapChangeListener mapChangeListener;
    private static HashSet<Object> changeableProperties = new HashSet<Serializable>(Arrays.asList("node_text", "icon", DetailTextModel.class, "note_text"));

    private static String replace(Pattern p, String input, String replacement) {
        String result = HtmlUtils.getReplaceResult((Pattern)p, (String)input, (String)replacement);
        return result;
    }

    public NodeList(boolean showAllNodes, boolean searchInAllMaps, String windowPreferenceStorageProperty) {
        this(false, showAllNodes, searchInAllMaps, windowPreferenceStorageProperty);
    }

    public NodeList(boolean modal, boolean showAllNodes, boolean searchInAllMaps, String windowPreferenceStorageProperty) {
        this.modal = modal;
        this.showAllNodes = showAllNodes;
        this.searchInAllMaps = searchInAllMaps;
        this.mFilterTextSearchField = new JComboBoxWithBorder();
        this.mFilterTextSearchField.setEditable(true);
        FilterTextDocumentListener listener = new FilterTextDocumentListener();
        this.mFilterTextSearchField.addActionListener(listener);
        JTextComponent editorComponent = (JTextComponent)this.mFilterTextSearchField.getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener(listener);
        this.mFilterTextSearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40) {
                    NodeList.this.mFilterTextReplaceField.requestFocusInWindow();
                }
            }
        });
        this.mFilterTextReplaceField = new JComboBoxWithBorder();
        this.mFilterTextReplaceField.setEditable(true);
        this.mFilterTextReplaceField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40) {
                    NodeList.this.tableView.requestFocusInWindow();
                } else if (pEvent.getKeyCode() == 38) {
                    NodeList.this.mFilterTextSearchField.requestFocusInWindow();
                }
            }
        });
        this.useRegexInReplace = new JCheckBox();
        this.useRegexInFind = new JCheckBox();
        this.useRegexInFind.addActionListener(listener);
        this.matchCase = new JCheckBox();
        this.matchCase.addActionListener(listener);
        this.mapChangeListener = new MapChangeListener();
        this.windowPreferenceStorageProperty = windowPreferenceStorageProperty;
    }

    private void disposeDialog() {
        if (this.dialog == null || !this.dialog.isVisible()) {
            return;
        }
        TimeWindowConfigurationStorage storage = new TimeWindowConfigurationStorage();
        for (int i = 0; i < this.tableView.getColumnCount(); ++i) {
            TimeWindowColumnSetting setting = new TimeWindowColumnSetting();
            setting.setColumnWidth(this.tableView.getColumnModel().getColumn(i).getWidth());
            setting.setColumnSorting(this.sorter.getSortingStatus(i));
            storage.addTimeWindowColumnSetting(setting);
        }
        storage.storeDialogPositions(this.dialog, this.windowPreferenceStorageProperty);
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        mapController.removeMapChangeListener((IMapChangeListener)this.mapChangeListener);
        mapController.removeNodeChangeListener((INodeChangeListener)this.mapChangeListener);
        Controller.getCurrentController().getMapViewManager().removeMapSelectionListener((IMapSelectionListener)this.mapChangeListener);
    }

    protected void exportSelectedRowsAndClose() {
        int[] selectedRows = this.tableView.getSelectedRows();
        ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>();
        for (int i = 0; i < selectedRows.length; ++i) {
            int row = selectedRows[i];
            selectedNodes.add(this.getMindMapNode(row));
        }
        ModeController mindMapController = Controller.getCurrentModeController();
        MFileManager.getController(mindMapController).newMapFromDefaultTemplate();
        MapModel newMap = Controller.getCurrentController().getMap();
        for (NodeModel node : selectedNodes) {
            NodeModel copy = ClipboardController.getController().duplicate(node, false);
            if (copy == null) continue;
            mindMapController.getMapController().insertNodeIntoWithoutUndo(copy, newMap.getRootNode());
        }
        this.disposeDialog();
    }

    private NodeModel getMindMapNode(int focussedRow) {
        NodeModel selectedNode = ((TextHolder)this.tableView.getModel().getValueAt(focussedRow, 1)).getNode();
        return selectedNode;
    }

    private void replace(HolderAccessor holderAccessor, boolean selectedOnly) {
        Pattern p;
        String searchString = (String)this.mFilterTextSearchField.getSelectedItem();
        if (searchString == null) {
            return;
        }
        String replaceString = (String)this.mFilterTextReplaceField.getSelectedItem();
        try {
            p = Pattern.compile(this.useRegexInFind.isSelected() ? searchString : Pattern.quote(searchString), this.matchCase.isSelected() ? 0 : 66);
        }
        catch (PatternSyntaxException e) {
            UITools.errorMessage((Object)TextUtils.format((String)"wrong_regexp", (Object[])new Object[]{searchString, e.getMessage()}));
            return;
        }
        String replacement = replaceString == null ? "" : replaceString;
        int length = holderAccessor.getLength();
        for (int i = 0; i < length; ++i) {
            TextHolder[] textHolders;
            if (selectedOnly && !this.tableView.isRowSelected(i)) continue;
            for (TextHolder textHolder : textHolders = holderAccessor.getNodeHoldersAt(i)) {
                String replaceResult;
                String text = textHolder.getText();
                String literalReplacement = this.useRegexInReplace.isSelected() ? replacement : Matcher.quoteReplacement(replacement);
                try {
                    replaceResult = HtmlUtils.isHtmlNode((String)text) ? NodeList.replace(p, text, literalReplacement) : p.matcher(text).replaceAll(literalReplacement);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    UITools.errorMessage((Object)TextUtils.format((String)"wrong_regexp", (Object[])new Object[]{replacement, message != null ? message : e.getClass().getSimpleName()}));
                    return;
                }
                if (StringUtils.equals((String)text, (String)replaceResult)) continue;
                holderAccessor.changeString(textHolder, replaceResult);
            }
        }
        this.mFlatNodeTableFilterModel.resetFilter();
        this.mFilterTextSearchField.insertItemAt(this.mFilterTextSearchField.getSelectedItem(), 0);
        this.mFilterTextReplaceField.insertItemAt(this.mFilterTextReplaceField.getSelectedItem(), 0);
        this.mFilterTextSearchField.setSelectedItem("");
    }

    private void selectNodes(int focussedRow, int[] selectedRows) {
        if (focussedRow >= 0) {
            NodeModel focussedNode = this.getMindMapNode(focussedRow);
            MapModel map = focussedNode.getMap();
            ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>();
            for (int row : selectedRows) {
                NodeModel node = this.getMindMapNode(row);
                if (!node.getMap().equals(map)) continue;
                selectedNodes.add(node);
            }
            this.selectMap(map);
            Controller.getCurrentModeController().getMapController().selectMultipleNodes(focussedNode, selectedNodes);
        }
    }

    private void selectMap(MapModel map) {
        if (map.equals(Controller.getCurrentController().getMap())) {
            return;
        }
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        Map maps = mapViewManager.getMaps("MindMap");
        for (Map.Entry entry : maps.entrySet()) {
            if (!map.equals(entry.getValue())) continue;
            mapViewManager.tryToChangeToMapView((String)entry.getKey());
        }
    }

    private void selectSelectedRows() {
        this.selectNodes(this.tableView.getSelectedRow(), this.tableView.getSelectedRows());
    }

    public void startup() {
        TimeWindowConfigurationStorage result;
        if (this.dialog != null) {
            this.dialog.toFront();
            return;
        }
        COLUMN_MODIFIED = TextUtils.getText((String)PLUGINS_TIME_LIST_XML_MODIFIED);
        COLUMN_CREATED = TextUtils.getText((String)PLUGINS_TIME_LIST_XML_CREATED);
        COLUMN_ICONS = TextUtils.getText((String)PLUGINS_TIME_LIST_XML_ICONS);
        COLUMN_TEXT = TextUtils.getText((String)PLUGINS_TIME_LIST_XML_TEXT);
        COLUMN_DETAILS = TextUtils.getText((String)PLUGINS_TIME_LIST_XML_DETAILS);
        COLUMN_DATE = TextUtils.getText((String)PLUGINS_TIME_LIST_XML_DATE);
        COLUMN_NOTES = TextUtils.getText((String)PLUGINS_TIME_LIST_XML_NOTES);
        this.dialog = new JDialog(UITools.getCurrentFrame(), this.modal);
        String windowTitle = this.showAllNodes ? PLUGINS_TIME_MANAGEMENT_XML_WINDOW_TITLE_ALL_NODES : PLUGINS_TIME_MANAGEMENT_XML_WINDOW_TITLE;
        this.dialog.setTitle(TextUtils.getText((String)windowTitle));
        this.dialog.setDefaultCloseOperation(0);
        WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                NodeList.this.mFilterTextSearchField.getEditor().selectAll();
            }

            @Override
            public void windowClosing(WindowEvent event) {
                NodeList.this.disposeDialog();
            }
        };
        this.dialog.addWindowListener(windowListener);
        this.dialog.addWindowFocusListener(windowListener);
        UITools.addEscapeActionToDialog((JDialog)this.dialog, (Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.disposeDialog();
            }
        });
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.gridx = 0;
        layoutConstraints.gridy = 0;
        layoutConstraints.gridwidth = 1;
        layoutConstraints.gridheight = 1;
        layoutConstraints.weightx = 0.0;
        layoutConstraints.weighty = 0.0;
        layoutConstraints.anchor = 17;
        layoutConstraints.fill = 2;
        contentPane.add((Component)new JLabel(TextUtils.getText((String)PLUGINS_TIME_MANAGEMENT_XML_FIND)), layoutConstraints);
        layoutConstraints.gridwidth = 1;
        ++layoutConstraints.gridx;
        contentPane.add(Box.createHorizontalStrut(40), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)new JLabel(TextUtils.getText((String)"filter_match_case")), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)this.matchCase, layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add(Box.createHorizontalStrut(40), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)new JLabel(TextUtils.getText((String)"regular_expressions")), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)this.useRegexInFind, layoutConstraints);
        layoutConstraints.gridx = 0;
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        ++layoutConstraints.gridy;
        contentPane.add((Component)this.mFilterTextSearchField, layoutConstraints);
        ++layoutConstraints.gridy;
        layoutConstraints.weightx = 0.0;
        layoutConstraints.gridwidth = 1;
        contentPane.add((Component)new JLabel(TextUtils.getText((String)PLUGINS_TIME_MANAGEMENT_XML_REPLACE)), layoutConstraints);
        layoutConstraints.gridx = 5;
        contentPane.add((Component)new JLabel(TextUtils.getText((String)"regular_expressions")), layoutConstraints);
        ++layoutConstraints.gridx;
        contentPane.add((Component)this.useRegexInReplace, layoutConstraints);
        layoutConstraints.gridx = 0;
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        ++layoutConstraints.gridy;
        contentPane.add((Component)this.mFilterTextReplaceField, layoutConstraints);
        this.dateRenderer = new DateRenderer();
        this.textRenderer = new TextRenderer();
        this.iconsRenderer = new IconsRenderer();
        this.tableView = new FlatNodeTable();
        this.tableView.addKeyListener(new FlatNodeTableKeyListener());
        this.tableView.addMouseListener(new FlatNodeTableMouseAdapter());
        this.tableView.getTableHeader().setReorderingAllowed(false);
        this.tableModel = this.updateModel();
        this.mFlatNodeTableFilterModel = new FlatNodeTableFilterModel(this.tableModel, new int[]{1, 5, 6});
        this.sorter = new TableSorter(this.mFlatNodeTableFilterModel);
        this.tableView.setModel(this.sorter);
        this.sorter.setTableHeader(this.tableView.getTableHeader());
        this.sorter.setColumnComparator(Date.class, TableSorter.COMPARABLE_COMPARATOR);
        this.sorter.setColumnComparator(NodeModel.class, TableSorter.LEXICAL_COMPARATOR);
        this.sorter.setColumnComparator(IconsHolder.class, TableSorter.COMPARABLE_COMPARATOR);
        this.sorter.setSortingStatus(0, 1);
        JScrollPane pane = new JScrollPane(this.tableView);
        UITools.setScrollbarIncrement((JScrollPane)pane);
        ++layoutConstraints.gridy;
        GridBagConstraints tableConstraints = (GridBagConstraints)layoutConstraints.clone();
        tableConstraints.weightx = 1.0;
        tableConstraints.weighty = 10.0;
        tableConstraints.fill = 1;
        contentPane.add((Component)pane, tableConstraints);
        this.mTreeLabel = new JLabel();
        ++layoutConstraints.gridy;
        GridBagConstraints treeConstraints = (GridBagConstraints)layoutConstraints.clone();
        treeConstraints.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.mTreeLabel){

            @Override
            public boolean isValidateRoot() {
                return false;
            }
        };
        contentPane.add((Component)scrollPane, treeConstraints);
        final AbstractAction exportAction = new AbstractAction(TextUtils.getText((String)"plugins/TimeManagement.xml_Export")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.exportSelectedRowsAndClose();
            }
        };
        JButton exportButton = new JButton(exportAction);
        AbstractAction replaceAllAction = new AbstractAction(TextUtils.getText((String)"plugins/TimeManagement.xml_Replace_All")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.replace(new HolderAccessor(), false);
            }
        };
        JButton replaceAllButton = new JButton(replaceAllAction);
        final AbstractAction replaceSelectedAction = new AbstractAction(TextUtils.getText((String)"plugins/TimeManagement.xml_Replace_Selected")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.replace(new HolderAccessor(), true);
            }
        };
        JButton replaceSelectedButton = new JButton(replaceSelectedAction);
        final AbstractAction gotoAction = new AbstractAction(TextUtils.getText((String)"plugins/TimeManagement.xml_Goto")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.selectSelectedRows();
            }
        };
        JButton gotoButton = new JButton(gotoAction);
        AbstractAction disposeAction = new AbstractAction(TextUtils.getText((String)PLUGINS_TIME_MANAGEMENT_XML_CLOSE)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeList.this.disposeDialog();
            }
        };
        JButton cancelButton = new JButton(disposeAction);
        gotoAction.setEnabled(false);
        exportAction.setEnabled(false);
        replaceSelectedAction.setEnabled(false);
        Box bar = Box.createHorizontalBox();
        bar.add(Box.createHorizontalGlue());
        bar.add(cancelButton);
        bar.add(exportButton);
        bar.add(replaceAllButton);
        bar.add(replaceSelectedButton);
        bar.add(gotoButton);
        bar.add(Box.createHorizontalGlue());
        ++layoutConstraints.gridy;
        contentPane.add((Component)bar, layoutConstraints);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(TextUtils.getText((String)"plugins/TimeManagement.xml_menu_actions"));
        AbstractAction[] actionList = new AbstractAction[]{gotoAction, replaceSelectedAction, replaceAllAction, exportAction, disposeAction};
        for (int i = 0; i < actionList.length; ++i) {
            AbstractAction action = actionList[i];
            JMenuItem item = menu.add(action);
            item.setIcon((Icon)new BlindIcon(16));
        }
        menuBar.add(menu);
        this.dialog.setJMenuBar(menuBar);
        ListSelectionModel rowSM = this.tableView.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                boolean enable = !lsm.isSelectionEmpty();
                replaceSelectedAction.setEnabled(enable);
                gotoAction.setEnabled(enable);
                exportAction.setEnabled(enable);
            }
        });
        rowSM.addListSelectionListener(new ListSelectionListener(){

            String getNodeText(NodeModel node) {
                String nodeText = TextController.getController().getShortPlainText(node);
                if (node.isRoot()) {
                    return nodeText;
                }
                return this.getNodeText(node.getParentNode()) + " -> " + nodeText;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    NodeList.this.mTreeLabel.setText("");
                    return;
                }
                int selectedRow = lsm.getLeadSelectionIndex();
                NodeModel mindMapNode = NodeList.this.getMindMapNode(selectedRow);
                NodeList.this.mTreeLabel.setText(this.getNodeText(mindMapNode));
            }
        });
        String marshalled = ResourceController.getResourceController().getProperty(this.windowPreferenceStorageProperty);
        TimeWindowConfigurationStorage storage = result = TimeWindowConfigurationStorage.decorateDialog(marshalled, this.dialog);
        if (storage != null) {
            this.tableView.setAutoResizeMode(0);
            int column = 0;
            for (TimeWindowColumnSetting setting : storage.getListTimeWindowColumnSettingList()) {
                this.tableView.getColumnModel().getColumn(column).setPreferredWidth(setting.getColumnWidth());
                this.sorter.setSortingStatus(column, setting.getColumnSorting());
                ++column;
            }
        }
        this.mFlatNodeTableFilterModel.setFilter((String)this.mFilterTextSearchField.getSelectedItem(), this.matchCase.isSelected(), this.useRegexInFind.isSelected());
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        mapController.addMapChangeListener((IMapChangeListener)this.mapChangeListener);
        mapController.addNodeChangeListener((INodeChangeListener)this.mapChangeListener);
        Controller.getCurrentController().getMapViewManager().addMapSelectionListener((IMapSelectionListener)this.mapChangeListener);
        this.dialog.setVisible(true);
    }

    private DefaultTableModel updateModel() {
        DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int arg0) {
                switch (arg0) {
                    case 0: 
                    case 3: 
                    case 4: {
                        return Date.class;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        return TextHolder.class;
                    }
                    case 2: {
                        return IconsHolder.class;
                    }
                }
                return Object.class;
            }
        };
        model.addColumn(COLUMN_DATE);
        model.addColumn(COLUMN_TEXT);
        model.addColumn(COLUMN_ICONS);
        model.addColumn(COLUMN_CREATED);
        model.addColumn(COLUMN_MODIFIED);
        model.addColumn(COLUMN_DETAILS);
        model.addColumn(COLUMN_NOTES);
        if (!this.searchInAllMaps) {
            NodeModel node = Controller.getCurrentController().getMap().getRootNode();
            this.updateModel(model, node);
        } else {
            Map maps = Controller.getCurrentController().getMapViewManager().getMaps("MindMap");
            for (MapModel map : maps.values()) {
                NodeModel node = map.getRootNode();
                this.updateModel(model, node);
            }
        }
        return model;
    }

    private void updateModel(DefaultTableModel model, NodeModel node) {
        ReminderExtension hook = ReminderExtension.getExtension(node);
        Date date = null;
        if (hook != null) {
            date = new Date(hook.getRemindUserAt());
        }
        if (this.showAllNodes && node.hasVisibleContent() || hook != null) {
            model.addRow(new Object[]{date, new TextHolder(new CoreTextAccessor(node)), new IconsHolder(node), node.getHistoryInformation().getCreatedAt(), node.getHistoryInformation().getLastModifiedAt(), new TextHolder(new DetailTextAccessor(node)), new TextHolder(new NoteTextAccessor(node))});
        }
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            this.updateModel(model, child);
        }
    }

    private boolean hasTableFieldValueChanged(Object property) {
        return changeableProperties.contains(property);
    }

    private class HolderAccessor {
        private HolderAccessor() {
        }

        public void changeString(TextHolder textHolder, String newText) {
            textHolder.setText(newText);
        }

        public int getLength() {
            return NodeList.this.mFlatNodeTableFilterModel.getRowCount();
        }

        public TextHolder[] getNodeHoldersAt(int row) {
            return new TextHolder[]{(TextHolder)NodeList.this.sorter.getValueAt(row, 1), (TextHolder)NodeList.this.sorter.getValueAt(row, 5), (TextHolder)NodeList.this.sorter.getValueAt(row, 6)};
        }
    }

    private final class FlatNodeTableMouseAdapter
    extends MouseAdapter {
        private FlatNodeTableMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point p = e.getPoint();
                int row = NodeList.this.tableView.rowAtPoint(p);
                NodeList.this.selectNodes(row, new int[]{row});
                if (!e.isControlDown() && !e.isMetaDown()) {
                    NodeList.this.disposeDialog();
                }
            }
        }
    }

    private final class FlatNodeTableKeyListener
    implements KeyListener {
        private FlatNodeTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
            if (arg0.getKeyCode() == 27) {
                NodeList.this.disposeDialog();
            }
            if (arg0.getKeyCode() == 10) {
                NodeList.this.selectSelectedRows();
                NodeList.this.disposeDialog();
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }

    private final class FlatNodeTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        private FlatNodeTable() {
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            Object object = this.getModel().getValueAt(row, column);
            if (object instanceof Date) {
                return NodeList.this.dateRenderer;
            }
            if (object instanceof TextHolder) {
                return NodeList.this.textRenderer;
            }
            if (object instanceof IconsHolder) {
                return NodeList.this.iconsRenderer;
            }
            return super.getCellRenderer(row, column);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int vColIndex) {
            return false;
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                EventListener[] el = super.getListeners(KeyListener.class);
                if (e.getID() != 402) {
                    return;
                }
                for (int i = 0; i < el.length; ++i) {
                    KeyListener kl = (KeyListener)el[i];
                    kl.keyReleased(e);
                }
                return;
            }
            super.processKeyEvent(e);
        }
    }

    private final class FilterTextDocumentListener
    implements DocumentListener,
    ActionListener {
        private Timer mTypeDelayTimer = null;
        private String selectedItem = "";
        private boolean shouldMatchCase = false;
        private boolean shouldUseRegex = false;

        private FilterTextDocumentListener() {
        }

        private synchronized void delayedChange() {
            this.stopTimer();
            this.mTypeDelayTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterTextDocumentListener.this.change();
                }
            });
            this.mTypeDelayTimer.start();
        }

        public void stopTimer() {
            if (this.mTypeDelayTimer != null) {
                this.mTypeDelayTimer.stop();
                this.mTypeDelayTimer = null;
            }
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.delayedChange();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.delayedChange();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.delayedChange();
        }

        private synchronized void change() {
            this.stopTimer();
            String selectedItem = (String)NodeList.this.mFilterTextSearchField.getEditor().getItem();
            boolean shouldMatchCase = NodeList.this.matchCase.isSelected();
            boolean shouldUseRegex = NodeList.this.useRegexInFind.isSelected();
            if (!this.selectedItem.equals(selectedItem) || this.shouldMatchCase != shouldMatchCase || this.shouldUseRegex != shouldUseRegex) {
                this.selectedItem = selectedItem;
                this.shouldMatchCase = shouldMatchCase;
                this.shouldUseRegex = shouldUseRegex;
                NodeList.this.mFlatNodeTableFilterModel.setFilter(selectedItem, shouldMatchCase, shouldUseRegex);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.change();
        }
    }

    private final class MapChangeListener
    implements IMapChangeListener,
    INodeChangeListener,
    IMapSelectionListener {
        private final DelayedRunner runner;

        public MapChangeListener() {
            this.runner = new DelayedRunner(new Runnable(){

                @Override
                public void run() {
                    NodeList.this.tableModel.fireTableDataChanged();
                }
            });
        }

        public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
            NodeList.this.disposeDialog();
        }

        public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
            NodeList.this.disposeDialog();
        }

        public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
            NodeList.this.disposeDialog();
        }

        public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
            NodeList.this.disposeDialog();
        }

        public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
            NodeList.this.disposeDialog();
        }

        public void mapChanged(MapChangeEvent event) {
            NodeList.this.disposeDialog();
        }

        public void nodeChanged(NodeChangeEvent event) {
            if (NodeList.this.hasTableFieldValueChanged(event.getProperty())) {
                this.runner.runLater();
            }
        }

        public void afterMapChange(MapModel oldMap, MapModel newMap) {
        }

        public void beforeMapChange(MapModel oldMap, MapModel newMap) {
            NodeList.this.disposeDialog();
        }
    }
}

