/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingPermissions;

public class ExecuteScriptAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final File scriptFile;
    private final ExecutionMode mode;
    private final IScript script;

    public ExecuteScriptAction(String scriptName, String menuItemName, String scriptFile, ExecutionMode mode, ScriptingPermissions permissions) {
        super(ExecuteScriptAction.makeMenuItemKey(scriptName, mode), menuItemName, null);
        this.scriptFile = new File(scriptFile);
        this.mode = mode;
        this.script = ScriptingEngine.createScriptForFile(this.scriptFile, permissions);
    }

    public static String makeMenuItemKey(String scriptName, ExecutionMode mode) {
        return scriptName + "_" + mode.toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        Controller.getCurrentController().getViewController().setWaitingCursor(true);
        try {
            ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
            IMapSelection selection = Controller.getCurrentController().getSelection();
            if (this.mode == ExecutionMode.ON_SINGLE_NODE) {
                nodes.add(selection.getSelected());
            } else {
                nodes.addAll(selection.getSelection());
            }
            MModeController modeController = (MModeController)Controller.getCurrentModeController();
            modeController.startTransaction();
            for (NodeModel node : nodes) {
                try {
                    if (this.mode == ExecutionMode.ON_SELECTED_NODE_RECURSIVELY) {
                        this.executeScriptRecursive(node);
                        continue;
                    }
                    this.script.execute(node);
                }
                catch (ExecuteScriptException ex) {
                    String cause;
                    if (ex.getCause() != null) {
                        if (ex.getCause().getCause() != null) {
                            LogUtils.warn((String)"ExecuteScriptAction failed:", (Throwable)ex.getCause().getCause());
                            cause = ex.getCause().getCause().toString();
                        } else {
                            LogUtils.warn((String)"ExecuteScriptAction failed:", (Throwable)ex.getCause());
                            cause = ex.getCause().toString();
                        }
                    } else {
                        LogUtils.warn((String)"ExecuteScriptAction failed:", (Throwable)ex);
                        cause = ex.toString();
                    }
                    LogUtils.warn((String)("error executing script " + this.scriptFile + " - giving up\n" + cause));
                    modeController.delayedRollback();
                    ScriptingEngine.showScriptExceptionErrorMessage(ex);
                    Controller.getCurrentController().getViewController().setWaitingCursor(false);
                    return;
                }
            }
            modeController.delayedCommit();
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    private void executeScriptRecursive(NodeModel node) {
        NodeModel[] children;
        ModeController modeController = Controller.getCurrentModeController();
        for (NodeModel child : children = modeController.getMapController().childrenUnfolded(node).toArray(new NodeModel[0])) {
            this.executeScriptRecursive(child);
        }
        this.script.execute(node);
    }

    public ExecutionMode getExecutionMode() {
        return this.mode;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public String toString() {
        return "ExecuteScriptAction(" + this.scriptFile + ", " + (Object)((Object)this.mode) + ")";
    }

    public static enum ExecutionMode {
        ON_SINGLE_NODE,
        ON_SELECTED_NODE,
        ON_SELECTED_NODE_RECURSIVELY;

    }
}

