/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.FilenameUtils;
import org.freeplane.core.util.FileUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.script.CompileTimeStrategy;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptClassLoader;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptSecurity;
import org.freeplane.plugin.script.ScriptingConfiguration;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.ScriptingSecurityManager;
import org.freeplane.plugin.script.proxy.ProxyFactory;

public class GenericScript
implements IScript {
    private ScriptSource scriptSource;
    private ScriptingPermissions specificPermissions;
    private CompiledScript compiledScript;
    private Throwable errorsInScript;
    private IFreeplaneScriptErrorHandler errorHandler;
    private PrintStream outStream;
    private ScriptContext scriptContext;
    private ScriptEngine engine;
    private boolean compilationEnabled = true;
    private CompileTimeStrategy compileTimeStrategy;
    private ScriptClassLoader scriptClassLoader;

    private void init(ScriptSource scriptSource, ScriptingPermissions permissions) {
        this.scriptSource = scriptSource;
        this.specificPermissions = permissions;
        this.engine = null;
        this.compiledScript = null;
        this.errorsInScript = null;
        this.errorHandler = ScriptResources.IGNORING_SCRIPT_ERROR_HANDLER;
        this.outStream = System.out;
        this.scriptContext = null;
        this.scriptClassLoader = ScriptClassLoader.createClassLoader();
    }

    private void init(String script, ScriptingPermissions permissions) {
        this.init(new ScriptSource(script), permissions);
        this.compileTimeStrategy = new CompileTimeStrategy(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericScript(String script, String scriptEngineName, ScriptingPermissions permissions) {
        this.init(script, permissions);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.scriptClassLoader);
            ScriptEngineManager scriptEngineManager = GenericScript.createScriptEngineManager(this.scriptClassLoader);
            this.engine = GenericScript.checkNotNull(scriptEngineManager.getEngineByName(scriptEngineName), "name", scriptEngineName);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericScript(File scriptFile, ScriptingPermissions permissions) {
        this.init(new ScriptSource(scriptFile), permissions);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.scriptClassLoader);
            ScriptEngineManager scriptEngineManager = GenericScript.createScriptEngineManager(this.scriptClassLoader);
            String extension = FilenameUtils.getExtension((String)scriptFile.getName());
            this.engine = GenericScript.checkNotNull(scriptEngineManager.getEngineByExtension(extension), "extension", extension);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.compilationEnabled = !this.disableScriptCompilation(scriptFile);
        this.compileTimeStrategy = new CompileTimeStrategy(scriptFile);
    }

    private static String slurpFile(File scriptFile) {
        try {
            return FileUtils.slurpFile((File)scriptFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IScript setErrorHandler(IFreeplaneScriptErrorHandler pErrorHandler) {
        this.errorHandler = pErrorHandler;
        return this;
    }

    @Override
    public IScript setOutStream(PrintStream outStream) {
        this.outStream = outStream;
        return this;
    }

    @Override
    public IScript setScriptContext(ScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        return this;
    }

    @Override
    public Object getScript() {
        return this.scriptSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(NodeModel node) {
        try {
            if (this.errorsInScript != null && this.compileTimeStrategy.canUseOldCompiledScript()) {
                throw new ExecuteScriptException(this.errorsInScript.getMessage(), this.errorsInScript);
            }
            PrintStream oldOut = System.out;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                this.scriptClassLoader.setSecurityManager(this.createScriptingSecurityManager());
                Thread.currentThread().setContextClassLoader(this.scriptClassLoader);
                SimpleScriptContext context = this.createScriptContext(node);
                if (this.compilationEnabled && this.engine instanceof Compilable) {
                    this.compileAndCache((Compilable)((Object)this.engine));
                    System.setOut(this.outStream);
                    Object object = this.compiledScript.eval(context);
                    return object;
                }
                System.setOut(this.outStream);
                Object object = this.engine.eval(this.scriptSource.getScript(), (javax.script.ScriptContext)context);
                return object;
            }
            finally {
                System.setOut(oldOut);
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        catch (ScriptException e) {
            this.handleScriptRuntimeException(e);
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            if (Controller.getCurrentController().getSelection() == null) throw new ExecuteScriptException(e.getMessage(), e);
            if (!node.hasVisibleContent()) throw new ExecuteScriptException(e.getMessage(), e);
            Controller.getCurrentModeController().getMapController().select(node);
            throw new ExecuteScriptException(e.getMessage(), e);
        }
    }

    private ScriptingSecurityManager createScriptingSecurityManager() {
        return new ScriptSecurity(this.scriptSource, this.specificPermissions, this.outStream).getScriptingSecurityManager();
    }

    private boolean disableScriptCompilation(File scriptFile) {
        return FilenameUtils.isExtension((String)scriptFile.getName(), (String[])ScriptResources.SCRIPT_COMPILATION_DISABLED_EXTENSIONS);
    }

    private SimpleScriptContext createScriptContext(NodeModel node) {
        SimpleScriptContext context = new SimpleScriptContext();
        OutputStreamWriter outWriter = new OutputStreamWriter(this.outStream);
        context.setWriter(outWriter);
        context.setErrorWriter(outWriter);
        context.setBindings(this.createBinding(node), 100);
        return context;
    }

    private Bindings createBinding(NodeModel node) {
        Bindings binding = this.engine.createBindings();
        binding.put("c", (Object)ProxyFactory.createController(this.scriptContext));
        binding.put("node", (Object)ProxyFactory.createNode(node, this.scriptContext));
        binding.putAll((Map<? extends String, ? extends Object>)ScriptingConfiguration.getStaticProperties());
        return binding;
    }

    private static ScriptEngineManager createScriptEngineManager(ClassLoader classLoader) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(classLoader);
        return scriptEngineManager;
    }

    static List<ScriptEngineFactory> createScriptEngineFactories() {
        ScriptClassLoader classLoader = ScriptClassLoader.createClassLoader();
        return GenericScript.createScriptEngineManager(classLoader).getEngineFactories();
    }

    private void compileAndCache(Compilable engine) throws Throwable {
        if (this.compileTimeStrategy.canUseOldCompiledScript()) {
            return;
        }
        this.compiledScript = null;
        this.errorsInScript = null;
        try {
            this.scriptSource.rereadFile();
            this.compileTimeStrategy.scriptCompileStart();
            this.compiledScript = engine.compile(this.scriptSource.getScript());
            this.compileTimeStrategy.scriptCompiled();
        }
        catch (Throwable e) {
            this.errorsInScript = e;
            throw e;
        }
    }

    private static ScriptEngine checkNotNull(ScriptEngine motor, String what, String detail) {
        if (motor == null) {
            throw new RuntimeException("can't load script engine by " + what + ": " + detail);
        }
        return motor;
    }

    private void handleScriptRuntimeException(ScriptException e) {
        this.outStream.print("message: " + e.getMessage());
        int lineNumber = e.getLineNumber();
        this.outStream.print("Line number: " + lineNumber);
        this.errorHandler.gotoLine(lineNumber);
        throw new ExecuteScriptException(e.getMessage() + " at line " + lineNumber, e.getCause() == null ? e : e.getCause());
    }

    @Override
    public boolean permissionsEquals(ScriptingPermissions permissions) {
        if (this.specificPermissions == null) {
            return this.specificPermissions == permissions;
        }
        return this.specificPermissions.equals(permissions);
    }

    public static final class ScriptSource {
        private final File file;
        private final String script;
        private String cachedFileContent;

        public ScriptSource(String script) {
            this.script = script;
            this.file = null;
        }

        public ScriptSource(File file) {
            this.script = null;
            this.file = file;
            this.cachedFileContent = GenericScript.slurpFile(file);
        }

        public boolean isFile() {
            return this.file != null;
        }

        public String rereadFile() {
            this.cachedFileContent = GenericScript.slurpFile(this.file);
            return this.cachedFileContent;
        }

        public String getScript() {
            return this.isFile() ? this.cachedFileContent : this.script;
        }

        public String getPath() {
            return this.isFile() ? this.file.getAbsolutePath() : null;
        }
    }
}

