/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.awt.event.ActionEvent;
import java.io.PrintStream;
import java.util.ArrayList;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.ScriptEditorPanel;
import org.freeplane.plugin.script.ScriptEditorWindowConfigurationStorage;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingPermissions;

class ScriptEditor
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ScriptEditor() {
        super("ScriptEditor");
    }

    public void actionPerformed(ActionEvent e) {
        ModeController modeController = Controller.getCurrentModeController();
        NodeModel node = modeController.getMapController().getSelectedNode();
        ArrayList<AttributeHolder> scripts = new ArrayList<AttributeHolder>();
        for (int position = 0; position < NodeAttributeTableModel.getModel((NodeModel)node).getAttributeTableLength(); ++position) {
            Attribute attribute = NodeAttributeTableModel.getModel((NodeModel)node).getAttribute(position);
            if (!attribute.getName().startsWith("script")) continue;
            scripts.add(new AttributeHolder(new Attribute(attribute), position));
        }
        NodeScriptModel nodeScriptModel = new NodeScriptModel(scripts, node);
        ScriptEditorPanel scriptEditorPanel = new ScriptEditorPanel(nodeScriptModel, true);
        scriptEditorPanel.setVisible(true);
    }

    private final class NodeScriptModel
    implements ScriptEditorPanel.IScriptModel {
        private boolean isDirty = false;
        private final NodeModel mNode;
        private final ArrayList<AttributeHolder> mScripts;

        private NodeScriptModel(ArrayList<AttributeHolder> pScripts, NodeModel node) {
            this.mScripts = pScripts;
            this.mNode = node;
        }

        @Override
        public int addNewScript() {
            boolean found;
            int index = this.mScripts.size();
            int attributeIndex = NodeAttributeTableModel.getModel((NodeModel)this.mNode).getAttributeTableLength();
            String scriptName = "script";
            int scriptNameSuffix = 1;
            block0: do {
                found = false;
                for (AttributeHolder holder : this.mScripts) {
                    if (!("script" + scriptNameSuffix).equals(holder.mAttribute.getName())) continue;
                    found = true;
                    ++scriptNameSuffix;
                    continue block0;
                }
            } while (found);
            this.mScripts.add(new AttributeHolder(new Attribute("script" + scriptNameSuffix, (Object)""), attributeIndex));
            this.isDirty = true;
            return index;
        }

        @Override
        public ScriptEditorWindowConfigurationStorage decorateDialog(ScriptEditorPanel pPanel, String pWindow_preference_storage_property) {
            String marshalled = ResourceController.getResourceController().getProperty(pWindow_preference_storage_property);
            return ScriptEditorWindowConfigurationStorage.decorateDialog(marshalled, pPanel);
        }

        @Override
        public void endDialog(boolean pIsCanceled) {
            if (!pIsCanceled) {
                int attributeTableLength = NodeAttributeTableModel.getModel((NodeModel)this.mNode).getAttributeTableLength();
                for (AttributeHolder holder : this.mScripts) {
                    Attribute attribute = holder.mAttribute;
                    int position = holder.mPosition;
                    MAttributeController attributeController = (MAttributeController)AttributeController.getController();
                    if (attributeTableLength <= position) {
                        attributeController.addAttribute(this.mNode, attribute);
                        continue;
                    }
                    if (NodeAttributeTableModel.getModel((NodeModel)this.mNode).getAttribute(position).getValue() == attribute.getValue()) continue;
                    attributeController.setAttribute(this.mNode, position, attribute);
                }
            }
        }

        @Override
        public Object executeScript(int pIndex, PrintStream pOutStream, IFreeplaneScriptErrorHandler pErrorHandler) {
            String script = this.getScript(pIndex).getScript();
            ModeController mMindMapController = Controller.getCurrentModeController();
            return ScriptingEngine.executeScript(mMindMapController.getMapController().getSelectedNode(), script, pErrorHandler, pOutStream, null, ScriptingPermissions.getPermissiveScriptingPermissions());
        }

        @Override
        public int getAmountOfScripts() {
            return this.mScripts.size();
        }

        @Override
        public ScriptEditorPanel.ScriptHolder getScript(int pIndex) {
            Attribute attribute = this.mScripts.get((int)pIndex).mAttribute;
            return new ScriptEditorPanel.ScriptHolder(attribute.getName(), attribute.getValue().toString());
        }

        @Override
        public boolean isDirty() {
            return this.isDirty;
        }

        @Override
        public void setScript(int pIndex, ScriptEditorPanel.ScriptHolder pScript) {
            AttributeHolder oldHolder = this.mScripts.get(pIndex);
            if (!pScript.mScriptName.equals(oldHolder.mAttribute.getName())) {
                this.isDirty = true;
            }
            if (!pScript.mScript.equals(oldHolder.mAttribute.getValue())) {
                this.isDirty = true;
            }
            oldHolder.mAttribute.setName(pScript.mScriptName);
            oldHolder.mAttribute.setValue((Object)pScript.mScript);
        }

        @Override
        public void storeDialogPositions(ScriptEditorPanel pPanel, ScriptEditorWindowConfigurationStorage pStorage, String pWindow_preference_storage_property) {
            pStorage.storeDialogPositions(pPanel, pWindow_preference_storage_property);
        }
    }

    private final class AttributeHolder {
        Attribute mAttribute;
        int mPosition;

        public AttributeHolder(Attribute pAttribute, int pPosition) {
            this.mAttribute = pAttribute;
            this.mPosition = pPosition;
        }
    }
}

