/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.GenericScript;
import org.freeplane.plugin.script.GroovyScript;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptingPermissions;

public class ScriptingEngine {
    public static final String SCRIPT_PREFIX = "script";
    private static Map<File, IScript> scriptCache = new WeakHashMap<File, IScript>();

    public static Object executeScript(NodeModel node, String script, IFreeplaneScriptErrorHandler pErrorHandler, PrintStream pOutStream, ScriptContext scriptContext, ScriptingPermissions permissions) {
        return new GroovyScript(script, permissions).setErrorHandler(pErrorHandler).setOutStream(pOutStream).setScriptContext(scriptContext).execute(node);
    }

    static Object executeScript(NodeModel node, File script, IFreeplaneScriptErrorHandler pErrorHandler, PrintStream pOutStream, ScriptContext scriptContext, ScriptingPermissions permissions) {
        return ScriptingEngine.createScriptForFile(script, permissions).setErrorHandler(pErrorHandler).setOutStream(pOutStream).setScriptContext(scriptContext).execute(node);
    }

    public static int findLineNumberInString(String resultString, int lineNumber) {
        Pattern pattern = Pattern.compile(".*@ line ([0-9]+).*", 32);
        Matcher matcher = pattern.matcher(resultString);
        if (matcher.matches()) {
            lineNumber = Integer.parseInt(matcher.group(1));
        }
        return lineNumber;
    }

    public static Object executeScript(NodeModel node, String script) {
        return new GroovyScript(script).execute(node);
    }

    public static Object executeScript(NodeModel node, File script, ScriptingPermissions permissions) {
        return ScriptingEngine.createScriptForFile(script, permissions).execute(node);
    }

    public static synchronized IScript createScriptForFile(File scriptFile, ScriptingPermissions permissions) {
        IScript script = scriptCache.get(scriptFile);
        if (script == null || script.permissionsEquals(permissions)) {
            boolean isGroovy = scriptFile.getName().endsWith(".groovy");
            script = isGroovy ? new GroovyScript(scriptFile, permissions) : new GenericScript(scriptFile, permissions);
            scriptCache.put(scriptFile, script);
        }
        return script;
    }

    public static Object executeScript(NodeModel node, String script, ScriptingPermissions permissions) {
        return new GroovyScript(script, permissions).execute(node);
    }

    public static Object executeScript(NodeModel node, String script, PrintStream printStream) {
        return new GroovyScript(script).setOutStream(printStream).execute(node);
    }

    public static Object executeScript(NodeModel node, String script, ScriptContext scriptContext, ScriptingPermissions permissions) {
        return new GroovyScript(script, permissions).setScriptContext(scriptContext).execute(node);
    }

    static void performScriptOperationRecursive(NodeModel node) {
        ModeController modeController = Controller.getCurrentModeController();
        for (NodeModel child : modeController.getMapController().childrenUnfolded(node)) {
            ScriptingEngine.performScriptOperationRecursive(child);
        }
        ScriptingEngine.performScriptOperation(node);
    }

    static void performScriptOperation(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel((NodeModel)node);
        if (attributes == null) {
            return;
        }
        for (int row = 0; row < attributes.getRowCount(); ++row) {
            String attrKey = (String)attributes.getName(row);
            Object value = attributes.getValue(row);
            if (!(value instanceof String)) continue;
            String script = (String)value;
            if (!attrKey.startsWith(SCRIPT_PREFIX)) continue;
            ScriptingEngine.executeScript(node, script);
        }
    }

    @Deprecated
    public static File getUserScriptDir() {
        return ScriptResources.getUserScriptDir();
    }

    static void showScriptExceptionErrorMessage(ExecuteScriptException ex) {
        if (ex.getCause() instanceof SecurityException) {
            String message = WordUtils.wrap((String)ex.getCause().getMessage(), (int)80, (String)"\n    ", (boolean)false);
            UITools.errorMessage((Object)TextUtils.format((String)"ExecuteScriptSecurityError.text", (Object[])new Object[]{message}));
        } else {
            String message = WordUtils.wrap((String)ex.getMessage(), (int)80, (String)"\n    ", (boolean)false);
            UITools.errorMessage((Object)TextUtils.format((String)"ExecuteScriptError.text", (Object[])new Object[]{message}));
        }
    }
}

