/*
 * Decompiled with CFR 0.152.
 */
package de.calcom.cclib.text;

import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.Util;
import de.calcom.cclib.text.FindReplaceEvent;
import de.calcom.cclib.text.FindReplaceListener;
import de.calcom.cclib.text.PseudoDamerauLevenshtein;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;

public class FindReplaceDialog
extends JDialog {
    private int result;
    private int mode;
    private JEditorPane editor;
    private Document doc;
    private String searchText;
    private String searchTerm;
    private List<PseudoDamerauLevenshtein.Alignment> currentApproximateMatches;
    private int currentApproximateMatchIndex;
    private String replacementText;
    private int lastPosition;
    private int offset;
    private int replaceDiff;
    private boolean findInProgress = false;
    private int operation;
    private int replaceChoice;
    private final Vector listeners = new Vector(0);
    private static final char[] WORD_SEPARATORS = new char[]{' ', '\t', '\n', '\r', '\f', '.', ',', ':', '-', '(', ')', '[', ']', '{', '}', '<', '>', '/', '|', '\\', '\'', '\"'};
    private static final Object[] replaceOptions = new Object[]{Util.getResourceString(SHTMLPanel.getResources(), "replaceYes"), Util.getResourceString(SHTMLPanel.getResources(), "replaceNo"), Util.getResourceString(SHTMLPanel.getResources(), "replaceAll"), Util.getResourceString(SHTMLPanel.getResources(), "replaceDone")};
    public static final boolean STATE_LOCKED = false;
    public static final boolean STATE_UNLOCKED = true;
    public static final int RO_YES = 0;
    public static final int RO_NO = 1;
    public static final int RO_ALL = 2;
    public static final int RO_DONE = 3;
    public static final int MODE_DOCUMENT = 1;
    public static final int MODE_PROJECT = 2;
    public static final int OP_NONE = 0;
    public static final int OP_FIND = 1;
    public static final int OP_REPLACE = 2;
    private TitledBorder titledBorder1;
    private final JButton jbtnFindNext = new JButton();
    private final JCheckBox jcbStartOnTop = new JCheckBox();
    private final JRadioButton jrbDown = new JRadioButton();
    private final JCheckBox jcbWholeWords = new JCheckBox();
    private final JPanel jpnlBtn = new JPanel();
    private final JPanel jpnlOptions = new JPanel();
    private final JPanel jpnlFind = new JPanel();
    private final JTextField jtfReplace = new JTextField();
    private final JPanel jpnlMain = new JPanel();
    private final JRadioButton jrbUp = new JRadioButton();
    private final JComboBox jcomboSearchTerm = new JComboBox();
    private final JCheckBox jcbMatchCase = new JCheckBox();
    private final JCheckBox jcbMatchApprox = new JCheckBox();
    private final JLabel jLabel3 = new JLabel();
    private final JLabel jLabel4 = new JLabel();
    private final GridBagLayout gridBagLayout4 = new GridBagLayout();
    private final GridBagLayout gridBagLayout5 = new GridBagLayout();
    private final JButton jbtnClose = new JButton();
    private final GridBagLayout gridBagLayout6 = new GridBagLayout();
    private final GridLayout gridLayout2 = new GridLayout();
    private final JButton jbtnReplace = new JButton();
    private final JButton jbtnCancel = new JButton();
    private final JCheckBox jcbProject = new JCheckBox();
    private static final List<String> searchTermHistory = new LinkedList<String>();
    private static final AtomicBoolean matchCaseSetting = new AtomicBoolean(false);
    private static final AtomicBoolean matchApproxSetting = new AtomicBoolean(false);

    public FindReplaceDialog() {
        try {
            this.jbInit();
            this.initDialogContents();
            this.rememberSearchTermFromSelection();
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FindReplaceDialog(Frame owner, JEditorPane editor) {
        this.setEditor(editor);
        this.setMode(1);
        try {
            this.jbInit();
            this.initDialogContents();
            this.centerDialog(owner);
            this.rememberSearchTermFromSelection();
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FindReplaceDialog(Frame owner, JEditorPane editor, FindReplaceListener listener) {
        this.setEditor(editor);
        this.setMode(2);
        this.addFindReplaceListener(listener);
        try {
            this.jbInit();
            this.initDialogContents();
            this.centerDialog(owner);
            this.rememberSearchTermFromSelection();
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void rememberSearchTermFromSelection() {
        if (this.editor.getSelectedText() != null) {
            FindReplaceDialog.rememberSearchTerm(this.editor.getSelectedText(), this.jcomboSearchTerm);
        }
    }

    public void addFindReplaceListener(FindReplaceListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeFindReplaceListener(FindReplaceListener listener) {
        this.listeners.removeElement(listener);
    }

    private void fireGetNextDocument() {
        Enumeration listenerList = this.listeners.elements();
        while (listenerList.hasMoreElements()) {
            ((FindReplaceListener)listenerList.nextElement()).getNextDocument(new FindReplaceEvent(this));
        }
    }

    private void fireGetFirstDocument() {
        Enumeration listenerList = this.listeners.elements();
        while (listenerList.hasMoreElements()) {
            ((FindReplaceListener)listenerList.nextElement()).getFirstDocument(new FindReplaceEvent(this));
        }
    }

    private void fireFindReplaceTerminated() {
        Enumeration listenerList = this.listeners.elements();
        while (listenerList.hasMoreElements()) {
            ((FindReplaceListener)listenerList.nextElement()).findReplaceTerminated(new FindReplaceEvent(this));
        }
    }

    public void resumeOperation() {
        this.doc = this.editor.getDocument();
        this.findInProgress = false;
        this.initFind();
        switch (this.operation) {
            case 1: {
                this.find();
                break;
            }
            case 2: {
                this.replace();
            }
        }
    }

    public void terminateOperation() {
        switch (this.operation) {
            case 1: {
                this.message(Util.getResourceString(SHTMLPanel.getResources(), "noMoreOccurrencesFound"));
                this.toggleState(true);
                this.jbtnReplace.setEnabled(true);
                break;
            }
            case 2: {
                switch (this.replaceChoice) {
                    case 0: 
                    case 1: {
                        this.message(Util.getResourceString(SHTMLPanel.getResources(), "noMoreOccurrencesFound"));
                        break;
                    }
                    case 2: {
                        this.message(Util.getResourceString(SHTMLPanel.getResources(), "allOccurrencesReplaced"));
                    }
                }
                this.toggleState(true);
                this.setVisible(true);
            }
        }
        this.operation = 0;
        this.fireFindReplaceTerminated();
    }

    private void jbtnFindNext_actionPerformed(ActionEvent e) {
        this.operation = 1;
        this.jbtnReplace.setEnabled(false);
        if (this.mode == 2 && this.jcbProject.isSelected() && this.listeners.size() > 0 && !this.findInProgress) {
            this.fireGetFirstDocument();
        } else {
            this.initFind();
            this.find();
        }
    }

    private void jbtnReplace_actionPerformed(ActionEvent e) {
        this.operation = 2;
        this.replaceChoice = 0;
        this.setVisible(false);
        if (this.mode == 2 && this.jcbProject.isSelected() && this.listeners.size() > 0 && !this.findInProgress) {
            this.fireGetFirstDocument();
        } else {
            this.initFind();
            this.replace();
        }
    }

    private void jbtnCancel_actionPerformed(ActionEvent e) {
        this.toggleState(true);
        this.jbtnReplace.setEnabled(true);
    }

    private void jbtnClose_actionPerformed(ActionEvent e) {
        this.result = 0;
        this.dispose();
    }

    public void setEditor(JEditorPane editor) {
        this.editor = editor;
        this.doc = editor.getDocument();
    }

    public void setMode(int mode) {
        this.mode = mode;
        if (mode == 2) {
            this.jcbProject.setVisible(true);
        } else {
            this.jcbProject.setVisible(false);
        }
    }

    public void setSearchingBusyCursor() {
        this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.getRootPane().getGlassPane().setVisible(true);
    }

    public void setSearchingDefaultCursor() {
        this.getRootPane().getGlassPane().setCursor(Cursor.getDefaultCursor());
        this.getRootPane().getGlassPane().setVisible(false);
    }

    private void initFind() {
        if (!this.findInProgress) {
            try {
                this.searchText = this.doc.getText(0, this.doc.getLength());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.searchTerm = (String)this.jcomboSearchTerm.getEditor().getItem();
            FindReplaceDialog.rememberSearchTerm(this.searchTerm, this.jcomboSearchTerm);
            matchCaseSetting.getAndSet(this.jcbMatchCase.isSelected());
            matchApproxSetting.getAndSet(this.jcbMatchApprox.isSelected());
            this.replacementText = this.jtfReplace.getText();
            this.replaceDiff = this.replacementText.length() - this.searchTerm.length();
            this.offset = 0;
            if (!this.jcbMatchCase.isSelected()) {
                this.searchTerm = this.searchTerm.toLowerCase();
                this.searchText = this.searchText.toLowerCase();
            }
            if (this.jcbMatchApprox.isSelected()) {
                this.initApproximateSearch();
            } else {
                this.initExactSearch();
            }
            this.toggleState(false);
        }
    }

    private void initExactSearch() {
        this.lastPosition = this.jcbStartOnTop.isSelected() ? (this.jrbUp.isSelected() ? this.doc.getLength() : -1) : this.editor.getSelectionStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initApproximateSearch() {
        PseudoDamerauLevenshtein PDL = new PseudoDamerauLevenshtein();
        PDL.init(this.searchTerm, this.searchText, true, this.jcbMatchCase.isSelected());
        double threshold = Double.parseDouble(Util.getPreference("approximate_search_threshold", null));
        try {
            this.setSearchingBusyCursor();
            this.currentApproximateMatches = PDL.computeAlignments(threshold);
        }
        finally {
            this.setSearchingDefaultCursor();
        }
        if (this.jcbStartOnTop.isSelected()) {
            this.currentApproximateMatchIndex = this.jrbUp.isSelected() ? this.currentApproximateMatches.size() : -1;
        } else {
            int start = this.editor.getSelectionStart();
            int i = 0;
            this.currentApproximateMatchIndex = 0;
            for (PseudoDamerauLevenshtein.Alignment ali : this.currentApproximateMatches) {
                if (ali.getMatchStart() >= start) {
                    this.currentApproximateMatchIndex = i - 1;
                    break;
                }
                ++i;
            }
        }
    }

    private void find() {
        if (!this.doFind()) {
            if (this.mode == 2 && this.jcbProject.isSelected() && this.listeners.size() > 0) {
                this.fireGetNextDocument();
            } else {
                this.terminateOperation();
            }
        }
    }

    private boolean doFind() {
        int start;
        boolean found = false;
        if (this.jcbMatchApprox.isSelected()) {
            start = this.findNextApproximately();
        } else {
            start = this.findNext();
            if (this.jcbWholeWords.isSelected()) {
                start = this.findWholeWords(start);
            }
        }
        if (start >= 0) {
            this.lastPosition = start;
            if (this.jrbDown.isSelected()) {
                start += this.offset;
            }
            this.editor.setCaretPosition(start);
            this.editor.moveCaretPosition(start + this.getMatchLength());
            this.editor.getCaret().setSelectionVisible(true);
            found = true;
        }
        return found;
    }

    private int getMatchLength() {
        if (this.jcbMatchApprox.isSelected()) {
            return this.currentApproximateMatches.get(this.currentApproximateMatchIndex).getMatch().length();
        }
        return this.searchTerm.length();
    }

    private int findNextApproximately() {
        int nextIndex = this.currentApproximateMatchIndex + (this.jrbUp.isSelected() ? -1 : 1);
        if (nextIndex < 0 || nextIndex >= this.currentApproximateMatches.size()) {
            return -1;
        }
        this.currentApproximateMatchIndex = nextIndex;
        return this.currentApproximateMatches.get(nextIndex).getMatchStart();
    }

    private int findNext() {
        if (this.searchTerm.length() == 0) {
            return -1;
        }
        int start = -1;
        start = this.jrbUp.isSelected() ? (this.lastPosition < this.doc.getLength() ? this.searchText.lastIndexOf(this.searchTerm, this.lastPosition - 1) : this.searchText.lastIndexOf(this.searchTerm, this.lastPosition)) : (this.lastPosition >= 0 ? this.searchText.indexOf(this.searchTerm, this.lastPosition + this.searchTerm.length()) : this.searchText.indexOf(this.searchTerm, this.lastPosition));
        return start;
    }

    private int findWholeWords(int start) {
        while (!(start <= 0 || this.isSeparator(this.searchText.charAt(start - 1)) && this.isSeparator(this.searchText.charAt(start + this.searchTerm.length())))) {
            this.lastPosition = start;
            start = this.findNext();
        }
        return start;
    }

    private void replace() {
        while (this.replaceChoice != 3 && this.doFind()) {
            if (this.replaceChoice != 2) {
                this.replaceChoice = this.getReplaceChoice();
            }
            switch (this.replaceChoice) {
                case 0: {
                    this.replaceOne();
                    break;
                }
                case 2: {
                    this.replaceOne();
                    while (this.doFind()) {
                        this.replaceOne();
                    }
                    break;
                }
            }
        }
        if (this.mode == 2 && this.jcbProject.isSelected() && this.listeners.size() > 0) {
            switch (this.replaceChoice) {
                case 0: 
                case 1: 
                case 2: {
                    this.fireGetNextDocument();
                    break;
                }
                case 3: {
                    this.terminateOperation();
                }
            }
        } else {
            this.terminateOperation();
        }
    }

    private int getReplaceChoice() {
        String msg = Util.getResourceString(SHTMLPanel.getResources(), "replaceThisQuery") + " '" + this.searchTerm + "'?";
        return JOptionPane.showOptionDialog(this, msg, Util.getResourceString(SHTMLPanel.getResources(), "findReplaceDialogTitle"), 1, 3, null, replaceOptions, null);
    }

    private void replaceOne() {
        this.editor.replaceSelection(this.replacementText);
        this.offset += this.replaceDiff;
    }

    private void initDialogContents() {
        this.jbtnCancel.setEnabled(false);
        this.jrbUp.setSelected(false);
        this.jrbDown.setSelected(true);
        this.jcbWholeWords.setSelected(false);
        this.jcbMatchCase.setSelected(matchCaseSetting.get());
        this.jcbMatchApprox.setSelected(matchApproxSetting.get());
        this.jcbStartOnTop.setSelected(true);
        this.jcbProject.setSelected(false);
        MutableComboBoxModel searchTermComboModel = (MutableComboBoxModel)this.jcomboSearchTerm.getModel();
        while (searchTermComboModel.getSize() > 0) {
            searchTermComboModel.removeElementAt(0);
        }
        for (String searchTerm : searchTermHistory) {
            searchTermComboModel.addElement(searchTerm);
        }
        this.jcomboSearchTerm.setEditable(true);
        this.jtfReplace.setText("");
    }

    public void centerDialog(Frame owner) {
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = owner.getSize();
        Point loc = owner.getLocation();
        this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    }

    private void toggleState(boolean unlocked) {
        this.jbtnCancel.setEnabled(!unlocked);
        this.jbtnClose.setEnabled(unlocked);
        this.jcomboSearchTerm.setEnabled(unlocked);
        this.jtfReplace.setEnabled(unlocked);
        this.jLabel3.setEnabled(unlocked);
        this.jLabel4.setEnabled(unlocked);
        this.jcbWholeWords.setEnabled(unlocked);
        this.jcbMatchCase.setEnabled(unlocked);
        this.jcbMatchApprox.setEnabled(unlocked);
        this.jcbStartOnTop.setEnabled(unlocked);
        this.jrbUp.setEnabled(unlocked);
        this.jrbDown.setEnabled(unlocked);
        this.jcbProject.setEnabled(unlocked);
        this.findInProgress = !unlocked;
    }

    private boolean isSeparator(char ch) {
        int i;
        for (i = 0; i < WORD_SEPARATORS.length && ch != WORD_SEPARATORS[i]; ++i) {
        }
        return i < WORD_SEPARATORS.length;
    }

    private void message(String msgText) {
        JOptionPane.showMessageDialog(this, msgText, Util.getResourceString(SHTMLPanel.getResources(), "findReplaceDialogTitle"), 1);
    }

    private void jbInit() throws Exception {
        KeyAdapter escapeKeyListender = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    FindReplaceDialog.this.jbtnClose_actionPerformed(null);
                }
            }
        };
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Options");
        ButtonGroup bgSearchDirection = new ButtonGroup();
        this.jbtnFindNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.jbtnFindNext_actionPerformed(e);
            }
        });
        this.jbtnFindNext.setText(Util.getResourceString(SHTMLPanel.getResources(), "findNext"));
        this.jbtnFindNext.setPreferredSize(new Dimension(100, 27));
        this.jbtnFindNext.setMinimumSize(new Dimension(100, 27));
        this.jbtnFindNext.setMaximumSize(new Dimension(100, 27));
        this.jbtnFindNext.addKeyListener(escapeKeyListender);
        this.jcbStartOnTop.setText(Util.getResourceString(SHTMLPanel.getResources(), "searchFromStart"));
        this.jcbStartOnTop.setToolTipText(Util.getResourceString(SHTMLPanel.getResources(), "searchFromStart.tooltip"));
        this.jrbDown.setText(Util.getResourceString(SHTMLPanel.getResources(), "searchDown"));
        this.jcbWholeWords.setText(Util.getResourceString(SHTMLPanel.getResources(), "wholeWordsOnly"));
        this.jcbWholeWords.setToolTipText(Util.getResourceString(SHTMLPanel.getResources(), "wholeWordsOnly.tooltip"));
        this.jrbDown.setToolTipText(Util.getResourceString(SHTMLPanel.getResources(), "searchDown.tooltip"));
        this.jrbUp.setToolTipText(Util.getResourceString(SHTMLPanel.getResources(), "searchUp.tooltip"));
        this.jpnlBtn.setLayout(this.gridBagLayout4);
        this.jpnlOptions.setBorder(this.titledBorder1);
        this.jpnlOptions.setLayout(this.gridLayout2);
        this.jpnlFind.setLayout(this.gridBagLayout5);
        this.jtfReplace.setMinimumSize(new Dimension(4, 12));
        this.jtfReplace.setPreferredSize(new Dimension(59, 12));
        this.jtfReplace.setText("jtfReplace");
        this.jtfReplace.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    FindReplaceDialog.this.jbtnClose_actionPerformed(null);
                } else if (e.getKeyCode() == 10) {
                    e.consume();
                    FindReplaceDialog.this.jbtnReplace_actionPerformed(null);
                    FindReplaceDialog.this.jbtnReplace.requestFocus();
                }
            }
        });
        this.jpnlMain.setLayout(this.gridBagLayout6);
        this.jrbUp.setText(Util.getResourceString(SHTMLPanel.getResources(), "searchUp"));
        this.jcomboSearchTerm.setMinimumSize(new Dimension(4, 12));
        this.jcomboSearchTerm.setPreferredSize(new Dimension(63, 12));
        this.jcomboSearchTerm.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    FindReplaceDialog.this.jbtnClose_actionPerformed(null);
                } else if (e.getKeyCode() == 10) {
                    e.consume();
                    FindReplaceDialog.this.jbtnFindNext_actionPerformed(null);
                    FindReplaceDialog.this.jbtnFindNext.requestFocus();
                }
            }
        });
        this.jcbMatchCase.setText(Util.getResourceString(SHTMLPanel.getResources(), "matchCase"));
        this.jcbMatchCase.setToolTipText(Util.getResourceString(SHTMLPanel.getResources(), "matchCase.tooltip"));
        this.jcbMatchApprox.setText(Util.getResourceString(SHTMLPanel.getResources(), "matchApproximately"));
        this.jcbMatchApprox.setToolTipText(Util.getResourceString(SHTMLPanel.getResources(), "matchApproximately.tooltip"));
        this.jLabel3.setText(Util.getResourceString(SHTMLPanel.getResources(), "replaceWith"));
        this.jLabel4.setText(Util.getResourceString(SHTMLPanel.getResources(), "textToFind"));
        this.jbtnClose.setMaximumSize(new Dimension(100, 27));
        this.jbtnClose.setMinimumSize(new Dimension(100, 27));
        this.jbtnClose.setPreferredSize(new Dimension(100, 27));
        this.jbtnClose.setText(Util.getResourceString(SHTMLPanel.getResources(), "closeBtnName"));
        this.jbtnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.jbtnClose_actionPerformed(e);
            }
        });
        this.gridLayout2.setRows(4);
        this.gridLayout2.setColumns(2);
        this.setModal(true);
        this.setTitle(Util.getResourceString(SHTMLPanel.getResources(), "findReplaceDialogTitle"));
        this.jbtnReplace.setMaximumSize(new Dimension(100, 27));
        this.jbtnReplace.setMinimumSize(new Dimension(100, 27));
        this.jbtnReplace.setPreferredSize(new Dimension(100, 27));
        this.jbtnReplace.setText(Util.getResourceString(SHTMLPanel.getResources(), "replace"));
        this.jbtnReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.jbtnReplace_actionPerformed(e);
            }
        });
        this.jbtnReplace.addKeyListener(escapeKeyListender);
        this.jbtnCancel.setMaximumSize(new Dimension(100, 27));
        this.jbtnCancel.setMinimumSize(new Dimension(100, 27));
        this.jbtnCancel.setPreferredSize(new Dimension(100, 27));
        this.jbtnCancel.setText(Util.getResourceString(SHTMLPanel.getResources(), "cancelBtnName"));
        this.jbtnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.jbtnCancel_actionPerformed(e);
            }
        });
        this.jcbProject.setText(Util.getResourceString(SHTMLPanel.getResources(), "searchWholeProject"));
        this.getContentPane().add((Component)this.jpnlMain, "North");
        this.jpnlBtn.add((Component)this.jbtnFindNext, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 4, 0, 4), 0, 0));
        this.jpnlBtn.add((Component)this.jbtnClose, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 4, 4, 4), 0, 0));
        this.jpnlBtn.add((Component)this.jbtnReplace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.jpnlBtn.add((Component)this.jbtnCancel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.jpnlMain.add((Component)this.jpnlFind, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.jpnlMain.add((Component)this.jpnlBtn, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 12, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.jpnlFind.add((Component)this.jcomboSearchTerm, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 12));
        this.jpnlFind.add((Component)this.jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.jpnlFind.add((Component)this.jtfReplace, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 12));
        this.jpnlFind.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.jpnlMain.add((Component)this.jpnlOptions, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 16, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.jpnlOptions.add((Component)this.jcbMatchCase, null);
        this.jpnlOptions.add((Component)this.jcbMatchApprox, null);
        this.jpnlOptions.add((Component)this.jcbWholeWords, null);
        this.jpnlOptions.add((Component)this.jrbUp, null);
        this.jpnlOptions.add((Component)this.jcbStartOnTop, null);
        this.jpnlOptions.add((Component)this.jrbDown, null);
        this.jpnlOptions.add((Component)this.jcbProject, null);
        bgSearchDirection.add(this.jrbUp);
        bgSearchDirection.add(this.jrbDown);
        this.getRootPane().setDefaultButton(this.jbtnFindNext);
    }

    public static synchronized void rememberSearchTerm(String searchTerm, JComboBox searchTermCombo) {
        if (searchTerm.equals("")) {
            return;
        }
        MutableComboBoxModel searchTermComboModel = (MutableComboBoxModel)searchTermCombo.getModel();
        if (searchTermHistory.contains(searchTerm)) {
            searchTermHistory.remove(searchTerm);
            searchTermComboModel.removeElement(searchTerm);
        }
        searchTermHistory.add(0, searchTerm);
        searchTermComboModel.insertElementAt(searchTerm, 0);
        searchTermCombo.setSelectedItem(searchTerm);
    }
}

