/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.ViewFactory;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxStyle;
import jsyntaxpane.SyntaxStyles;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.util.Configuration;

public class SyntaxView
extends PlainView {
    public static final String PROPERTY_RIGHT_MARGIN_COLOR = "RightMarginColor";
    public static final String PROPERTY_RIGHT_MARGIN_COLUMN = "RightMarginColumn";
    public static final String PROPERTY_SINGLE_COLOR_SELECT = "SingleColorSelect";
    private static final Logger log = Logger.getLogger(SyntaxView.class.getName());
    private SyntaxStyle DEFAULT_STYLE = SyntaxStyles.getInstance().getStyle(TokenType.DEFAULT);
    private final boolean singleColorSelect;
    private final int rightMarginColumn;
    private final Color rightMarginColor;
    private final SyntaxStyles styles;
    private static RenderingHints sysHints = null;

    public SyntaxView(Element element, Configuration configuration) {
        super(element);
        this.singleColorSelect = configuration.getBoolean(PROPERTY_SINGLE_COLOR_SELECT, false);
        this.rightMarginColor = new Color(configuration.getInteger(PROPERTY_RIGHT_MARGIN_COLOR, 0xFF7777));
        this.rightMarginColumn = configuration.getInteger(PROPERTY_RIGHT_MARGIN_COLUMN, 0);
        this.styles = SyntaxStyles.read(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        SyntaxView.setRenderingHits((Graphics2D)graphics);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        SyntaxDocument syntaxDocument = (SyntaxDocument)this.getDocument();
        Segment segment = this.getLineBuffer();
        if (this.rightMarginColumn > 0) {
            int n6 = this.rightMarginColumn * graphics.getFontMetrics().charWidth('m');
            n5 = graphics.getFontMetrics().getHeight();
            graphics.setColor(this.rightMarginColor);
            graphics.drawLine(n6, n2, n6, n2 - n5);
        }
        try {
            Iterator<Token> iterator = syntaxDocument.getTokens(n3, n4);
            n5 = n3;
            while (iterator.hasNext()) {
                Token token = iterator.next();
                if (n5 < token.start) {
                    syntaxDocument.getText(n5, token.start - n5, segment);
                    n = this.DEFAULT_STYLE.drawText(segment, n, n2, graphics, this, n5);
                }
                int n7 = token.length;
                int n8 = token.start;
                if (n8 < n3) {
                    n7 -= n3 - n8;
                    n8 = n3;
                }
                if (n8 + n7 > n4) {
                    n7 = n4 - n8;
                }
                syntaxDocument.getText(n8, n7, segment);
                n = this.styles.drawText(segment, n, n2, graphics, this, token);
                n5 = token.end();
            }
            if (n5 < n4) {
                syntaxDocument.getText(n5, n4 - n5, segment);
                n = this.DEFAULT_STYLE.drawText(segment, n, n2, graphics, this, n5);
            }
        }
        catch (BadLocationException badLocationException) {
            log.log(Level.SEVERE, "Requested: " + badLocationException.offsetRequested(), badLocationException);
        }
        finally {
            graphics.setFont(font);
            graphics.setColor(color);
        }
        return n;
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        if (this.singleColorSelect) {
            if (this.rightMarginColumn > 0) {
                int n5 = this.rightMarginColumn * graphics.getFontMetrics().charWidth('m');
                int n6 = graphics.getFontMetrics().getHeight();
                graphics.setColor(this.rightMarginColor);
                graphics.drawLine(n5, n2, n5, n2 - n6);
            }
            return super.drawSelectedText(graphics, n, n2, n3, n4);
        }
        return this.drawUnselectedText(graphics, n, n2, n3, n4);
    }

    public static void setRenderingHits(Graphics2D graphics2D) {
        graphics2D.addRenderingHints(sysHints);
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.updateDamage(documentEvent, shape, viewFactory);
        Container container = this.getContainer();
        container.repaint();
    }

    static {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
            sysHints = new RenderingHints(map);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

