/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.EscapeListener;
import jsyntaxpane.actions.gui.MembersListRenderer;
import jsyntaxpane.util.ReflectUtils;
import jsyntaxpane.util.StringUtils;
import jsyntaxpane.util.SwingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectCompletionDialog
extends JDialog
implements EscapeListener {
    private Class theClass;
    public String escapeChars = ";(= \t\n";
    public List<Member> items;
    private final JTextComponent target;
    private JComboBox jCmbClassName;
    private JList jLstItems;
    private JScrollPane jScrollPane1;
    private JTextField jTxtItem;

    public ReflectCompletionDialog(JTextComponent jTextComponent) {
        super(SwingUtilities.getWindowAncestor(jTextComponent), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.target = jTextComponent;
        this.jTxtItem.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ReflectCompletionDialog.this.refilterList();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ReflectCompletionDialog.this.refilterList();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ReflectCompletionDialog.this.refilterList();
            }
        });
        this.jTxtItem.setFocusTraversalKeysEnabled(false);
        this.jCmbClassName.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReflectCompletionDialog.this.updateItems();
            }
        });
        SwingUtils.addEscapeListener(this);
    }

    public void setFonts(Font font) {
        this.jTxtItem.setFont(font);
        this.jLstItems.setFont(font);
        this.doLayout();
    }

    private String getSelection() {
        Object e;
        String string = this.jLstItems.getSelectedIndex() >= 0 ? ((e = this.jLstItems.getSelectedValue()) instanceof Method ? ReflectUtils.getJavaCallString((Method)e) : (e instanceof Constructor ? ReflectUtils.getJavaCallString((Constructor)e) : (e instanceof Field ? ((Field)e).getName() : e.toString()))) : this.jTxtItem.getText();
        return string;
    }

    private void refilterList() {
        String string = this.jTxtItem.getText();
        Vector<Member> vector = new Vector<Member>();
        Object e = this.jLstItems.getSelectedValue();
        for (Member member : this.items) {
            if (!StringUtils.camelCaseMatch(member.getName(), string)) continue;
            vector.add(member);
        }
        this.jLstItems.setListData(vector);
        if (e != null && vector.contains(e)) {
            this.jLstItems.setSelectedValue(e, true);
        } else {
            this.jLstItems.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jTxtItem = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jLstItems = new JList();
        this.jCmbClassName = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setName("CompletionDialog");
        this.setResizable(false);
        this.setUndecorated(true);
        this.jTxtItem.setBorder(null);
        this.jTxtItem.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ReflectCompletionDialog.this.jTxtItemKeyPressed(keyEvent);
            }
        });
        this.jLstItems.setSelectionMode(0);
        this.jLstItems.setCellRenderer(new MembersListRenderer(this));
        this.jLstItems.setFocusable(false);
        this.jLstItems.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ReflectCompletionDialog.this.jLstItemsMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jLstItems);
        this.jCmbClassName.setEditable(true);
        this.jCmbClassName.setModel(new DefaultComboBoxModel<String>(new String[]{"Object", "String"}));
        this.jCmbClassName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ReflectCompletionDialog.this.jCmbClassNameItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTxtItem, -1, 437, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 437, Short.MAX_VALUE).addComponent(this.jCmbClassName, 0, 437, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTxtItem, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 156, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jCmbClassName, -2, -1, -2)));
        this.pack();
    }

    private void jTxtItemKeyPressed(KeyEvent keyEvent) {
        int n = this.jLstItems.getSelectedIndex();
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.target.setCaretPosition(this.target.getSelectionEnd());
                this.setVisible(false);
                return;
            }
            case 40: {
                ++n;
                break;
            }
            case 38: {
                --n;
                break;
            }
            case 36: {
                n = 0;
                break;
            }
            case 35: {
                n = this.jLstItems.getModel().getSize() - 1;
                break;
            }
            case 34: {
                n += this.jLstItems.getVisibleRowCount();
                break;
            }
            case 33: {
                n -= this.jLstItems.getVisibleRowCount();
            }
        }
        if (this.escapeChars.indexOf(keyEvent.getKeyChar()) >= 0) {
            String string = this.getSelection();
            char c = keyEvent.getKeyChar();
            if (c != '\n') {
                string = string + (c == '\t' ? (char)' ' : (char)c);
            }
            this.target.replaceSelection(string);
            this.setVisible(false);
        } else {
            if (n >= this.jLstItems.getModel().getSize()) {
                n = this.jLstItems.getModel().getSize() - 1;
            }
            if (n < 0) {
                n = 0;
            }
            this.jLstItems.setSelectedIndex(n);
            this.jLstItems.ensureIndexIsVisible(n);
        }
    }

    private void jCmbClassNameItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.updateItems();
        }
    }

    private void jLstItemsMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            String string = this.getSelection();
            this.target.replaceSelection(string);
            this.setVisible(false);
        }
    }

    private void updateItems() {
        String string = this.jCmbClassName.getEditor().getItem().toString();
        if (this.items == null) {
            this.items = new ArrayList<Member>();
        } else {
            this.items.clear();
        }
        Class clazz = ReflectUtils.findClass(string, ReflectUtils.DEFAULT_PACKAGES);
        if (clazz != null) {
            this.theClass = clazz;
            ReflectUtils.addConstrcutors(clazz, this.items);
            ReflectUtils.addMethods(clazz, this.items);
            ReflectUtils.addFields(clazz, this.items);
            ActionUtils.insertIntoCombo(this.jCmbClassName, string);
            this.jTxtItem.requestFocusInWindow();
        }
        this.refilterList();
    }

    public Class getTheClass() {
        return this.theClass;
    }

    public void setItems(List<Member> list) {
        this.items = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFor(JTextComponent jTextComponent) {
        try {
            int n = jTextComponent.getSelectionStart();
            Window window = SwingUtilities.getWindowAncestor(jTextComponent);
            Rectangle rectangle = jTextComponent.modelToView(n);
            Point point = new Point(rectangle.x, rectangle.y);
            point = SwingUtilities.convertPoint(jTextComponent, point, window);
            SwingUtilities.convertPointToScreen(point, window);
            this.setLocationRelativeTo(window);
            this.setLocation(point);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(ReflectCompletionDialog.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
        finally {
            this.setFonts(jTextComponent.getFont());
            this.updateItems();
            this.jTxtItem.setText(jTextComponent.getSelectedText());
            this.setVisible(true);
        }
    }

    @Override
    public void escapePressed() {
        this.target.setCaretPosition(this.target.getSelectionEnd());
        this.setVisible(false);
    }
}

