/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.svg;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.TextUtils;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ImageLoadingListener;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;
import org.freeplane.view.swing.features.filepreview.ViewerLayoutManager;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGSVGElement;

public class SvgViewerFactory
implements IViewerFactory {
    public boolean accept(URI uri) {
        return uri.getRawPath().endsWith(".svg");
    }

    public String getDescription() {
        return TextUtils.getText((String)"svg");
    }

    public ScalableComponent createViewer(final ExternalResource resource, URI uri, final int maximumWidth) {
        final ViewerComponent canvas = new ViewerComponent(uri);
        canvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                Dimension originalSize = canvas.getOriginalSize();
                float r = resource.getZoom();
                int originalWidth = originalSize.width;
                ViewerLayoutManager viewerLayoutManager = new ViewerLayoutManager(1.0f, resource, originalSize);
                canvas.setLayout((LayoutManager)viewerLayoutManager);
                if (r == -1.0f) {
                    r = resource.setZoom(originalWidth, maximumWidth);
                }
                canvas.setFinalViewerSize(originalSize);
                canvas.setPreferredSize(viewerLayoutManager.calculatePreferredSize());
                canvas.revalidate();
                canvas.removeGVTTreeRendererListener((GVTTreeRendererListener)this);
            }
        });
        return canvas;
    }

    public ScalableComponent createViewer(URI uri, Dimension preferredSize) {
        final ViewerComponent canvas = new ViewerComponent(uri);
        canvas.setFinalViewerSize(preferredSize);
        canvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                canvas.setFinalViewerSize(canvas.getSize());
                canvas.revalidate();
                canvas.removeGVTTreeRendererListener((GVTTreeRendererListener)this);
            }
        });
        return canvas;
    }

    public ScalableComponent createViewer(URI uri, final float zoom) throws MalformedURLException, IOException {
        final ViewerComponent canvas = new ViewerComponent(uri);
        canvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                canvas.setFinalViewerSize(zoom);
                canvas.revalidate();
                canvas.removeGVTTreeRendererListener((GVTTreeRendererListener)this);
            }
        });
        return canvas;
    }

    private final class ViewerComponent
    extends JSVGCanvas
    implements ScalableComponent {
        private static final long serialVersionUID = 1L;
        private Dimension originalSize;
        private Dimension maximumSize;

        public Dimension getOriginalSize() {
            return new Dimension(this.originalSize);
        }

        public void setFinalViewerSize(Dimension size) {
            Dimension sizeWithScaleCorrection = this.fitToMaximumSize(size);
            this.setRenderingTransform(this.initialTransform);
            this.setPreferredSize(sizeWithScaleCorrection);
            this.setMySize(sizeWithScaleCorrection);
            this.setSize(sizeWithScaleCorrection);
        }

        private Dimension fitToMaximumSize(Dimension size) {
            if (this.maximumSize == null || this.isUnderMaximumSize(size)) {
                return size;
            }
            return this.maximumSize;
        }

        private boolean isUnderMaximumSize(Dimension size) {
            return this.maximumSize.getWidth() >= (double)size.width || this.maximumSize.getHeight() >= (double)size.height;
        }

        public void setDraftViewerSize(Dimension size) {
            this.setFinalViewerSize(size);
        }

        public void setFinalViewerSize(float zoom) {
            if (this.originalSize != null) {
                int scaledWidth = (int)((float)this.originalSize.width * zoom);
                int scaledHeight = (int)((float)this.originalSize.height * zoom);
                this.setFinalViewerSize(new Dimension(scaledWidth, scaledHeight));
            }
        }

        public ViewerComponent(URI uri) {
            super(null, false, false);
            this.originalSize = null;
            this.maximumSize = null;
            this.setDocumentState(2);
            this.setSize(1, 1);
            this.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

                public void gvtRenderingStarted(GVTTreeRendererEvent e) {
                    super.gvtRenderingStarted(e);
                    SVGDocument document = ViewerComponent.this.getSVGDocument();
                    SVGSVGElement rootElement = document.getRootElement();
                    SVGLength width = rootElement.getWidth().getBaseVal();
                    SVGLength height = rootElement.getHeight().getBaseVal();
                    float defaultWidth = (float)Math.ceil(width.getValue());
                    float defaultHeigth = (float)Math.ceil(height.getValue());
                    if (defaultWidth == 1.0f && defaultHeigth == 1.0f) {
                        defaultWidth = ResourceController.getResourceController().getIntProperty("default_external_component_width", 200);
                        defaultHeigth = ResourceController.getResourceController().getIntProperty("default_external_component_height", 200);
                    }
                    ViewerComponent.this.originalSize = new Dimension((int)defaultWidth, (int)defaultHeigth);
                    if ("".equals(rootElement.getAttributeNS(null, "viewBox"))) {
                        rootElement.setAttributeNS(null, "viewBox", "0 0 " + defaultWidth + " " + defaultHeigth);
                    }
                    ViewerComponent.this.removeGVTTreeRendererListener((GVTTreeRendererListener)this);
                }
            });
            this.setURI(uri.toString());
        }

        public Dimension getPreferredSize() {
            if (this.originalSize == null) {
                return new Dimension(1, 1);
            }
            return super.getPreferredSize();
        }

        public void setMaximumComponentSize(Dimension size) {
            this.maximumSize = size;
        }

        public void setCenter(boolean center) {
        }

        public void setImageLoadingListener(final ImageLoadingListener listener) {
            this.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

                public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                    listener.imageLoaded();
                }
            });
        }
    }
}

