/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources;

import java.awt.event.ActionEvent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.util.TextUtils;

@SelectableAction(checkOnPopup=true)
public class SetBooleanPropertyAction
extends AFreeplaneAction {
    private String propertyName;

    public SetBooleanPropertyAction(String propertyName) {
        super("SetBooleanPropertyAction." + propertyName, TextUtils.getRawText("OptionPanel." + propertyName), null);
        this.propertyName = propertyName;
        this.setTooltip(this.getTooltipKey());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ResourceController.getResourceController().setProperty(this.propertyName, !this.isPropertySet());
    }

    @Override
    public String getTextKey() {
        return "OptionPanel." + this.propertyName;
    }

    @Override
    public String getTooltipKey() {
        return this.getTextKey() + ".tooltip";
    }

    @Override
    public void setSelected() {
        this.setSelected(this.isPropertySet());
    }

    public boolean isPropertySet() {
        return ResourceController.getResourceController().getBooleanProperty(this.propertyName);
    }
}

