/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.freeplane.core.ui.textchanger.TranslatedElement;
import org.freeplane.core.util.TextUtils;

public class PropertyAdapter {
    private String tooltip;
    private String label;
    private final String name;

    public PropertyAdapter(String name) {
        this(name, "OptionPanel." + name, "OptionPanel." + name + ".tooltip");
    }

    public PropertyAdapter(String name, String label, String tooltip) {
        assert (name != null);
        this.name = name;
        this.label = label;
        this.tooltip = tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getLabel() {
        return this.label;
    }

    void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    protected void layout(DefaultFormBuilder builder, JComponent component) {
        String labelKey = this.getLabel();
        String optionalText = TextUtils.getOptionalText(labelKey);
        JLabel label = builder.append(optionalText, (Component)component);
        if (optionalText != null) {
            TranslatedElement.TEXT.setKey(label, labelKey);
        }
        String tooltipKey = this.getTooltip();
        String tooltip = TextUtils.getOptionalText(tooltipKey, null);
        if (tooltipKey != null) {
            TranslatedElement.TOOLTIP.setKey(label, tooltipKey);
        }
        label.setToolTipText(tooltip);
        component.setToolTipText(tooltip);
    }
}

