/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.IFreeplaneAction;
import org.freeplane.core.ui.components.IKeyBindingManager;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;

public class AccelerateableAction
implements IFreeplaneAction {
    private final AFreeplaneAction originalAction;
    private static JDialog setAcceleratorOnNextClickActionDialog;
    private static KeyStroke acceleratorForNextClickedAction;
    private static final String SET_ACCELERATOR_ON_NEXT_CLICK_ACTION = "set_accelerator_on_next_click_action";

    public static boolean isNewAcceleratorOnNextClickEnabled() {
        return setAcceleratorOnNextClickActionDialog != null;
    }

    static void setNewAcceleratorOnNextClick(KeyStroke accelerator) {
        if (AccelerateableAction.isNewAcceleratorOnNextClickEnabled()) {
            return;
        }
        acceleratorForNextClickedAction = accelerator;
        String title = TextUtils.getText("SetAccelerator.dialogTitle");
        String text = TextUtils.getText(SET_ACCELERATOR_ON_NEXT_CLICK_ACTION);
        if (accelerator != null) {
            text = TextUtils.format("SetAccelerator.keystrokeDetected", AccelerateableAction.toString(accelerator)) + "\n" + text;
        }
        Component frame = Controller.getCurrentController().getViewController().getMenuComponent();
        setAcceleratorOnNextClickActionDialog = UITools.createCancelDialog(frame, title, text);
        AccelerateableAction.getAcceleratorOnNextClickActionDialog().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                setAcceleratorOnNextClickActionDialog = null;
                acceleratorForNextClickedAction = null;
            }
        });
        AccelerateableAction.getAcceleratorOnNextClickActionDialog().setVisible(true);
    }

    public AccelerateableAction(AFreeplaneAction originalAction) {
        this.originalAction = originalAction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean newAcceleratorOnNextClickEnabled = AccelerateableAction.isNewAcceleratorOnNextClickEnabled();
        KeyStroke newAccelerator = acceleratorForNextClickedAction;
        if (newAcceleratorOnNextClickEnabled) {
            AccelerateableAction.getAcceleratorOnNextClickActionDialog().setVisible(false);
        }
        Object source = e.getSource();
        if (!(!newAcceleratorOnNextClickEnabled && 0 == (e.getModifiers() & 2) || source instanceof IKeyBindingManager && ((IKeyBindingManager)source).isKeyBindingProcessed())) {
            this.getAcceleratorManager().newAccelerator(this.getOriginalAction(), newAccelerator);
            return;
        }
        this.originalAction.actionPerformed(e);
    }

    public static JDialog getAcceleratorOnNextClickActionDialog() {
        return setAcceleratorOnNextClickActionDialog;
    }

    public static KeyStroke getAcceleratorForNextClick() {
        return acceleratorForNextClickedAction;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.originalAction.addPropertyChangeListener(listener);
    }

    @Override
    public void afterMapChange(Object newMap) {
        this.originalAction.afterMapChange(newMap);
    }

    @Override
    public Object getValue(String key) {
        return this.originalAction.getValue(key);
    }

    @Override
    public boolean isEnabled() {
        return this.originalAction.isEnabled();
    }

    @Override
    public boolean isSelected() {
        return this.originalAction.isSelected();
    }

    @Override
    public void setSelected(boolean newValue) {
        this.originalAction.setSelected(newValue);
    }

    public AFreeplaneAction getOriginalAction() {
        return this.originalAction;
    }

    private static String toString(KeyStroke newAccelerator) {
        return newAccelerator.toString().replaceFirst("pressed ", "");
    }

    @Override
    public void putValue(String key, Object value) {
        this.originalAction.putValue(key, value);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.originalAction.removePropertyChangeListener(listener);
    }

    @Override
    public void setEnabled(boolean b) {
        this.originalAction.setEnabled(b);
    }

    @Override
    public String getIconKey() {
        return this.originalAction.getIconKey();
    }

    private ActionAcceleratorManager getAcceleratorManager() {
        return ResourceController.getResourceController().getAcceleratorManager();
    }
}

