/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.event.KeyEvent;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.freeplane.core.ui.IKeyStrokeProcessor;

public class FreeplaneMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private final IKeyStrokeProcessor keyEventProcessor;
    static final int KEY_MODIFIERS = 8289;

    public FreeplaneMenuBar(IKeyStrokeProcessor keyEventProcessor) {
        this.keyEventProcessor = keyEventProcessor;
        this.getInputMap(2).put(KeyStroke.getKeyStroke(121, 0), "none");
    }

    public static KeyStroke derive(KeyStroke ks, Character keyChar) {
        if (ks == null) {
            return ks;
        }
        int modifiers = ks.getModifiers();
        if (ks.getKeyChar() == '\uffff') {
            if (0 != (modifiers & 0x2061)) {
                switch (keyChar.charValue()) {
                    case '<': {
                        return KeyStroke.getKeyStroke(153, modifiers & 0xFFFFDF9E, ks.isOnKeyRelease());
                    }
                    case '>': {
                        return KeyStroke.getKeyStroke(160, modifiers & 0xFFFFDF9E, ks.isOnKeyRelease());
                    }
                    case '+': {
                        return KeyStroke.getKeyStroke(521, modifiers & 0xFFFFDF9E, ks.isOnKeyRelease());
                    }
                    case '-': {
                        return KeyStroke.getKeyStroke(45, modifiers & 0xFFFFDF9E, ks.isOnKeyRelease());
                    }
                    case '=': {
                        return KeyStroke.getKeyStroke(61, modifiers & 0xFFFFDF9E, ks.isOnKeyRelease());
                    }
                    case '.': {
                        return KeyStroke.getKeyStroke(46, modifiers & 0xFFFFDF9E, ks.isOnKeyRelease());
                    }
                }
            }
            if (keyChar.charValue() != '\u0000' && keyChar.charValue() != '\uffff') {
                return KeyStroke.getKeyStroke(keyChar, modifiers);
            }
        }
        return ks;
    }

    @Override
    public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyChar() != '\uffff' && e.getKeyChar() != '\u0000' && e.getKeyChar() != '\u001b' && 0 == (e.getModifiers() & 0xFFFFDF9E) && e.getSource() instanceof JTextComponent) {
            return false;
        }
        if (this.keyEventProcessor.processKeyBinding(ks, e) || super.processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        KeyStroke derivedKS = FreeplaneMenuBar.derive(ks, Character.valueOf(e.getKeyChar()));
        if (derivedKS == ks) {
            return false;
        }
        return super.processKeyBinding(derivedKS, e, condition, pressed);
    }
}

