/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IIconInformation;

public class IconSelectionPopupDialog
extends JDialog
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private final JLabel descriptionLabel;
    private final JLabel[] iconLabels;
    private final JPanel iconPanel = new JPanel();
    private final List<? extends IIconInformation> icons;
    private int mModifiers;
    private final int numOfIcons;
    private int result;
    private Position selected = new Position(0, 0);
    private final int xDimension;
    private int yDimension;

    public IconSelectionPopupDialog(Frame frame, List<? extends IIconInformation> icons) {
        super(frame, TextUtils.getText("select_icon"));
        this.getContentPane().setLayout(new BorderLayout());
        this.icons = icons;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                IconSelectionPopupDialog.this.close();
            }
        });
        this.numOfIcons = icons.size();
        this.xDimension = (int)Math.ceil(Math.sqrt(this.numOfIcons));
        this.yDimension = this.numOfIcons <= this.xDimension * (this.xDimension - 1) ? this.xDimension - 1 : this.xDimension;
        GridLayout gridlayout = new GridLayout(0, this.xDimension);
        gridlayout.setHgap(3);
        gridlayout.setVgap(3);
        this.iconPanel.setLayout(gridlayout);
        this.iconLabels = new JLabel[this.numOfIcons];
        for (int i = 0; i < this.numOfIcons; ++i) {
            IIconInformation icon = icons.get(i);
            this.iconLabels[i] = new JLabel(icon.getIcon());
            this.iconPanel.add(this.iconLabels[i]);
            this.iconLabels[i].setBorder(BorderFactory.createBevelBorder(0));
            this.iconLabels[i].addMouseListener(this);
        }
        int perIconSize = 27;
        this.iconPanel.setPreferredSize(new Dimension(this.xDimension * 27, this.yDimension * 27));
        this.iconPanel.setMinimumSize(new Dimension(this.xDimension * 27, this.yDimension * 27));
        this.iconPanel.setMaximumSize(new Dimension(this.xDimension * 27, this.yDimension * 27));
        this.iconPanel.setSize(new Dimension(this.xDimension * 27, this.yDimension * 27));
        this.getContentPane().add((Component)this.iconPanel, "Center");
        this.descriptionLabel = new JLabel(" ");
        this.getContentPane().add((Component)this.descriptionLabel, "South");
        this.setSelectedPosition(new Position(0, 0));
        this.select(this.getSelectedPosition());
        this.addKeyListener(this);
        this.pack();
    }

    private void addIcon(int pModifiers) {
        this.result = this.calculateIndex(this.getSelectedPosition());
        this.mModifiers = pModifiers;
        this.dispose();
    }

    private int calculateIndex(Position position) {
        return position.getY() * this.xDimension + position.getX();
    }

    private boolean canSelect(Position position) {
        return position.getX() >= 0 && position.getX() < this.xDimension && position.getY() >= 0 && position.getY() < this.yDimension && this.calculateIndex(position) < this.numOfIcons;
    }

    private void close() {
        this.result = -1;
        this.mModifiers = 0;
        this.dispose();
    }

    private void cursorDown() {
        Position newPosition = new Position(this.getSelectedPosition().getX(), this.getSelectedPosition().getY() + 1);
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void cursorLeft() {
        Position newPosition = new Position(this.getSelectedPosition().getX() - 1, this.getSelectedPosition().getY());
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void cursorRight() {
        Position newPosition = new Position(this.getSelectedPosition().getX() + 1, this.getSelectedPosition().getY());
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void cursorUp() {
        Position newPosition = new Position(this.getSelectedPosition().getX(), this.getSelectedPosition().getY() - 1);
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private int findIndexByKeyEvent(KeyEvent keyEvent) {
        for (int i = 0; i < this.icons.size(); ++i) {
            IIconInformation info = this.icons.get(i);
            KeyStroke iconKeyStroke = info.getKeyStroke();
            if (iconKeyStroke == null || (keyEvent.getKeyCode() != iconKeyStroke.getKeyCode() || keyEvent.getKeyCode() == 0 || (iconKeyStroke.getModifiers() & 1) != (keyEvent.getModifiers() & 1)) && keyEvent.getKeyChar() != iconKeyStroke.getKeyChar() || keyEvent.getKeyChar() == '\u0000' || keyEvent.getKeyChar() == '\uffff') continue;
            return i;
        }
        return -1;
    }

    public int getModifiers() {
        int m = this.mModifiers;
        if ((this.mModifiers & 0x41) != 0) {
            m |= 1;
        }
        if ((this.mModifiers & 0x82) != 0) {
            m |= 2;
        }
        if ((this.mModifiers & 0x104) != 0) {
            m |= 4;
        }
        if ((this.mModifiers & 0x208) != 0) {
            m |= 8;
        }
        return m;
    }

    private Position getPosition(JLabel caller) {
        int index = 0;
        for (index = 0; index < this.iconLabels.length && caller != this.iconLabels[index]; ++index) {
        }
        return new Position(index % this.xDimension, index / this.xDimension);
    }

    public int getResult() {
        return this.result;
    }

    private Position getSelectedPosition() {
        return this.selected;
    }

    private void highlight(Position position) {
        this.iconLabels[this.calculateIndex(position)].setBorder(BorderFactory.createBevelBorder(1));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: 
            case 227: {
                this.cursorRight();
                return;
            }
            case 37: 
            case 226: {
                this.cursorLeft();
                return;
            }
            case 40: 
            case 225: {
                this.cursorDown();
                return;
            }
            case 38: 
            case 224: {
                this.cursorUp();
                return;
            }
            case 27: {
                keyEvent.consume();
                this.close();
                return;
            }
            case 10: 
            case 32: {
                keyEvent.consume();
                this.addIcon(keyEvent.getModifiers());
                return;
            }
        }
        int index = this.findIndexByKeyEvent(keyEvent);
        if (index != -1) {
            this.result = index;
            this.mModifiers = keyEvent.getModifiers();
            keyEvent.consume();
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.addIcon(mouseEvent.getModifiers());
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.select(this.getPosition((JLabel)arg0.getSource()));
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private void select(Position position) {
        this.unhighlight(this.getSelectedPosition());
        this.setSelectedPosition(position);
        this.highlight(position);
        int index = this.calculateIndex(position);
        IIconInformation iconInformation = this.icons.get(index);
        String keyStroke = ResourceController.getResourceController().getProperty(iconInformation.getShortcutKey());
        if (keyStroke != null) {
            this.descriptionLabel.setText(iconInformation.getTranslationValueLabel() + ", " + keyStroke);
        } else {
            this.descriptionLabel.setText(iconInformation.getTranslationValueLabel());
        }
    }

    private void setSelectedPosition(Position position) {
        this.selected = position;
    }

    private void unhighlight(Position position) {
        this.iconLabels[this.calculateIndex(position)].setBorder(BorderFactory.createBevelBorder(0));
    }

    static class Position {
        private final int x;
        private final int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "(" + this.getX() + "," + this.getY() + ")";
        }
    }
}

