/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class Filter {
    private final boolean appliesToVisibleNodesOnly;
    private final ICondition condition;
    private final int options;
    private static Icon filterIcon;

    static Filter createTransparentFilter() {
        ResourceController resourceController = ResourceController.getResourceController();
        return new Filter(null, resourceController.getBooleanProperty("filter.showAncestors"), resourceController.getBooleanProperty("filter.showDescendants"), false);
    }

    public Filter(ICondition condition, boolean areAncestorsShown, boolean areDescendantsShown, boolean applyToVisibleNodesOnly) {
        this.condition = condition;
        int options = 3;
        if (areAncestorsShown) {
            options += 4;
        }
        options += 16;
        if (areDescendantsShown) {
            options += 8;
        }
        this.options = options;
        this.appliesToVisibleNodesOnly = condition != null && applyToVisibleNodesOnly;
    }

    void addFilterResult(NodeModel node, int flag) {
        node.getFilterInfo().add(flag);
    }

    protected boolean appliesToVisibleNodesOnly() {
        return this.appliesToVisibleNodesOnly;
    }

    void displayFilterStatus() {
        if (filterIcon == null) {
            filterIcon = new ImageIcon(ResourceController.getResourceController().getResource("/images/filter.png"));
        }
        if (this.getCondition() != null) {
            Controller.getCurrentController().getViewController().addStatusInfo("filter", null, filterIcon);
        } else {
            Controller.getCurrentController().getViewController().removeStatus("filter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFilter(Object source, MapModel map, boolean force) {
        if (map == null) {
            return;
        }
        try {
            this.displayFilterStatus();
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            Filter oldFilter = map.getFilter();
            map.setFilter(this);
            if (force || !this.isConditionStronger(oldFilter)) {
                NodeModel root = map.getRootNode();
                this.resetFilter(root);
                if (this.filterChildren(root, this.checkNode(root), false)) {
                    this.addFilterResult(root, 4);
                }
            }
            IMapSelection selection = Controller.getCurrentController().getSelection();
            NodeModel selected = selection.getSelected();
            NodeModel selectedVisible = selected.getVisibleAncestorOrSelf();
            selection.keepNodePosition(selectedVisible, 0.5f, 0.5f);
            this.refreshMap(source, map);
            this.selectVisibleNode();
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    private boolean applyFilter(NodeModel node, boolean isAncestorSelected, boolean isAncestorEclipsed, boolean isDescendantSelected) {
        boolean conditionSatisfied = this.checkNode(node);
        this.resetFilter(node);
        if (isAncestorSelected) {
            this.addFilterResult(node, 8);
        }
        if (conditionSatisfied) {
            isDescendantSelected = true;
            this.addFilterResult(node, 2);
        } else {
            this.addFilterResult(node, 32);
        }
        if (isAncestorEclipsed) {
            this.addFilterResult(node, 16);
        }
        if (this.filterChildren(node, conditionSatisfied || isAncestorSelected, !conditionSatisfied || isAncestorEclipsed)) {
            this.addFilterResult(node, 4);
            isDescendantSelected = true;
        }
        return isDescendantSelected;
    }

    public boolean areAncestorsShown() {
        return 0 != (this.options & 4);
    }

    public boolean areDescendantsShown() {
        return 0 != (this.options & 8);
    }

    private boolean checkNode(NodeModel node) {
        if (this.condition == null) {
            return true;
        }
        if (this.appliesToVisibleNodesOnly && !node.hasVisibleContent()) {
            return false;
        }
        return this.condition.checkNode(node);
    }

    private boolean filterChildren(NodeModel node, boolean isAncestorSelected, boolean isAncestorEclipsed) {
        boolean isDescendantSelected = false;
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            isDescendantSelected = this.applyFilter(child, isAncestorSelected, isAncestorEclipsed, isDescendantSelected);
        }
        return isDescendantSelected;
    }

    public ICondition getCondition() {
        return this.condition;
    }

    public boolean isConditionStronger(Filter oldFilter) {
        return (!this.appliesToVisibleNodesOnly || this.appliesToVisibleNodesOnly == oldFilter.appliesToVisibleNodesOnly) && (this.condition != null && this.condition.equals(oldFilter.getCondition()) || this.condition == null && oldFilter.getCondition() == null);
    }

    public boolean isVisible(NodeModel node) {
        if (this.condition == null) {
            return true;
        }
        int filterResult = node.getFilterInfo().get();
        return ((this.options & 4) != 0 || (this.options & 0x10) >= (filterResult & 0x10)) && (this.options & filterResult & 0xFFFFFFEF) != 0;
    }

    private void refreshMap(Object source, MapModel map) {
        Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent(source, map, Filter.class, null, this));
    }

    private void resetFilter(NodeModel node) {
        node.getFilterInfo().reset();
    }

    private void selectVisibleNode() {
        IMapSelection mapSelection = Controller.getCurrentController().getSelection();
        Set<NodeModel> selectedNodes = mapSelection.getSelection();
        NodeModel[] array = new NodeModel[selectedNodes.size()];
        boolean next = false;
        for (NodeModel node : selectedNodes.toArray(array)) {
            if (next) {
                if (node.hasVisibleContent()) continue;
                mapSelection.toggleSelected(node);
                continue;
            }
            next = true;
        }
        NodeModel selected = mapSelection.getSelected();
        if (!selected.hasVisibleContent()) {
            if (mapSelection.getSelection().size() > 1) {
                mapSelection.toggleSelected(selected);
            } else {
                mapSelection.selectAsTheOnlyOneSelected(selected.getVisibleAncestorOrSelf());
            }
        }
        mapSelection.setSiblingMaxLevel(mapSelection.getSelected().getNodeLevel(false));
    }

    public boolean matches(NodeModel nodeModel) {
        return 0 != (nodeModel.getFilterInfo().get() & 2);
    }
}

