/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.format;

import java.text.DecimalFormat;
import org.freeplane.core.util.FactoryMethod;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.SerializationMethod;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.IFormattedObject;

@FactoryMethod(value="deserialize")
@SerializationMethod(value="serialize")
public class FormattedNumber
extends Number
implements IFormattedObject,
Comparable<Number> {
    private final Number number;
    private final String pattern;
    private final String formattedString;
    private final boolean isDefaultFormat;

    public FormattedNumber(Number number) {
        this(number, FormatController.getController().getDefaultNumberFormat());
    }

    public FormattedNumber(Number number, String pattern) {
        this(number, pattern, number == null ? null : FormatController.getController().getDecimalFormat(pattern).format(number));
    }

    public FormattedNumber(Number number, String pattern, String formattedString) {
        this(number, pattern, formattedString, false);
    }

    private FormattedNumber(Number number, DecimalFormat format) {
        this(number, format, true);
    }

    private FormattedNumber(Number number, DecimalFormat format, boolean isDefault) {
        this(number, format.toPattern(), number == null ? null : format.format(number), isDefault);
    }

    private FormattedNumber(Number number, String pattern, String formattedString, boolean isDefault) {
        long longValue = number.longValue();
        this.number = (double)longValue == number.doubleValue() ? (Number)longValue : (Number)number;
        this.pattern = pattern;
        this.formattedString = formattedString;
        this.isDefaultFormat = isDefault;
    }

    public Number getNumber() {
        return this.number;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public Object getObject() {
        return this.number;
    }

    public static String serialize(FormattedNumber formattedNumber) {
        return formattedNumber.number + (formattedNumber.isDefaultFormat ? "" : "|" + formattedNumber.pattern);
    }

    public static Object deserialize(String text) {
        try {
            int index = text.indexOf(124);
            if (index == -1) {
                return new FormattedNumber(Double.parseDouble(text));
            }
            return new FormattedNumber((Number)Double.parseDouble(text.substring(0, index)), text.substring(index + 1));
        }
        catch (Exception e) {
            LogUtils.warn("cannot deserialize " + text, e);
            return text;
        }
    }

    public String toString() {
        return this.formattedString;
    }

    @Override
    public int intValue() {
        return this.number.intValue();
    }

    @Override
    public long longValue() {
        return this.number.longValue();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FormattedNumber other = (FormattedNumber)obj;
        if (this.number == null ? other.number != null : !this.number.equals(other.number)) {
            return false;
        }
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }

    @Override
    public int compareTo(Number that) {
        if (this.number != null && that != null) {
            return Double.compare(this.number.doubleValue(), that.doubleValue());
        }
        return (this.number == null ? 0 : 1) - (that == null ? 0 : 1);
    }
}

