/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.net.URI;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class HyperLinkCondition
extends ASelectableCondition {
    static final String TEXT = "TEXT";
    private final String hyperlink;

    public HyperLinkCondition(String hyperlink) {
        this.hyperlink = hyperlink;
    }

    protected abstract boolean checkLink(URI var1);

    @Override
    public boolean checkNode(NodeModel node) {
        URI nodeLink = NodeLinks.getValidLink(node);
        if (nodeLink != null && this.checkLink(nodeLink)) {
            return true;
        }
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        if (attributes == null) {
            return false;
        }
        int rowCount = attributes.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Attribute attribute = attributes.getAttribute(i);
            Object value = attribute.getValue();
            if (!(value instanceof URI) || !this.checkLink((URI)value)) continue;
            return true;
        }
        return false;
    }

    public String getHyperlink() {
        return this.hyperlink;
    }

    @Override
    protected void fillXML(XMLElement element) {
        element.setAttribute(TEXT, this.hyperlink);
    }
}

