/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.net.URI;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.link.HyperLinkCondition;
import org.freeplane.n3.nanoxml.XMLElement;

public class HyperLinkEqualsCondition
extends HyperLinkCondition {
    public static final String NAME = "hyper_link_equals";
    public static final String MATCH_CASE = "MATCH_CASE";
    public static final String MATCH_APPROXIMATELY = "MATCH_APPROXIMATELY";
    private final boolean matchCase;
    private final boolean matchApproximately;
    private final StringMatchingStrategy stringMatchingStrategy;

    public HyperLinkEqualsCondition(String hyperlink, boolean matchCase, boolean matchApproximately) {
        super(hyperlink);
        this.matchCase = matchCase;
        this.matchApproximately = matchApproximately;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    protected boolean checkLink(URI nodeLink) {
        return this.stringMatchingStrategy.matches(this.getHyperlink(), nodeLink.toString(), false, this.matchCase);
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("filter_link");
        String simpleCondition = TextUtils.getText("filter_is_equal_to");
        return ConditionFactory.createDescription(condition, simpleCondition, this.getHyperlink(), this.matchCase, this.matchApproximately);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(MATCH_CASE, Boolean.toString(this.matchCase));
        child.setAttribute(MATCH_APPROXIMATELY, Boolean.toString(this.matchApproximately));
    }
}

