/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.link.LinkBuilder;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SharedNodeData;
import org.freeplane.n3.nanoxml.XMLElement;

public class NodeWriter
implements IElementWriter,
IAttributeWriter {
    private boolean mayWriteChildren;
    private final MapController mapController;
    private final boolean shouldWriteChildren;
    private final boolean writeFolded;
    private final boolean writeInvisible;
    private XMLElement xmlNode;
    private final String nodeTag;
    private final Map<SharedNodeData, NodeModel> alreadyWrittenSharedContent;
    private final LinkBuilder linkBuilder;

    public static boolean shouldWriteSharedContent(ITreeWriter writer) {
        if (!Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.ALREADY_WRITTEN))) {
            return true;
        }
        Object mode = writer.getHint((Object)MapWriter.Hint.MODE);
        return MapWriter.Mode.EXPORT.equals(mode);
    }

    public NodeWriter(MapController mapController, LinkBuilder linkBuilder, String nodeTag, boolean writeChildren, boolean writeInvisible) {
        this.linkBuilder = linkBuilder;
        this.alreadyWrittenSharedContent = new HashMap<SharedNodeData, NodeModel>();
        this.mapController = mapController;
        this.shouldWriteChildren = writeChildren;
        this.mayWriteChildren = true;
        this.writeInvisible = writeInvisible;
        this.nodeTag = nodeTag;
        String saveFolding = ResourceController.getResourceController().getProperty("save_folding");
        this.writeFolded = saveFolding.equals("always_save_folding") || saveFolding.equals("save_folding_if_map_is_changed");
    }

    private void saveChildren(ITreeWriter writer, NodeModel node) throws IOException {
        for (NodeModel child : this.mapController.childrenUnfolded(node)) {
            if (this.writeInvisible || child.isVisible()) {
                writer.setHint((Object)MapWriter.WriterHint.ALREADY_WRITTEN, this.isAlreadyWritten(child));
                writer.addElement((Object)child, this.nodeTag);
                continue;
            }
            this.saveChildren(writer, child);
        }
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object content, String tag) {
        if (tag.equals(this.nodeTag)) {
            NodeModel node = (NodeModel)content;
            this.writeAttributesGenerateContent(writer, node);
            return;
        }
    }

    private void writeAttributesGenerateContent(ITreeWriter writer, NodeModel node) {
        boolean saveID;
        NodeModel parentNode;
        String enctyptedContent;
        this.xmlNode = new XMLElement();
        EncryptionModel encryptionModel = EncryptionModel.getModel(node);
        this.mayWriteChildren = true;
        Object mode = this.mode(writer);
        boolean isNodeAlreadyWritten = this.isAlreadyWritten(node);
        if (!(encryptionModel == null || encryptionModel.isAccessible() && MapWriter.Mode.EXPORT.equals(mode) || isNodeAlreadyWritten || (enctyptedContent = encryptionModel.calculateEncryptedContent(this.mapController)) == null)) {
            writer.addAttribute("ENCRYPTED_CONTENT", enctyptedContent);
            this.mayWriteChildren = false;
        }
        if (this.mayWriteChildren && (this.writeFolded || !this.mode(writer).equals((Object)MapWriter.Mode.FILE))) {
            if (this.mapController.isFolded(node) && !isNodeAlreadyWritten) {
                writer.addAttribute("FOLDED", "true");
            } else if (node.isRoot() && !MapWriter.Mode.STYLE.equals(mode)) {
                writer.addAttribute("FOLDED", "false");
            }
        }
        if ((parentNode = node.getParentNode()) != null && parentNode.isRoot()) {
            writer.addAttribute("POSITION", node.isLeft() ? "left" : "right");
        }
        boolean bl = saveID = !mode.equals((Object)MapWriter.Mode.STYLE);
        if (saveID) {
            String id = node.createID();
            writer.addAttribute("ID", id);
            this.writeReferenceNodeId(writer, node);
        }
        if (!isNodeAlreadyWritten && !mode.equals((Object)MapWriter.Mode.STYLE) && node.getHistoryInformation() != null && ResourceController.getResourceController().getBooleanProperty("save_modification_times")) {
            writer.addAttribute("CREATED", TreeXmlWriter.dateToString(node.getHistoryInformation().getCreatedAt()));
            writer.addAttribute("MODIFIED", TreeXmlWriter.dateToString(node.getHistoryInformation().getLastModifiedAt()));
        }
        if (!isNodeAlreadyWritten || MapWriter.Mode.EXPORT.equals(mode)) {
            this.linkBuilder.writeAttributes(writer, node);
            writer.addExtensionAttributes(node, node.getSharedExtensions().values());
        }
        writer.addExtensionAttributes(node, node.getIndividualExtensionValues());
    }

    private void writeReferenceNodeId(ITreeWriter writer, NodeModel node) {
        NodeModel referenceNode = this.alreadyWrittenSharedContent.get(node.getSharedData());
        if (referenceNode != null) {
            if (referenceNode.isSubtreeCloneOf(node)) {
                writer.addAttribute("TREE_ID", referenceNode.createID());
            } else {
                writer.addAttribute("CONTENT_ID", referenceNode.createID());
            }
        }
    }

    private boolean isAlreadyWritten(NodeModel node) {
        return this.alreadyWrittenSharedContent.containsKey(node.getSharedData());
    }

    private void registerWrittenNode(NodeModel node) {
        this.alreadyWrittenSharedContent.put(node.getSharedData(), node);
    }

    @Override
    public void writeContent(ITreeWriter writer, Object content, String tag) throws IOException {
        boolean isNodeContentWrittenFirstTime;
        NodeModel node = (NodeModel)content;
        writer.addExtensionNodes(node, node.getIndividualExtensionValues());
        boolean bl = isNodeContentWrittenFirstTime = !this.isAlreadyWritten(node);
        if (isNodeContentWrittenFirstTime) {
            this.registerWrittenNode(node);
        }
        this.linkBuilder.writeContent(writer, node);
        if (isNodeContentWrittenFirstTime || MapWriter.Mode.EXPORT.equals(this.mode(writer))) {
            writer.addExtensionNodes(node, node.getSharedExtensions().values());
            for (int i = 0; i < this.xmlNode.getChildrenCount(); ++i) {
                writer.addElement(null, this.xmlNode.getChildAtIndex(i));
            }
        }
        if (this.mayWriteChildren && this.shouldWriteChildren && this.mapController.childrenUnfolded(node).size() > 0) {
            this.saveChildren(writer, node);
        }
    }

    private Object mode(ITreeWriter writer) {
        return writer.getHint((Object)MapWriter.Hint.MODE);
    }

    String getNodeTag() {
        return this.nodeTag;
    }

    void registerBy(WriteManager writeManager) {
        writeManager.addElementWriter(this.getNodeTag(), this);
        writeManager.addAttributeWriter(this.getNodeTag(), this);
    }

    void unregisterFrom(WriteManager writeManager) {
        writeManager.removeElementWriter(this.getNodeTag(), this);
        writeManager.removeAttributeWriter(this.getNodeTag(), this);
    }
}

