/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.NodeModel;

public class LocationModel
implements IExtension {
    public static final Quantity<LengthUnits> DEFAULT_HGAP = new Quantity<LengthUnits>(14.0, LengthUnits.pt);
    public static final int DEFAULT_HGAP_PX = DEFAULT_HGAP.toBaseUnitsRounded();
    public static Quantity<LengthUnits> DEFAULT_SHIFT_Y = new Quantity<LengthUnits>(0.0, LengthUnits.pt);
    public static Quantity<LengthUnits> DEFAULT_VGAP = new Quantity<LengthUnits>(2.0, LengthUnits.pt);
    public static final LocationModel NULL_LOCATION = new LocationModel(){

        @Override
        public void setHGap(Quantity<LengthUnits> gap) {
            if (gap != this.getHGap()) {
                throw new NoSuchMethodError();
            }
        }

        @Override
        public void setShiftY(Quantity<LengthUnits> shiftY) {
            if (shiftY != this.getShiftY()) {
                throw new NoSuchMethodError();
            }
        }

        @Override
        public void setVGap(Quantity<LengthUnits> gap) {
            if (gap != this.getVGap()) {
                throw new NoSuchMethodError();
            }
        }
    };
    private Quantity<LengthUnits> hGap = DEFAULT_HGAP;
    private Quantity<LengthUnits> shiftY = DEFAULT_SHIFT_Y;
    private Quantity<LengthUnits> vGap = DEFAULT_VGAP;

    public static LocationModel createLocationModel(NodeModel node) {
        LocationModel location = node.getExtension(LocationModel.class);
        if (location == null) {
            location = new LocationModel();
            node.addExtension(location);
        }
        return location;
    }

    public static LocationModel getModel(NodeModel node) {
        LocationModel location = node.getExtension(LocationModel.class);
        return location != null ? location : NULL_LOCATION;
    }

    public Quantity<LengthUnits> getHGap() {
        return this.hGap;
    }

    public Quantity<LengthUnits> getShiftY() {
        return this.shiftY;
    }

    public Quantity<LengthUnits> getVGap() {
        return this.vGap;
    }

    public void setHGap(Quantity<LengthUnits> gap) {
        this.assertNotNull(gap);
        this.hGap = gap;
    }

    private void assertNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public void setShiftY(Quantity<LengthUnits> shiftY) {
        this.assertNotNull(shiftY);
        this.shiftY = shiftY;
    }

    public void setVGap(Quantity<LengthUnits> gap) {
        this.assertNotNull(gap);
        this.vGap = gap.toBaseUnits() >= 0.0 ? gap : new Quantity(0.0, gap.unit);
    }
}

