/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.NodeModel;

public class NodeSizeModel
implements IExtension {
    private Quantity<LengthUnits> minNodeWidth = null;
    private Quantity<LengthUnits> maxTextWidth = null;

    public static NodeSizeModel getModel(NodeModel node) {
        return node.getExtension(NodeSizeModel.class);
    }

    public static NodeSizeModel createNodeSizeModel(NodeModel node) {
        NodeSizeModel styleModel = node.getExtension(NodeSizeModel.class);
        if (styleModel == null) {
            styleModel = new NodeSizeModel();
            node.addExtension(styleModel);
        }
        return styleModel;
    }

    public Quantity<LengthUnits> getMaxNodeWidth() {
        return this.maxTextWidth;
    }

    public void setMaxNodeWidth(Quantity<LengthUnits> maxTextWidth) {
        this.maxTextWidth = maxTextWidth;
    }

    public Quantity<LengthUnits> getMinNodeWidth() {
        return this.minNodeWidth;
    }

    public void setMinNodeWidth(Quantity<LengthUnits> quantity) {
        this.minNodeWidth = quantity;
    }

    public static void setMaxNodeWidth(NodeModel node, Quantity<LengthUnits> maxTextWidth) {
        NodeSizeModel.createNodeSizeModel(node).setMaxNodeWidth(maxTextWidth);
    }

    public static void setNodeMinWidth(NodeModel node, Quantity<LengthUnits> minNodeWidth) {
        NodeSizeModel.createNodeSizeModel(node).setMinNodeWidth(minNodeWidth);
    }

    public static Quantity<LengthUnits> getMaxNodeWidth(NodeModel node) {
        NodeSizeModel extension = node.getExtension(NodeSizeModel.class);
        return extension != null ? extension.getMaxNodeWidth() : null;
    }

    public static Quantity<LengthUnits> getMinNodeWidth(NodeModel node) {
        NodeSizeModel extension = node.getExtension(NodeSizeModel.class);
        return extension != null ? extension.getMinNodeWidth() : null;
    }

    public void copyTo(NodeSizeModel to) {
        if (this.maxTextWidth != null) {
            to.setMaxNodeWidth(this.maxTextWidth);
        }
        if (this.minNodeWidth != null) {
            to.setMinNodeWidth(this.minNodeWidth);
        }
    }
}

