/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.core.ui.components.TypedListCellRenderer;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeTableLayoutModel;
import org.freeplane.features.attribute.ColumnWidthChangeEvent;
import org.freeplane.features.attribute.IAttributeTableModel;
import org.freeplane.features.attribute.IColumnWidthChangeListener;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.format.FormattedObject;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.ViewController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.attribute.AttributeTableCellRenderer;
import org.freeplane.view.swing.map.attribute.AttributeTableModelDecoratorAdapter;
import org.freeplane.view.swing.map.attribute.AttributeView;
import org.freeplane.view.swing.map.attribute.AttributeViewScrollPane;
import org.freeplane.view.swing.map.attribute.CursorUpdater;
import org.freeplane.view.swing.map.attribute.ExtendedAttributeTableModelDecorator;

class AttributeTable
extends JTable
implements IColumnWidthChangeListener {
    private static final String EDITING_STOPPED = AttributeTable.class.getName() + ".editingStopped";
    private static int CLICK_COUNT_TO_START = 2;
    private static MouseListener componentListener = new HeaderMouseListener();
    private static ComboBoxModel defaultComboBoxModel = null;
    private static AttributeTableCellRenderer dtcr = new AttributeTableCellRenderer();
    private static final int EXTRA_HEIGHT = 4;
    private static MyFocusListener focusListener = new MyFocusListener();
    private static CursorUpdater cursorUpdater = new CursorUpdater();
    private static final int MAX_HEIGTH = 300;
    private static final int MAX_WIDTH = 300;
    private static final long serialVersionUID = 1L;
    private static final float TABLE_ROW_HEIGHT = 4.0f;
    private final AttributeView attributeView;
    private int highRowIndex = 0;
    private static DefaultCellEditor dce;
    private Color gridColor = null;

    static ComboBoxModel getDefaultComboBoxModel() {
        if (defaultComboBoxModel == null) {
            defaultComboBoxModel = new DefaultComboBoxModel();
        }
        return defaultComboBoxModel;
    }

    AttributeTable(AttributeView attributeView) {
        this.attributeView = attributeView;
        this.addFocusListener(focusListener);
        this.addMouseListener(cursorUpdater);
        this.addMouseMotionListener(cursorUpdater);
        if (attributeView.getMapView().getModeController().canEdit()) {
            this.tableHeader.addMouseListener(componentListener);
        } else {
            this.tableHeader.setResizingAllowed(false);
        }
        this.setModel(attributeView.getCurrentAttributeTableModel());
        this.setAutoResizeMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(false);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new TableHeader(this.columnModel);
    }

    private void changeSelectedRowHeight(int rowIndex) {
        if (this.highRowIndex != rowIndex) {
            int h;
            if (this.highRowIndex < this.getRowCount()) {
                h = this.getRowHeight(this.highRowIndex);
                this.setRowHeight(this.highRowIndex, h - 4);
            }
            h = this.getRowHeight(rowIndex);
            this.setRowHeight(rowIndex, h + 4);
            this.highRowIndex = rowIndex;
            assert (this.highRowIndex >= 0);
        }
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return;
        }
        if (rowIndex >= rowCount) {
            rowIndex = 0;
            columnIndex = 0;
        }
        this.changeSelectedRowHeight(rowIndex);
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    @Override
    public void columnWidthChanged(ColumnWidthChangeEvent event) {
        float zoom = this.getZoom();
        int col = event.getColumnNumber();
        AttributeTableLayoutModel layoutModel = (AttributeTableLayoutModel)event.getSource();
        int width = layoutModel.getColumnWidth(col).toBaseUnitsRounded();
        this.getColumnModel().getColumn(col).setPreferredWidth((int)((float)width * zoom));
        MapView map = this.attributeView.getMapView();
        NodeModel node = this.attributeView.getNode();
        map.getModeController().getMapController().nodeChanged(node);
    }

    public AttributeTableModelDecoratorAdapter getAttributeTableModel() {
        return (AttributeTableModelDecoratorAdapter)this.getModel();
    }

    public AttributeView getAttributeView() {
        return this.attributeView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (this.isEditing() && this.getCellEditor() instanceof DialogTableCellEditor) {
            return false;
        }
        if (column == 1 && e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            Object value = this.getValueAt(row, column);
            if (value instanceof URI) {
                URI uri = (URI)value;
                Icon linkIcon = this.getLinkIcon(uri);
                int xmax = linkIcon != null ? linkIcon.getIconWidth() : 0;
                int x = me.getX() - this.getColumnModel().getColumn(0).getWidth();
                if (x < xmax) {
                    LinkController.getController().loadURL(this.attributeView.getNode(), new ActionEvent(me.getSource(), me.getID(), null), uri);
                    return false;
                }
            }
        }
        this.putClientProperty("AttributeTable.EditEvent", e);
        try {
            if (super.editCellAt(row, column, e)) {
                TableCellEditor cellEditor = this.getCellEditor();
                if (this.isEditing() && cellEditor instanceof DialogTableCellEditor) {
                    ((JComponent)this.editorComp).paintImmediately(0, 0, this.editorComp.getWidth(), this.editorComp.getHeight());
                    ((DialogTableCellEditor)cellEditor).startEditing();
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.putClientProperty("AttributeTable.EditEvent", null);
        }
    }

    Icon getLinkIcon(URI uri) {
        NodeModel nodeModel = ((IAttributeTableModel)((Object)this.getModel())).getNode();
        Icon linkIcon = Controller.getCurrentModeController().getExtension(LinkController.class).getLinkIcon(uri, nodeModel);
        return linkIcon;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        return this.getCellEditor(row, col, (EventObject)this.getClientProperty("AttributeTable.EditEvent"));
    }

    public TableCellEditor getCellEditor(int row, int col, EventObject e) {
        if (dce != null) {
            dce.stopCellEditing();
        }
        if (col == 1) {
            MTextController textController = (MTextController)TextController.getController();
            if (e instanceof KeyEvent) {
                KeyEvent kev = (KeyEvent)e;
                textController.getEventQueue().setFirstEvent((InputEvent)kev);
            }
            IAttributeTableModel model = (IAttributeTableModel)((Object)this.getModel());
            String text = this.getValueForEdit(row, col);
            DialogTableCellEditor dialogTableCellEditor = new DialogTableCellEditor();
            EditNodeBase base = textController.getEditNodeBase(model.getNode(), text, dialogTableCellEditor.getEditControl(), false);
            if (base != null) {
                dialogTableCellEditor.setEditBase(base);
                return dialogTableCellEditor;
            }
        }
        if (dce == null) {
            JComboBoxWithBorder comboBox = new JComboBoxWithBorder(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e != null && e.getSource() == dce) {
                        super.actionPerformed(new ActionEvent(this.getEditor(), e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                    } else {
                        super.actionPerformed(e);
                    }
                }
            };
            comboBox.addFocusListener(focusListener);
            comboBox.getEditor().getEditorComponent().addFocusListener(focusListener);
            comboBox.setRenderer(new TypedListCellRenderer());
            dce = new DefaultCellEditor(comboBox){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
                    return super.getTableCellEditorComponent(table, ((AttributeTable)table).getValueForEdit(row, col), isSelected, row, col);
                }
            };
            dce.setClickCountToStart(CLICK_COUNT_TO_START);
        }
        return dce;
    }

    private String getValueForEdit(int row, int col) {
        Object value = this.getValueAt(row, col);
        return (value instanceof IFormattedObject ? ((IFormattedObject)value).getObject() : value).toString();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return dtcr;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (!this.isValid()) {
            this.validate();
        }
        Dimension dimension = super.getPreferredSize();
        NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this);
        if (nodeView != null) {
            MapView map = nodeView.getMap();
            ModeController modeController = map.getModeController();
            NodeStyleController nsc = NodeStyleController.getController(modeController);
            dimension.width = Math.min(map.getZoomed(nsc.getMaxWidth(nodeView.getModel()).toBaseUnits()), dimension.width);
            dimension.height = Math.min(map.getZoomed(300) - this.getTableHeaderHeight(), dimension.height);
        } else {
            dimension.width = Math.min(300, dimension.width);
            dimension.height = Math.min(300, dimension.height);
        }
        return dimension;
    }

    int getTableHeaderHeight() {
        JTableHeader tableHeader = this.getTableHeader();
        return tableHeader != null ? tableHeader.getPreferredSize().height : 0;
    }

    float getZoom() {
        MapView mapView = this.attributeView.getMapView();
        if (SwingUtilities.isDescendingFrom(this, mapView)) {
            return mapView.getZoom();
        }
        return 1.0f;
    }

    public void insertRow(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            if (this.isEditing() && this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
                return;
            }
            model.insertRow(row);
            this.changeSelection(row, 0, false, false);
            if (this.editCellAt(row, 0)) {
                this.getEditorComponent().requestFocusInWindow();
            }
        }
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.attributeView.areAttributesVisible();
    }

    public void moveRowDown(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator && row < this.getRowCount() - 1) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            model.moveRowDown(row);
            this.changeSelection(row + 1, this.getSelectedColumn(), false, false);
        }
    }

    public void moveRowUp(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator && row > 0) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            model.moveRowUp(row);
            this.changeSelection(row - 1, this.getSelectedColumn(), false, false);
        }
    }

    @Override
    public Component prepareEditor(TableCellEditor tce, int row, int col) {
        ComboBoxModel model;
        if (tce instanceof DialogTableCellEditor) {
            return super.prepareEditor(tce, row, col);
        }
        JComboBox comboBox = (JComboBox)((DefaultCellEditor)tce).getComponent();
        NodeModel node = this.getAttributeTableModel().getNode();
        AttributeRegistry attributes = AttributeRegistry.getRegistry(node.getMap());
        switch (col) {
            case 0: {
                model = attributes.getComboBoxModel();
                comboBox.setEditable(!attributes.isRestricted());
                break;
            }
            case 1: {
                String attrName = this.getAttributeTableModel().getValueAt(row, 0).toString();
                model = attributes.getDefaultComboBoxModel((Comparable<?>)((Object)attrName));
                comboBox.setEditable(!attributes.isRestricted(attrName));
                break;
            }
            default: {
                model = AttributeTable.getDefaultComboBoxModel();
            }
        }
        Object[] items = new Object[model.getSize()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = model.getElementAt(i);
        }
        DefaultComboBoxModel<Object> currentModel = new DefaultComboBoxModel<Object>(items);
        comboBox.setModel(currentModel);
        this.updateComponentColors(comboBox);
        JComponent editorComponent = (JComponent)comboBox.getEditor().getEditorComponent();
        this.updateComponentColors(editorComponent);
        editorComponent.setOpaque(true);
        Font font = editorComponent.getFont();
        editorComponent.setFont(font.deriveFont(font.getSize2D() * this.getZoom()));
        return super.prepareEditor(tce, row, col);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Object value = this.getValueAt(row, column);
        boolean isSelected = false;
        boolean hasFocus = false;
        MapView map = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        if (map == null || !map.isPrinting()) {
            isSelected = this.isCellSelected(row, column);
            boolean rowIsLead = this.selectionModel.getLeadSelectionIndex() == row;
            boolean colIsLead = this.columnModel.getSelectionModel().getLeadSelectionIndex() == column;
            Window windowAncestor = SwingUtilities.getWindowAncestor(this);
            hasFocus = rowIsLead && colIsLead && windowAncestor != null && this.equals(windowAncestor.getMostRecentFocusOwner());
        }
        return renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks.getKeyCode() == 9 && e.getModifiers() == 0 && pressed && this.getSelectedColumn() == 1 && this.getSelectedRow() == this.getRowCount() - 1 && this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            this.insertRow(this.getRowCount());
            return true;
        }
        if (ks.getKeyCode() == 27 && e.getModifiers() == 0 && pressed) {
            if (!this.isEditing()) {
                this.attributeView.getNodeView().requestFocusInWindow();
                return true;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        boolean retValue = super.processKeyBinding(ks, e, condition, pressed);
        if (!retValue && condition == 0 && this.isFocusOwner() && ks.getKeyCode() != 9 && e != null && e.getID() == 401 && !e.isActionKey() && e.getKeyChar() != '\uffff' && 0 == (e.getModifiers() & 0xA)) {
            int leadRow = this.getSelectionModel().getLeadSelectionIndex();
            int leadColumn = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (leadRow != -1 && leadColumn != -1 && !this.isEditing() && !this.editCellAt(leadRow, leadColumn, e)) {
                return false;
            }
            Component editorComponent = this.getEditorComponent();
            if (editorComponent instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)editorComponent;
                if (comboBox.isEditable()) {
                    ComboBoxEditor editor = comboBox.getEditor();
                    editor.selectAll();
                    KeyEvent keyEv = new KeyEvent(editor.getEditorComponent(), 400, e.getWhen(), e.getModifiers(), 0, e.getKeyChar(), 0);
                    retValue = SwingUtilities.processKeyBindings(keyEv);
                } else {
                    editorComponent.requestFocusInWindow();
                    retValue = true;
                }
            }
        }
        if (ks.getKeyCode() == 32) {
            return true;
        }
        return retValue;
    }

    @Override
    public void removeEditor() {
        Component editorComponent = this.getEditorComponent();
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean requestFocus = editorComponent != null && focusOwner != null && (focusOwner == editorComponent || SwingUtilities.isDescendingFrom(focusOwner, editorComponent));
        this.getAttributeTableModel().editingCanceled();
        boolean focusCycleRoot = this.isFocusCycleRoot();
        this.setFocusCycleRoot(true);
        super.removeEditor();
        this.setFocusCycleRoot(focusCycleRoot);
        if (requestFocus) {
            this.requestFocusInWindow();
        }
    }

    public void removeRow(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            model.removeRow(row);
            int rowCount = this.getRowCount();
            if (row <= rowCount - 1) {
                this.changeSelection(row, this.getSelectedColumn(), false, false);
            } else if (rowCount >= 1) {
                this.changeSelection(row - 1, this.getSelectedColumn(), false, false);
            }
        }
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
    }

    public void setOptimalColumnWidths() {
        Component comp = null;
        int cellWidth = 0;
        int maxCellWidth = 2 * (int)Math.ceil(this.getFont().getSize2D() / UITools.FONT_SCALE_FACTOR + 4.0f);
        for (int col = 0; col < 2; ++col) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                comp = dtcr.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                cellWidth = comp.getPreferredSize().width;
                maxCellWidth = Math.max(cellWidth, maxCellWidth);
            }
            this.getAttributeTableModel().setColumnWidth(col, LengthUnits.pixelsInPt(maxCellWidth + 1));
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.isEditing() && null == this.getClientProperty(EDITING_STOPPED)) {
            this.removeEditor();
        }
        int selectedRow = this.getSelectedRow();
        super.tableChanged(e);
        if (this.getParent() == null) {
            return;
        }
        switch (e.getType()) {
            case -1: {
                if (selectedRow == -1 || e.getFirstRow() > selectedRow) break;
                if (e.getLastRow() >= selectedRow && e.getFirstRow() != 0) {
                    this.changeSelection(e.getFirstRow() - 1, 0, false, false);
                    break;
                }
                if (e.getLastRow() >= selectedRow) break;
                int rowIndex = selectedRow - (e.getLastRow() - e.getFirstRow() + 1);
                if (rowIndex < 0) {
                    rowIndex = 0;
                }
                if (rowIndex >= this.getRowCount()) break;
                this.changeSelection(rowIndex, this.getSelectedColumn(), false, false);
                break;
            }
            case 1: {
                this.changeSelection(e.getFirstRow(), this.getSelectedColumn(), false, false);
                break;
            }
            default: {
                if (selectedRow <= this.getRowCount() || this.getRowCount() <= 0) break;
                this.changeSelection(this.getRowCount() - 1, this.getSelectedColumn(), false, false);
            }
        }
        this.getParent().getParent().invalidate();
        NodeModel node = this.attributeView.getNode();
        MapController mapController = this.attributeView.getMapView().getModeController().getMapController();
        mapController.nodeChanged(node, NodeAttributeTableModel.class, null, null);
    }

    void updateAttributeTable() {
        this.updateComponentColors(this);
        this.updateGridColor();
        this.updateRowHeights();
        this.updateColumnWidths();
    }

    private void updateGridColor() {
        NodeView nodeView = this.attributeView.getNodeView();
        if (!SwingUtilities.isDescendingFrom(this, nodeView)) {
            return;
        }
        MapView mapView = nodeView.getMap();
        MapStyleModel model = MapStyleModel.getExtension(mapView.getModel());
        NodeModel attributeStyleNode = model.getStyleNodeSafe(MapStyleModel.ATTRIBUTE_STYLE);
        EdgeModel edge = EdgeModel.getModel(attributeStyleNode);
        if (edge != null) {
            Color edgeColor = edge.getColor();
            this.setGridAndBorderColor(edgeColor);
        } else {
            this.gridColor = null;
        }
    }

    public void setGridAndBorderColor(Color gridColor) {
        this.gridColor = gridColor;
        if (gridColor != null && !gridColor.equals(this.getGridColor())) {
            AttributeViewScrollPane scrollPane = (AttributeViewScrollPane)SwingUtilities.getAncestorOfClass(AttributeViewScrollPane.class, this);
            scrollPane.setBorder(BorderFactory.createLineBorder(gridColor));
            super.setGridColor(gridColor);
        }
    }

    private void updateColumnWidths() {
        float zoom = this.getZoom();
        for (int i = 0; i < 2; ++i) {
            int width = (int)((float)this.getAttributeTableModel().getColumnWidth(i).toBaseUnitsRounded() * zoom);
            this.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
    }

    private void updateComponentColors(JComponent c) {
        NodeView nodeView = this.attributeView.getNodeView();
        if (!SwingUtilities.isDescendingFrom(this, nodeView)) {
            return;
        }
        MapView mapView = nodeView.getMap();
        ModeController modeController = mapView.getModeController();
        NodeStyleController style = modeController.getExtension(NodeStyleController.class);
        MapStyleModel model = MapStyleModel.getExtension(mapView.getModel());
        NodeModel attributeStyleNode = model.getStyleNodeSafe(MapStyleModel.ATTRIBUTE_STYLE);
        Font font = style.getFont(attributeStyleNode);
        c.setFont(font.deriveFont(UITools.FONT_SCALE_FACTOR * font.getSize2D()));
        Color backgroundColor = NodeStyleModel.getBackgroundColor(attributeStyleNode);
        if (backgroundColor != null) {
            c.setOpaque(true);
            c.setBackground(backgroundColor);
        } else {
            c.setBackground(nodeView.getBackgroundColor());
            c.setOpaque(false);
        }
        c.setForeground(style.getColor(attributeStyleNode));
    }

    private void updateRowHeights() {
        int i;
        if (!this.isDisplayable()) {
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if (AttributeTable.this.isDisplayable()) {
                        AttributeTable.this.updateRowHeights();
                        AttributeTable.this.removeHierarchyListener(this);
                    }
                }
            });
            return;
        }
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return;
        }
        int constHeight = this.getTableHeaderHeight() + 4;
        float zoom = this.getZoom();
        float fontSize = (float)this.getFont().getMaxCharBounds(((Graphics2D)this.getGraphics()).getFontRenderContext()).getHeight();
        float tableRowHeight = fontSize + zoom * 4.0f;
        int newHeight = (int)((tableRowHeight * (float)rowCount + (zoom - 1.0f) * (float)constHeight) / (float)rowCount);
        if (newHeight < 1) {
            newHeight = 1;
        }
        int highRowsNumber = (int)((tableRowHeight - (float)newHeight) * (float)rowCount);
        for (i = 0; i < highRowsNumber; ++i) {
            this.setRowHeight(i, 1 + newHeight + (i == this.highRowIndex ? 4 : 0));
        }
        for (i = highRowsNumber; i < rowCount; ++i) {
            this.setRowHeight(i, newHeight + (i == this.highRowIndex ? 4 : 0));
        }
    }

    public void viewRemoved(NodeView nodeView) {
        this.getModel().removeTableModelListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editingStopped(ChangeEvent e) {
        if (this.isEditing() && null == this.getClientProperty(EDITING_STOPPED)) {
            try {
                this.putClientProperty(EDITING_STOPPED, Boolean.TRUE);
                TableCellEditor editor = this.getCellEditor();
                if (editor != null) {
                    Object value = editor.getCellEditorValue();
                    if (value != null) {
                        String pattern = this.extractPatternIfAvailable(this.getValueAt(this.editingRow, this.editingColumn));
                        Object newValue = this.enforceFormattedObjectForIdentityPattern(value, pattern);
                        this.setValueAt(newValue, this.editingRow, this.editingColumn);
                    }
                    this.removeEditor();
                }
            }
            finally {
                this.putClientProperty(EDITING_STOPPED, null);
            }
        }
    }

    private String extractPatternIfAvailable(Object oldValue) {
        return oldValue instanceof IFormattedObject ? ((IFormattedObject)oldValue).getPattern() : null;
    }

    private Object enforceFormattedObjectForIdentityPattern(Object value, String pattern) {
        MTextController textController = (MTextController)TextController.getController();
        return "NO_FORMAT".equals(pattern) ? new FormattedObject(value, pattern) : textController.guessObjectOrURI(value, pattern);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(column == 0 ? aValue.toString() : aValue, row, column);
        this.setSelectedCellTypeInfo();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.setSelectedCellTypeInfo();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        super.columnSelectionChanged(e);
        this.setSelectedCellTypeInfo();
    }

    private void setSelectedCellTypeInfo() {
        int r = this.getSelectedRow();
        int c = this.getSelectedColumn();
        if (r >= 0 && c >= 0) {
            Object value = this.getValueAt(r, c);
            ViewController viewController = Controller.getCurrentController().getViewController();
            viewController.addObjectTypeInfo(value);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        NodeView nodeView;
        if (this.gridColor == null && SwingUtilities.isDescendingFrom(this, nodeView = this.attributeView.getNodeView())) {
            this.setGridAndBorderColor(nodeView.getEdgeColor());
        }
        super.paintComponent(g);
    }

    private class DialogTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final EditNodeBase.IEditControl editControl;
        private Object value;
        private EditNodeBase editBase;

        public DialogTableCellEditor() {
            this.editControl = new EditNodeBase.IEditControl(){

                public void split(String newText, int position) {
                }

                public void ok(String newText) {
                    DialogTableCellEditor.this.value = newText;
                    DialogTableCellEditor.this.stopCellEditing();
                }

                public void cancel() {
                    DialogTableCellEditor.this.stopCellEditing();
                }

                public boolean canSplit() {
                    return false;
                }

                public EditNodeBase.EditedComponent getEditType() {
                    return EditNodeBase.EditedComponent.TEXT;
                }
            };
        }

        public EditNodeBase.IEditControl getEditControl() {
            return this.editControl;
        }

        public void setEditBase(EditNodeBase editBase) {
            this.editBase = editBase;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        public void startEditing() {
            if (this.editBase == null) {
                return;
            }
            JFrame frame = (JFrame)JOptionPane.getFrameForComponent(AttributeTable.this);
            this.editBase.show((RootPaneContainer)frame);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= CLICK_COUNT_TO_START;
            }
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return new AttributeTableCellRenderer().getTableCellRendererComponent(table, value, true, true, row, column);
        }
    }

    private static class MyFocusListener
    implements FocusListener {
        private AttributeTable focusedTable;

        private MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            Component source = (Component)event.getSource();
            event.getOppositeComponent();
            this.focusedTable = source instanceof AttributeTable ? (AttributeTable)source : (AttributeTable)SwingUtilities.getAncestorOfClass(AttributeTable.class, source);
            if (this.focusedTable != null) {
                this.focusedTable.setSelectedCellTypeInfo();
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NodeView viewer;
                    Container newNodeViewInFocus;
                    if (MyFocusListener.this.focusedTable != null && (newNodeViewInFocus = SwingUtilities.getAncestorOfClass(NodeView.class, MyFocusListener.this.focusedTable)) != null && (viewer = (NodeView)newNodeViewInFocus) != viewer.getMap().getSelected()) {
                        viewer.getMap().selectAsTheOnlyOneSelected(viewer, false);
                    }
                }
            });
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (event.isTemporary()) {
                return;
            }
            Component oppositeComponent = event.getOppositeComponent();
            if (oppositeComponent == null) {
                return;
            }
            Component newTable = oppositeComponent instanceof AttributeTable ? oppositeComponent : SwingUtilities.getAncestorOfClass(AttributeTable.class, oppositeComponent);
            if (this.focusedTable == null) {
                return;
            }
            if (this.focusedTable != newTable) {
                if (this.focusedTable.isEditing()) {
                    this.focusedTable.clearSelection();
                    this.focusedTable.getCellEditor().stopCellEditing();
                }
                if (!this.focusedTable.attributeView.isPopupShown()) {
                    AttributeView attributeView = this.focusedTable.getAttributeView();
                    String currentAttributeViewType = AttributeRegistry.getRegistry(attributeView.getNode().getMap()).getAttributeViewType();
                    if (attributeView.getViewType() != currentAttributeViewType) {
                        attributeView.stateChanged(null);
                    }
                }
                this.focusedTable = null;
                return;
            }
        }
    }

    private static class HeaderMouseListener
    extends MouseAdapter {
        private HeaderMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            AttributeTable table = (AttributeTable)header.getTable();
            float zoom = table.attributeView.getMapView().getZoom();
            AttributeTableModelDecoratorAdapter model = (AttributeTableModelDecoratorAdapter)table.getModel();
            for (int col = 0; col < table.getColumnCount(); ++col) {
                int currentColumnWidth;
                int modelColumnWidth = model.getColumnWidth(col).toBaseUnitsRounded();
                if (modelColumnWidth == (currentColumnWidth = (int)((float)table.getColumnModel().getColumn(col).getWidth() / zoom))) continue;
                model.setColumnWidth(col, LengthUnits.pixelsInPt(currentColumnWidth));
            }
        }
    }

    private static final class TableHeader
    extends JTableHeader {
        private TableHeader(TableColumnModel cm) {
            super(cm);
        }

        @Override
        protected TableCellRenderer createDefaultRenderer() {
            return new TableHeaderRendererImpl(super.createDefaultRenderer());
        }
    }

    private static final class TableHeaderRendererImpl
    implements TableCellRenderer {
        private final TableCellRenderer delegate;

        TableHeaderRendererImpl(TableCellRenderer renderer) {
            this.delegate = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int height = (int)(((AttributeTable)table).getZoom() * 6.0f);
            Dimension preferredSize = new Dimension(1, height);
            c.setPreferredSize(preferredSize);
            return c;
        }
    }
}

