/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Set;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IMouseWheelEventHandler;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MapView;

public class DefaultMouseWheelListener
implements MouseWheelListener {
    private static final int HORIZONTAL_SCROLL_MASK = 29;
    public static final String RESOURCES_WHEEL_VELOCITY = "wheel_velocity";
    private static int SCROLL_SKIPS = 8;
    private static final int ZOOM_MASK = 2;

    public DefaultMouseWheelListener() {
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals(DefaultMouseWheelListener.RESOURCES_WHEEL_VELOCITY)) {
                    SCROLL_SKIPS = Integer.parseInt(newValue);
                }
            }
        });
        SCROLL_SKIPS = ResourceController.getResourceController().getIntProperty(RESOURCES_WHEEL_VELOCITY, 8);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        MapView mapView = (MapView)e.getSource();
        ModeController mController = mapView.getModeController();
        if (mController.isBlocked() || Controller.getCurrentController().getMap() != mapView.getModel()) {
            return;
        }
        Set<IMouseWheelEventHandler> registeredMouseWheelEventHandler = mController.getUserInputListenerFactory().getMouseWheelEventHandlers();
        for (IMouseWheelEventHandler handler : registeredMouseWheelEventHandler) {
            boolean result = handler.handleMouseWheelEvent(e);
            if (!result) continue;
            return;
        }
        if ((e.getModifiers() & 2) != 0) {
            float newZoomFactor = 1.0f + Math.abs((float)e.getWheelRotation()) / 10.0f;
            if (e.getWheelRotation() < 0) {
                newZoomFactor = 1.0f / newZoomFactor;
            }
            float oldZoom = ((MapView)e.getComponent()).getZoom();
            float newZoom = oldZoom / newZoomFactor;
            newZoom = (float)Math.rint(newZoom * 1000.0f) / 1000.0f;
            newZoom = Math.max(0.03125f, newZoom);
            if ((newZoom = Math.min(32.0f, newZoom)) != oldZoom) {
                Controller.getCurrentController().getMapViewManager().setZoom(newZoom);
            }
        } else if ((e.getModifiers() & 0x1D) != 0) {
            ((MapView)e.getComponent()).scrollBy(SCROLL_SKIPS * e.getWheelRotation(), 0);
        } else {
            ((MapView)e.getComponent()).scrollBy(0, SCROLL_SKIPS * e.getWheelRotation());
        }
    }
}

