/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

public class DoubleBits {
    public static final int EXPONENT_BIAS = 1023;
    private double x;
    private long xBits;

    public static double powerOf2(int n) {
        if (n > 1023 || n < -1022) {
            throw new IllegalArgumentException("Exponent out of bounds");
        }
        long l = n + 1023;
        long l2 = l << 52;
        return Double.longBitsToDouble(l2);
    }

    public static int exponent(double d) {
        DoubleBits doubleBits = new DoubleBits(d);
        return doubleBits.getExponent();
    }

    public static double truncateToPowerOfTwo(double d) {
        DoubleBits doubleBits = new DoubleBits(d);
        doubleBits.zeroLowerBits(52);
        return doubleBits.getDouble();
    }

    public static String toBinaryString(double d) {
        DoubleBits doubleBits = new DoubleBits(d);
        return doubleBits.toString();
    }

    public static double maximumCommonMantissa(double d, double d2) {
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        DoubleBits doubleBits = new DoubleBits(d);
        DoubleBits doubleBits2 = new DoubleBits(d2);
        if (doubleBits.getExponent() != doubleBits2.getExponent()) {
            return 0.0;
        }
        int n = doubleBits.numCommonMantissaBits(doubleBits2);
        doubleBits.zeroLowerBits(64 - (12 + n));
        return doubleBits.getDouble();
    }

    public DoubleBits(double d) {
        this.x = d;
        this.xBits = Double.doubleToLongBits(d);
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.xBits);
    }

    public int biasedExponent() {
        int n = (int)(this.xBits >> 52);
        int n2 = n & 0x7FF;
        return n2;
    }

    public int getExponent() {
        return this.biasedExponent() - 1023;
    }

    public void zeroLowerBits(int n) {
        long l = (1L << n) - 1L;
        long l2 = l ^ 0xFFFFFFFFFFFFFFFFL;
        this.xBits &= l2;
    }

    public int getBit(int n) {
        long l = 1L << n;
        return (this.xBits & l) != 0L ? 1 : 0;
    }

    public int numCommonMantissaBits(DoubleBits doubleBits) {
        for (int i = 0; i < 52; ++i) {
            int n = i + 12;
            if (this.getBit(i) == doubleBits.getBit(i)) continue;
            return i;
        }
        return 52;
    }

    public String toString() {
        String string = Long.toBinaryString(this.xBits);
        String string2 = "0000000000000000000000000000000000000000000000000000000000000000";
        String string3 = string2 + string;
        String string4 = string3.substring(string3.length() - 64);
        String string5 = string4.substring(0, 1) + "  " + string4.substring(1, 12) + "(" + this.getExponent() + ") " + string4.substring(12) + " [ " + this.x + " ]";
        return string5;
    }
}

