/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.SegmentNodeList;

public class SegmentString {
    private SegmentNodeList eiList = new SegmentNodeList(this);
    private Coordinate[] pts;
    private Object context;
    private boolean isIsolated;

    public SegmentString(Coordinate[] coordinateArray, Object object) {
        this.pts = coordinateArray;
        this.context = object;
    }

    public Object getContext() {
        return this.context;
    }

    public SegmentNodeList getIntersectionList() {
        return this.eiList;
    }

    public int size() {
        return this.pts.length;
    }

    public Coordinate getCoordinate(int n) {
        return this.pts[n];
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public void setIsolated(boolean bl) {
        this.isIsolated = bl;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public void addIntersections(LineIntersector lineIntersector, int n, int n2) {
        for (int i = 0; i < lineIntersector.getIntersectionNum(); ++i) {
            this.addIntersection(lineIntersector, n, n2, i);
        }
    }

    public void addIntersection(LineIntersector lineIntersector, int n, int n2, int n3) {
        Coordinate coordinate = new Coordinate(lineIntersector.getIntersection(n3));
        double d = lineIntersector.getEdgeDistance(n2, n3);
        this.addIntersection(coordinate, n, d);
    }

    public void OLDaddIntersection(LineIntersector lineIntersector, int n, int n2, int n3) {
        Comparable comparable;
        Coordinate coordinate = new Coordinate(lineIntersector.getIntersection(n3));
        int n4 = n;
        double d = lineIntersector.getEdgeDistance(n2, n3);
        int n5 = n4 + 1;
        if (n5 < this.pts.length && coordinate.equals2D((Coordinate)(comparable = this.pts[n5]))) {
            n4 = n5;
            d = 0.0;
        }
        comparable = this.eiList.add(coordinate, n4, d);
    }

    public void addIntersection(Coordinate coordinate, int n) {
        double d = LineIntersector.computeEdgeDistance(coordinate, this.pts[n], this.pts[n + 1]);
        this.addIntersection(coordinate, n, d);
    }

    public void addIntersection(Coordinate coordinate, int n, double d) {
        Comparable comparable;
        int n2 = n;
        int n3 = n2 + 1;
        if (n3 < this.pts.length && coordinate.equals2D((Coordinate)(comparable = this.pts[n3]))) {
            n2 = n3;
            d = 0.0;
        }
        comparable = this.eiList.add(coordinate, n2, d);
    }
}

