/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.coordsys.impl;

import com.vividsolutions.jump.coordsys.Geographic;
import com.vividsolutions.jump.coordsys.Planar;
import com.vividsolutions.jump.coordsys.Projection;

public class Mercator
extends Projection {
    double L0;
    double X0;
    double Y0;
    Geographic q = new Geographic();

    public void setParameters(double d, double d2, double d3) {
        this.L0 = d / 180.0 * Math.PI;
        this.X0 = d2;
        this.Y0 = d3;
    }

    public Planar asPlanar(Geographic geographic, Planar planar) {
        this.q.lat = geographic.lat / 180.0 * Math.PI;
        this.q.lon = geographic.lon / 180.0 * Math.PI;
        this.forward(this.q, planar);
        return planar;
    }

    public Geographic asGeographic(Planar planar, Geographic geographic) {
        this.inverse(planar, geographic);
        geographic.lat = geographic.lat * 180.0 / Math.PI;
        geographic.lon = geographic.lon * 180.0 / Math.PI;
        return geographic;
    }

    void forward(Geographic geographic, Planar planar) {
        double d = this.currentSpheroid.getA();
        double d2 = this.currentSpheroid.getE();
        planar.x = d * (geographic.lon - this.L0);
        planar.y = d / 2.0 * Math.log((1.0 + Math.sin(geographic.lat)) / (1.0 - Math.sin(geographic.lat)) * Math.pow((1.0 - d2 * Math.sin(geographic.lat)) / (1.0 + d2 * Math.sin(geographic.lat)), d2));
    }

    void inverse(Planar planar, Geographic geographic) {
        double d = this.currentSpheroid.getA();
        double d2 = this.currentSpheroid.getE();
        double d3 = Math.exp(-planar.y / d);
        double d4 = 1.5707963267948966 - 2.0 * Math.atan(d3);
        double d5 = 10000.0;
        do {
            double d6 = 1.5707963267948966 - 2.0 * Math.atan(d3 * Math.pow((1.0 - d2 * Math.sin(d4)) / (1.0 + d2 * Math.sin(d4)), d2 / 2.0));
            d5 = Math.abs(d6 - d4);
            d4 = d6;
        } while (d5 > 1.0E-14);
        double d7 = planar.x / d + this.L0;
        geographic.lat = d4;
        geographic.lon = d7;
    }
}

