/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DummyTool;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.Java2DConverter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LayerViewPanel
extends JPanel
implements LayerListener,
LayerManagerProxy {
    private Color backgroundColor = Color.white;
    BorderLayout borderLayout1 = new BorderLayout();
    private LayerManager layerManager;
    private Viewport viewport = new Viewport(this);
    private boolean viewportInitialized = false;
    private Point lastClickedPoint;
    private ArrayList listeners = new ArrayList();
    private LayerViewPanelContext context;
    private RenderingManager renderingManager = new RenderingManager(this);
    private FenceLayerFinder fenceLayerFinder;
    private SelectionManager selectionManager;
    private CursorTool currentCursorTool = new DummyTool();

    public LayerViewPanel(LayerManager layerManager, LayerViewPanelContext layerViewPanelContext) {
        this.setMinimumSize(new Dimension(100, 100));
        try {
            this.context = layerViewPanelContext;
            this.layerManager = layerManager;
            this.selectionManager = new SelectionManager(this, this);
            this.fenceLayerFinder = new FenceLayerFinder(this);
            layerManager.addLayerListener(this);
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            layerViewPanelContext.handleThrowable(throwable);
        }
    }

    public static List components(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return Arrays.asList(geometry);
        }
        GeometryCollection geometryCollection = (GeometryCollection)geometry;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            arrayList.addAll(LayerViewPanel.components(geometryCollection.getGeometryN(i)));
        }
        return arrayList;
    }

    public static boolean intersects(Geometry geometry, Geometry geometry2) {
        GeometryFactory geometryFactory = new GeometryFactory(geometry.getPrecisionModel(), geometry.getSRID());
        List list = LayerViewPanel.components(geometry);
        List list2 = LayerViewPanel.components(geometry2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Geometry geometry3 = (Geometry)iterator.next();
            Assert.isTrue(!(geometry3 instanceof GeometryCollection));
            geometry3 = LayerViewPanel.collapseToPointIfPossible(geometry3, geometryFactory);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Geometry geometry4 = (Geometry)iterator2.next();
                Assert.isTrue(!(geometry4 instanceof GeometryCollection));
                if (!geometry3.intersects(geometry4 = LayerViewPanel.collapseToPointIfPossible(geometry4, geometryFactory))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean coordinatesEqual(Geometry geometry) {
        Coordinate[] coordinateArray = geometry.getCoordinates();
        for (int i = 1; i < coordinateArray.length; ++i) {
            if (coordinateArray[i].equals(coordinateArray[0])) continue;
            return false;
        }
        return true;
    }

    private static Geometry collapseToPointIfPossible(Geometry geometry, GeometryFactory geometryFactory) {
        if (!geometry.isEmpty() && LayerViewPanel.coordinatesEqual(geometry)) {
            geometry = geometryFactory.createPoint(geometry.getCoordinate());
        }
        return geometry;
    }

    public CursorTool getCurrentCursorTool() {
        return this.currentCursorTool;
    }

    public void setCurrentCursorTool(CursorTool cursorTool) {
        this.currentCursorTool.deactivate();
        this.removeMouseListener(this.currentCursorTool);
        this.removeMouseMotionListener(this.currentCursorTool);
        this.currentCursorTool = cursorTool;
        cursorTool.activate(this);
        this.setCursor(cursorTool.getCursor());
        this.addMouseListener(cursorTool);
        this.addMouseMotionListener(cursorTool);
    }

    public Map visibleLayerToFeaturesInFenceMap() {
        Map map = this.visibleLayerToFeaturesInFenceMap(this.getFence());
        map.remove(new FenceLayerFinder(this).getLayer());
        return map;
    }

    public Map visibleLayerToFeaturesInFenceMap(Geometry geometry) {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.getLayerManager().iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            if (!layer.isVisible()) continue;
            HashSet<Feature> hashSet = new HashSet<Feature>();
            Iterator iterator2 = layer.getFeatureCollection().query(geometry.getEnvelopeInternal()).iterator();
            while (iterator2.hasNext()) {
                Feature feature = (Feature)iterator2.next();
                if (!LayerViewPanel.intersects(feature.getGeometry(), geometry)) continue;
                hashSet.add(feature);
            }
            if (hashSet.isEmpty()) continue;
            hashMap.put(layer, hashSet);
        }
        return hashMap;
    }

    public void setViewportInitialized(boolean bl) {
        this.viewportInitialized = bl;
    }

    public Point getLastClickedPoint() {
        return this.lastClickedPoint;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public Java2DConverter getJava2DConverter() {
        return this.viewport.getJava2DConverter();
    }

    public Geometry getFence() {
        return this.fenceLayerFinder.getFence();
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public void featuresChanged(FeatureEvent featureEvent) {
    }

    public void categoryChanged(CategoryEvent categoryEvent) {
    }

    public void layerChanged(LayerEvent layerEvent) {
        try {
            if (layerEvent.getType() == LayerEventType.METADATA_CHANGED) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        LayerViewPanel.this.initializeViewportIfNecessary();
                    }
                    catch (Throwable throwable) {
                        LayerViewPanel.this.context.handleThrowable(throwable);
                    }
                }
            });
            if (layerEvent.getType() == LayerEventType.ADDED || layerEvent.getType() == LayerEventType.REMOVED || layerEvent.getType() == LayerEventType.APPEARANCE_CHANGED) {
                this.renderingManager.render(layerEvent.getLayerable());
            } else if (layerEvent.getType() == LayerEventType.VISIBILITY_CHANGED) {
                this.renderingManager.render(layerEvent.getLayerable(), false);
            } else {
                Assert.shouldNeverReachHere();
            }
        }
        catch (Throwable throwable) {
            this.context.handleThrowable(throwable);
        }
    }

    public Image createBlankPanelImage() {
        return new BufferedImage(this.getWidth(), this.getHeight(), 2);
    }

    public void repaint() {
        if (this.renderingManager == null) {
            this.superRepaint();
            return;
        }
        this.renderingManager.renderAll();
    }

    public void superRepaint() {
        super.repaint();
    }

    public void paintComponent(Graphics graphics) {
        try {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(graphics);
            this.erase((Graphics2D)graphics);
            this.renderingManager.copyTo((Graphics2D)graphics);
            this.firePainted(graphics);
        }
        catch (Throwable throwable) {
            this.context.handleThrowable(throwable);
        }
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public void erase(Graphics2D graphics2D) {
        this.fill(graphics2D, this.backgroundColor);
    }

    public void fill(Graphics2D graphics2D, Color color) {
        graphics2D.setColor(color);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        graphics2D.fill(double_);
    }

    void jbInit() throws Exception {
        this.setBackground(Color.white);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                LayerViewPanel.this.this_componentResized(componentEvent);
            }
        });
        this.setLayout(this.borderLayout1);
    }

    void this_componentResized(ComponentEvent componentEvent) {
        try {
            this.viewport.update();
        }
        catch (Throwable throwable) {
            this.context.handleThrowable(throwable);
        }
    }

    public LayerViewPanelContext getContext() {
        return this.context;
    }

    private void initializeViewportIfNecessary() throws NoninvertibleTransformException {
        if (!this.viewportInitialized && this.layerManager.size() > 0 && this.layerManager.getEnvelopeOfAllLayers().getWidth() > 0.0) {
            this.setViewportInitialized(true);
            this.viewport.zoomToFullExtent();
            return;
        }
    }

    public void addListener(LayerViewPanelListener layerViewPanelListener) {
        this.listeners.add(layerViewPanelListener);
    }

    public void removeListener(LayerViewPanelListener layerViewPanelListener) {
        this.listeners.remove(layerViewPanelListener);
    }

    public String format(double d) {
        double d2 = this.viewport.getEnvelopeInModelCoordinates().getWidth() / (double)this.getWidth();
        return this.format(d, d2);
    }

    protected String format(double d, double d2) {
        int n = (int)Math.max(0L, Math.round(-Math.log(d2) / Math.log(10.0)));
        ++n;
        String string = "#.";
        for (int i = 0; i < n; ++i) {
            string = string + "#";
        }
        return new DecimalFormat(string).format(d);
    }

    private void firePainted(Graphics graphics) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            LayerViewPanelListener layerViewPanelListener = (LayerViewPanelListener)iterator.next();
            layerViewPanelListener.painted(graphics);
        }
    }

    public void fireSelectionChanged() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            LayerViewPanelListener layerViewPanelListener = (LayerViewPanelListener)iterator.next();
            layerViewPanelListener.selectionChanged();
        }
    }

    private void fireCursorPositionChanged(String string, String string2) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            LayerViewPanelListener layerViewPanelListener = (LayerViewPanelListener)iterator.next();
            layerViewPanelListener.cursorPositionChanged(string, string2);
        }
    }

    public RenderingManager getRenderingManager() {
        return this.renderingManager;
    }

    public Collection featuresWithVertex(Point2D point2D, double d, Collection collection) throws NoninvertibleTransformException {
        Point2D point2D2 = this.viewport.toModelPoint(point2D);
        double d2 = d / this.viewport.getScale();
        Envelope envelope = new Envelope(point2D2.getX() - d2, point2D2.getX() + d2, point2D2.getY() - d2, point2D2.getY() + d2);
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            if (!this.geometryHasVertex(feature.getGeometry(), envelope)) continue;
            arrayList.add(feature);
        }
        return arrayList;
    }

    private boolean geometryHasVertex(Geometry geometry, Envelope envelope) {
        Coordinate[] coordinateArray = geometry.getCoordinates();
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (!envelope.contains(coordinateArray[i])) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.renderingManager.dispose();
        this.selectionManager.dispose();
        this.layerManager.removeLayerListener(this);
    }

    public void flash(final Shape shape, Color color, Stroke stroke, final int n) {
        final Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setColor(color);
        graphics2D.setXORMode(Color.white);
        graphics2D.setStroke(stroke);
        try {
            GUIUtil.invokeOnEventThread(new Runnable(){

                public void run() {
                    try {
                        graphics2D.draw(shape);
                        Thread.sleep(n);
                        graphics2D.draw(shape);
                    }
                    catch (Throwable throwable) {
                        LayerViewPanel.this.getContext().handleThrowable(throwable);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            this.getContext().handleThrowable(throwable);
        }
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void flash(GeometryCollection geometryCollection) throws NoninvertibleTransformException {
        this.flash(this.getViewport().getJava2DConverter().toShape((Geometry)geometryCollection), Color.red, new BasicStroke(5.0f, 1, 1), 100);
    }
}

