/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import java.io.IOException;
import org.geotools.shapefile.PointHandler;
import org.geotools.shapefile.ShapeHandler;
import org.geotools.shapefile.Shapefile;

public class ShapefileHeader {
    private static final boolean DEBUG = false;
    private int fileCode = -1;
    public int fileLength = -1;
    private int indexLength = -1;
    private int version = -1;
    private int shapeType = -1;
    private Envelope bounds;

    public ShapefileHeader(EndianDataInputStream endianDataInputStream) throws IOException {
        int n;
        this.fileCode = endianDataInputStream.readIntBE();
        if (this.fileCode != 9994) {
            System.err.println("Sfh->WARNING filecode " + this.fileCode + " not a match for documented shapefile code " + 9994);
        }
        for (n = 0; n < 5; ++n) {
            int n2 = endianDataInputStream.readIntBE();
        }
        this.fileLength = endianDataInputStream.readIntBE();
        this.version = endianDataInputStream.readIntLE();
        this.shapeType = endianDataInputStream.readIntLE();
        for (n = 0; n < 4; ++n) {
            endianDataInputStream.readDoubleLE();
        }
        endianDataInputStream.skipBytes(32);
    }

    public ShapefileHeader(GeometryCollection geometryCollection, int n) throws Exception {
        ShapeHandler shapeHandler = geometryCollection.getNumGeometries() == 0 ? new PointHandler() : Shapefile.getShapeHandler(geometryCollection.getGeometryN(0), n);
        int n2 = geometryCollection.getNumGeometries();
        this.shapeType = shapeHandler.getShapeType();
        this.version = 1000;
        this.fileCode = 9994;
        this.bounds = geometryCollection.getEnvelopeInternal();
        this.fileLength = 0;
        for (int i = 0; i < n2; ++i) {
            this.fileLength += shapeHandler.getLength(geometryCollection.getGeometryN(i));
            this.fileLength += 4;
        }
        this.fileLength += 50;
        this.indexLength = 50 + 4 * n2;
    }

    public void setFileLength(int n) {
        this.fileLength = n;
    }

    public void write(EndianDataOutputStream endianDataOutputStream) throws IOException {
        int n;
        int n2 = 0;
        endianDataOutputStream.writeIntBE(this.fileCode);
        n2 += 4;
        for (n = 0; n < 5; ++n) {
            endianDataOutputStream.writeIntBE(0);
            n2 += 4;
        }
        endianDataOutputStream.writeIntBE(this.fileLength);
        n2 += 4;
        endianDataOutputStream.writeIntLE(this.version);
        n2 += 4;
        endianDataOutputStream.writeIntLE(this.shapeType);
        n2 += 4;
        endianDataOutputStream.writeDoubleLE(this.bounds.getMinX());
        endianDataOutputStream.writeDoubleLE(this.bounds.getMinY());
        endianDataOutputStream.writeDoubleLE(this.bounds.getMaxX());
        endianDataOutputStream.writeDoubleLE(this.bounds.getMaxY());
        n2 += 32;
        for (n = 0; n < 4; ++n) {
            endianDataOutputStream.writeDoubleLE(0.0);
            n2 += 8;
        }
    }

    public void writeToIndex(EndianDataOutputStream endianDataOutputStream) throws IOException {
        int n;
        int n2 = 0;
        endianDataOutputStream.writeIntBE(this.fileCode);
        n2 += 4;
        for (n = 0; n < 5; ++n) {
            endianDataOutputStream.writeIntBE(0);
            n2 += 4;
        }
        endianDataOutputStream.writeIntBE(this.indexLength);
        n2 += 4;
        endianDataOutputStream.writeIntLE(this.version);
        n2 += 4;
        endianDataOutputStream.writeIntLE(this.shapeType);
        n2 += 4;
        n2 += 8;
        endianDataOutputStream.writeDoubleLE(this.bounds.getMinX());
        n2 += 8;
        endianDataOutputStream.writeDoubleLE(this.bounds.getMinY());
        n2 += 8;
        endianDataOutputStream.writeDoubleLE(this.bounds.getMaxX());
        n2 += 8;
        endianDataOutputStream.writeDoubleLE(this.bounds.getMaxY());
        for (n = 0; n < 4; ++n) {
            endianDataOutputStream.writeDoubleLE(0.0);
            n2 += 8;
        }
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public int getVersion() {
        return this.version;
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public String toString() {
        String string = new String("Sf-->type " + this.fileCode + " size " + this.fileLength + " version " + this.version + " Shape Type " + this.shapeType);
        return string;
    }
}

