/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.Version;
import genj.app.App;
import genj.util.EnvironmentChecker;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

class ActionAbout
extends Action2 {
    private static final Resources RES = Resources.get(ActionAbout.class);
    private static final ImageIcon IMG = new ImageIcon(ActionAbout.class, "images/About.png");

    protected ActionAbout() {
        this.setText(RES, "cc.menu.about");
        this.setImage(IMG);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DialogHelper.openDialog(RES.getString("cc.menu.about"), 1, new Content(), (Action[])Action2.okOnly(), (Object)actionEvent);
    }

    private class Content
    extends JTabbedPane {
        private static final int DEFAULT_ROWS = 16;
        private static final int DEFAULT_COLS = 40;

        Content() {
            JLabel jLabel = new JLabel(new ImageIcon(this, "/splash.png"));
            jLabel.setBackground(Color.WHITE);
            jLabel.setOpaque(true);
            this.addTab("GenealogyJ " + Version.getInstance().getVersionString(), null, jLabel);
            this.addTab(RES.getString("about.authors"), null, new AuthorsPanel());
            this.addTab(RES.getString("about.copyright"), null, new CopyrightPanel());
        }

        protected void readTextFile(JTextArea jTextArea, String string) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                jTextArea.read(inputStreamReader, null);
                fileInputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private class Log
        extends Action2 {
            Log() {
                this.setText("Log");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Desktop.getDesktop().open(App.LOGFILE);
                }
                catch (Throwable throwable) {
                    Logger.getLogger("genj.io").log(Level.INFO, "can't open logfile", throwable);
                }
            }
        }

        private class CopyrightPanel
        extends JPanel {
            protected CopyrightPanel() {
                super(new BorderLayout());
                this.add((Component)this.getNorth(), "North");
                this.add((Component)this.getCenter(), "Center");
            }

            private JComponent getNorth() {
                JTextArea jTextArea = new JTextArea(RES.getString("app.disclaimer"), 3, 40);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setEditable(false);
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(RES.getString("about.copyright")), new EmptyBorder(3, 3, 3, 3)));
                jPanel.add((Component)jTextArea, "Center");
                return jPanel;
            }

            private JComponent getCenter() {
                JTextArea jTextArea = new JTextArea(16, 40);
                String string = EnvironmentChecker.getProperty("user.dir", ".", "read gpl.txt");
                String string2 = string + File.separatorChar + "doc" + File.separatorChar + "gpl.txt";
                Content.this.readTextFile(jTextArea, string2);
                jTextArea.setLineWrap(false);
                jTextArea.setEditable(false);
                jTextArea.setBorder(new EmptyBorder(3, 3, 3, 3));
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.setHorizontalScrollBarPolicy(30);
                jScrollPane.setBorder(BorderFactory.createTitledBorder(RES.getString("about.license")));
                return jScrollPane;
            }
        }

        private class AuthorsPanel
        extends JScrollPane {
            protected AuthorsPanel() {
                JTextArea jTextArea = new JTextArea(16, 40);
                jTextArea.setLineWrap(false);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setEditable(false);
                String string = EnvironmentChecker.getProperty("user.dir", ".", "get authors.txt");
                String string2 = string + File.separatorChar + "doc" + File.separatorChar + "authors.txt";
                Content.this.readTextFile(jTextArea, string2);
                this.setViewportView(jTextArea);
                this.setVerticalScrollBarPolicy(20);
                this.setHorizontalScrollBarPolicy(30);
            }
        }
    }
}

